# coding: UTF-8
module RDGC
  module Monster
    module MonsterStatus
      include Character::Status

      def status_type
        @status_type
      end

      def init(st, lv)
        return if @created
        @lv = lv
        @status_type = st
        create_status
      end

      def exp
        ret = (lv.to_f * status_type.exp_ratio).floor
        ret > 0 ? ret : 1
      end

      def init_status
        update_timer_status
      end

      private

      def create_status
        return if @created

        @raw_str = status_type.create_status_from_lv(:str, lv)
        @raw_agi = status_type.create_status_from_lv(:agi, lv)
        @raw_vit = status_type.create_status_from_lv(:vit, lv)
        @raw_int = status_type.create_status_from_lv(:int, lv)
        @raw_dex = status_type.create_status_from_lv(:dex, lv)
        @raw_luk = status_type.create_status_from_lv(:luk, lv)
        @raw_max_hp = status_type.create_status_from_lv(:hp, lv)
        @raw_max_sp = status_type.create_status_from_lv(:sp, lv)

        @view_range = status_type.view_range

        update_timer_status

        @created = true
      end

    end
  end
end
