# coding: UTF-8
module RDGC
  module Monster
    class Base < Character::Base
      include MonsterStatus

      class << self

        def set_monster_name(n)
          @monster_name = n
        end
        alias :monster_name_is :set_monster_name
        alias :monster_name= :set_monster_name

        def monster_name
          @monster_name
        end

        def status_type(st)
          @status_type = st
        end

        def status_type_class
          @status_type
        end

        def create(lv)
          mons = self.new
          mons.extend(Util::Config::battle_roll_module)
          mons.init(status_type_class, lv)
          mons.full_heal_hp
          mons.full_heal_sp
          mons
        end

      end

      def monster_name
        self.class.monster_name
      end
      alias :name :monster_name

      def reaction_to(a)
        return unless a.kind_of?(Character::Player)
        attacked_from(a)
      end

      # override
      def before_attack(a)
        # need override
      end

      # override
      def judge_attack_result(d, rsl, val)
        return unless d.kind_of?(Character::Player)

        case rsl
        when :critical
          Message::MessageManager.add(:monstar_attack_critical,
          :player_name => d.name, :monster_name => self.name, :damage => val)
        when :hit
          Message::MessageManager.add(:monstar_attack_hit,
          :player_name => d.name, :monster_name => self.name, :damage => val)
        when :miss
          Message::MessageManager.add(:monstar_attack_miss,
          :player_name => d.name, :monster_name => self.name)
        when :fumble
          Message::MessageManager.add(:monstar_attack_fumble,
          :player_name => d.name, :monster_name => self.name)
        end

        val
      end

      # override
      def after_attack(d, rsl, val)
        # need override
      end

      # override
      def close_attack(d)
        return unless d.kind_of?(Character::Player)
        return unless d.disable?
        Message::MessageManager.add(:player_dead,
          :player_name => d.name, :monster_name => self.name)
      end

    end
  end
end
