# coding: UTF-8
module RDGC
  module Monster
    module ActiveChaseType
      include MonsterActionBase

      def chase_try_count
        @chase_try_count ||= 2
        @chase_try_count
      end

      def chase_try_count=(c)
        @chase_try_count = c if c > 0
      end

      def state
        @state ||= :non_active
        @state
      end

      def to_active
        @state = :active
      end

      def to_non_active
        @state = :non_active
      end

      def active?
        state == :active ? true : false
      end

      def non_active?
        state == :non_active ? true : false
      end

      def check_state
        case
        when active?
          check_state_for_active
        when non_active?
          check_state_for_non_active
        end
      end

      def check_state_for_active
        # chase_missが一定回数を超えたらnon_active
        return if chase_miss_count < chase_try_count
        clear_miss_count
        to_non_active
      end

      def check_state_for_non_active
        # 興味のあるものがあるか
        return unless select_target(floor.search(self.x, self.y, view_range))
        to_active
      end

      # override
      def monster_action
        check_state

        case
        when active?
          active_action
        when non_active?
          non_active_action
        end
      end

      # override if need
      def active_action
        chase_move
      end

      # override if need
      def non_active_action
        random_move
      end

    end
  end
end
