# coding: UTF-8
module RDGC
  module Core
    class TimeKeeper

      def timers
        @timers ||= []
        @timers
      end

      def add_timer(t)
        return unless t
        timers << t
      end
      alias :<< :add_timer

      def next
        # 不要なTimerを削除
        clean

        # 次のTimerを取得
        proceed
      end

      def update(count = 1)
        timers.each{|t| t.update(count)}
      end

      private

      def proceed
        return if timers.empty?

        # カウントを進める
        add_count = timers.min_by(&:next_count).next_count
        update(add_count) if add_count > 0

        # 時間が来ているものを分離
        acts = timers.select{|t| t.action_ok?}
        return if acts.empty? # 通常ありえない

        # もっとも待たされているTimerを返す
        acts.sort_by{|t| t.next_time}.first
      end

      def clean
        timers.delete_if{|t| t.finish?}
        timers.delete_if{|t| t.respond_to?(:disable?) && t.disable?}
      end

    end
  end
end
