# coding: UTF-8
module RDGC
  module Core
    class GameMaster

      class << self

        def add_scene(name, s_class)
          scene[name] = s_class
        end

        def init(params = nil)
          Device::Runner.init(params)
        end

        def start(name, start_params = nil)
          gm = self.new(name, start_params)
          gm.turn_to(name)
          gm.run
        end

        def scene_class(name)
          scene[name]
        end

        def scene
          @scene ||= {}
          @scene
        end

      end

      def initialize(name, default_param = nil)
        @params = default_param
        @next = name
        turn_scene
      end

      def params
        @params ||= {}
        @params
      end

      def scene_name
        @scene_name
      end

      def turn_to(name)
        @mode = :turn
        @next = name
      end

      def finish
        @mode = :finish
        @next = nil
      end

      def run
        Device::Runner.run do
          @scene.pre
          @scene.run
          @scene.render

          case @mode
          when :finish
            @scene.destory if @scene
            break
          when :turn
            turn_scene
          end
        end
      end

      private

      def turn_scene
        s_class = self.class.scene_class(@next)

        @scene.destory if @scene
        @scene = s_class.start(self)
        @scene_name = @next

        @mode = :run
        @next = nil
      end

    end
  end
end