# coding: UTF-8
module RDGC
  module Character
    module BattleRoll

      def attack_to(d)
        self.before_attack(d)
        d.before_attack(self)

        rsl, val = attack_roll(d)
        v = judge_attack_result(d, rsl, val)
        d.reduce_hp(v)

        self.after_attack(d, rsl, v)
        d.after_attack(self, rsl, v)

        d.disable if d.hp <= 0
        close_attack(d)
      end

      def attacked_from(a)
        return unless a
        a.attack_to(self)
      end

      def roll_dice
        4.d6
      end

      def critical
        21
      end

      def fumble
        6
      end

      def critical_ratio
        2.0
      end

      def atk
        self.wep_atk + self.str
      end

      def pdef
        self.arm_def + self.vit
      end

      def hit_revise
        14
      end

      def hit
        self.dex + (self.lv/2.0).ceil
      end

      def flee
        self.agi + (self.lv/5.0).ceil
      end

      def damage_point
        d = 0
        (self.atk/10.0).ceil.times{d += 2.d6}
        d += (self.wep_atk + (self.str/2.0).ceil)
        d
      end

      def reduce_point
        r = 0
        (self.pdef/10.0).ceil.times{r += 2.d6}
        r += (self.arm_def + (self.vit/5.0).ceil)
        r
      end

      def attack_roll(d)
        hit_dice = roll_dice
        flee_dice = roll_dice
        hit_roll = self.hit +  hit_dice  + hit_revise
        flee_roll = d.flee + flee_dice

        crit = false
        case
        when hit_dice >= critical
          crit = true
        when hit_dice <= fumble
          return [:fumble, 0]
        when hit_roll < flee_roll
          return [:miss, 0]
        end

        dm = (crit ? (damage_point * critical_ratio).ceil : damage_point)
        val = dm - d.reduce_point
        min_val = crit ? self.dex : (self.dex/5.0).ceil
        val = val > min_val ? val : min_val

        crit ? [:critical, val] : [:hit, val]
      end

    end
  end
end
