# coding: UTF-8
module RDGC
  module Monster
    class MonsterStatusType < Character::StatusDefinitionBase

      class << self

        def set_exp_ratio(r)
          @exp_ratio = r
        end
        alias :exp_ratio_is :set_exp_ratio
        alias :exp_ratio= :set_exp_ratio

        def exp_ratio
          @exp_ratio ||= 1.0
          @exp_ratio
        end

        def create_status_from_lv(stat, lv)
          base = self.__send__("#{stat}_base".to_sym)
          up_ratio = self.__send__("#{stat}_up_ratio".to_sym)

          ratio = 0
          msrl = Util::Config.monster_status_random_level
          lv.times{ratio += range_rand(10 - msrl, 10 + msrl)}

          base + up_ratio * ratio * 0.1
        end

      end

    end
  end
end
