# coding: UTF-8
require 'dxruby'

module RDGC
  module Device

    class In

      class << self

        def up?
          Input.keyPush?(K_UP) ? true : false
        end

        def down?
          Input.keyPush?(K_DOWN) ? true : false
        end

        def left?
          Input.keyPush?(K_LEFT) ? true : false
        end

        def right?
          Input.keyPush?(K_RIGHT) ? true : false
        end

        def accept_button?
          Input.keyPush?(K_SPACE) ? true : false
        end

        def escape_key?
          Input.keyPush?(K_ESCAPE) ? true : false
        end

        def push_dir_key?
          return true if up?
          return true if down?
          return true if left?
          return true if right?
          false
        end

      end

    end

    class Runner

      class << self

        def init(params = nil)
          params ||= {}
          Window.caption = params[:caption] if params[:caption]
          Window.fps = params[:fps].to_i if params[:fps]
        end

        def run(&block)
          Window.loop(&block)
        end

      end

    end

  end
end
