# coding: UTF-8
module RDGC
  module Device

    class In

      class << self

        def push_key(name)
          @state = name
        end

        def reset_key
          @state = nil
        end

        def up?
          @state == :up ? true : false
        end

        def down?
          @state == :down ? true : false
        end

        def left?
          @state == :left ? true : false
        end

        def right?
          @state == :right ? true : false
        end

        def accept_button?
          @state == :accept_button ? true : false
        end

        def escape_key?
          @state == :escape_key ? true : false
        end

        def push_dir_key?
          return true if up?
          return true if down?
          return true if left?
          return true if right?
          false
        end

      end

    end

  end
end
