# coding: UTF-8
module RDGC
  module Core
    module DungeonScene

      # override
      def init
        Message::MessageManager.clear

        if params[:stashed]
          pop_params
          return
        end

        init_dungeon_scene

        move_floor(floor_number)
      end

      # override
      def run
        return if pre_judge
        rsl = dungeon_master.proceed
        judge(rsl) if rsl
      end

      def init_dungeon_scene
        # need override
      end

      def dungeon_master
        @dungeon_master
      end

      def dungeon_master=(dm)
        @dungeon_master = dm
      end

      def floor_number
        @floor_number ||= 1
        @floor_number
      end

      def floor_number=(fn)
        @floor_number = fn
      end

      def player
        @player
      end

      def player=(pl)
        @player = pl
      end

      def player_timers
        @player_timers ||= []
        @player_timers
      end

      def stash_params
        params[:stashed] = true
        params[:dungeon_master] = dungeon_master
        params[:floor_number] = floor_number
        params[:player] = player
        params[:player_timers] = player_timers
      end

      def pop_params
        return unless params[:stashed]

        params[:stashed] = false
        @dungeon_master = params[:dungeon_master]
        @floor_number = params[:floor_number]
        @player = params[:player]
        @player_timers = params[:player_timers]
      end

      def move_floor(num)
        self.floor_number = num
        self.dungeon_master = create_master
        self.player_timers.each{|pt| dungeon_master.time_keeper << pt}
        self.dungeon_master.floor.open_blind
      end

      def create_master
        # need override
      end

      def pre_judge
        # need override
      end

      def judge(rsl)
        # need override
      end

    end
  end
end