# coding: UTF-8
module RDGC
  module Character
    module Status
      include Article::TimeControlled

      def lv
        @lv ||= 1
        @lv.floor
      end

      def hp
        return 0 unless @hp
        @hp
      end

      def sp
        return 0 unless @sp
        @sp
      end

      def str
        @raw_str >= 1.0 ? @raw_str.floor : 1
      end

      def agi
        @raw_agi >= 1.0 ? @raw_agi.floor : 1
      end

      def vit
        @raw_vit >= 1.0 ? @raw_vit.floor : 1
      end

      def int
        @raw_int >= 1.0 ? @raw_int.floor : 1
      end

      def dex
        @raw_dex >= 1.0 ? @raw_dex.floor : 1
      end

      def luk
        @raw_luk >= 1.0 ? @raw_luk.floor : 1
      end

      def max_hp
        @raw_max_hp >= 1.0 ? @raw_max_hp.floor : 1
      end

      def max_sp
        @raw_max_sp >= 1.0 ? @raw_max_sp.floor : 1
      end

      def wep_atk
        return 0 unless @wep_atk
        @wep_atk.floor
      end

      def arm_def
        return 0 unless @arm_def
        @arm_def.floor
      end

      def view_range
        @view_range ||= 2
        @view_range
      end

      # override
      def act_cycle
        Util::Config.act_max_count - agi
      end

      # override
      def act_ratio
        @act_ratio ||= 1.0
        @act_ratio
      end

      def reduce_hp(val)
        @hp ||= 0
        @hp -= val
        @hp = 0 if @hp <= 0
      end

      def reduce_sp(val)
        @sp ||= 0
        @sp -= val
        @sp = 0 if @sp <= 0
      end

      def heal_hp(val)
        @hp += val
        @hp = max_hp if @hp > max_hp
      end

      def heal_sp(val)
        @sp += val
        @sp = max_sp if @sp > max_sp
      end

      def full_heal_hp
        @hp = max_hp
      end

      def full_heal_sp
        @sp = max_sp
      end

    end
  end
end