# coding: UTF-8
module RDGC
  module Character
    class Job < StatusDefinitionBase

      class << self

        def set_job_name(name)
          @job_name = name
        end
        alias :job_name_is :set_job_name
        alias :job_name= :set_job_name

        def job_name
          @job_name
        end

        def set_next_lv_exp_ratio(r)
          @next_lv_exp_ratio = r
        end
        alias :next_lv_exp_ratio_is :set_next_lv_exp_ratio
        alias :next_lv_exp_ratio= :set_next_lv_exp_ratio

        def next_lv_exp_ratio
          @next_lv_exp_ratio ||= 1.0
          @next_lv_exp_ratio
        end

        # if need override
        def next_lv_exp_base(lv)
          (lv+1)**2
        end

        def status_from_lv(stat, lv)
          base = self.__send__("#{stat}_base".to_sym)
          ratio = self.__send__("#{stat}_up_ratio".to_sym)
          base + ratio * lv.to_f
        end

        def next_lv_exp(lv)
          (next_lv_exp_base(lv) * next_lv_exp_ratio).ceil
        end

      end

    end
  end
end
