# coding: UTF-8
module RDGC
  module Article
    class Base

      attr_accessor :x, :y, :floor

      def set(x, y)
        self.x = x
        self.y = y
        self
      end

      def invisible(f = true)
        @invisible = f
        self
      end

      def visible(f = true)
        @invisible = ! f
        self
      end

      def invisible?
        @invisible
      end

      def visible?
        ! invisible?
      end

      def disable(f = true)
        @disable = f
        self
      end

      def enable(f = true)
        @disable = ! f
        self
      end

      def disable?
        @disable
      end

      def enable?
        ! disable?
      end

      def exist?(ax, ay)
        return false if self.disable?
        return false unless self.x == ax
        return false unless self.y == ay
        true
      end

      def overlapable?
        true
      end

      def overlap?(a)
        return unless a
        return unless a.overlapable?
        a.exist?(self.x, self.y)
      end

      def collision?(x, y)
        return false unless exist?(x, y)
        return false if overlapable?
        true
      end

      def distance(dx, dy)
        (self.x - dx).abs + (self.y - dy).abs
      end

      def distance_to(a)
        return 0 unless a
        distance(a.x, a.y)
      end

      def directions(dx, dy)
        ret = []

        ret << Map::Direction::LEFT if self.x > dx
        ret << Map::Direction::RIGHT if self.x < dx
        ret << Map::Direction::UPPER if self.y > dy
        ret << Map::Direction::BOTTOM if self.y < dy
        ret << Map::Direction::SELF if ret.empty?

        ret
      end

      def directions_to(a)
        return [] unless a
        directions(a.x, a.y)
      end

      def reaction_to(a)
        # override if need
      end

    end
  end
end