# -*- coding: UTF-8 -*-
module ROgue01
  module Scene
    class PinkMazeGameMaster < RDGC::Scene::GameMaster

      def produce_dungeon
        case self.params[:game_mode]
        when :normal
          produce_normal_dungeon
        when :endless
          produce_endless_dungeon
        else
          produce_endless_dungeon
        end
      end

      def produce_normal_dungeon
        factroy = ROgue01::Dungeon::PinkMazeMonsterFactory.new(self.floor)
        factroy.game_mode = self.params[:game_mode]

        case floor
        when ROGUE_MAX_FLOOR
          maze = ROgue01::Dungeon::PinkMaze.create(self.player, self.floor,
          :monster_factory => factroy, :downstep => false, :monster_max_ratio => 5.0,
          :monster_pop_time=> ACT_MAX_COUNT*3, :visible_level => :normal)
          set_boss(maze)
        when 1
          maze = ROgue01::Dungeon::PinkMaze.create(self.player, self.floor,
          :monster_factory => factroy, :visible_level => :normal)
        else
          maze = ROgue01::Dungeon::PinkMaze.create(
          self.player, self.floor, :monster_factory => factroy)
        end

        maze
      end

      def produce_endless_dungeon
        ROgue01::Dungeon::PinkMaze.create(self.player, self.floor)
      end

      # override
      def judge(act_rsl)
        if @boss && @boss.disable?
          RDGC::Messages << %Q(#{@boss.name}から"熟しきったリンゴ"を手に入れた！)
          RDGC::Messages << "Press SPACE..."
          @ending = true
          return
        end

        if self.params[:game_mode] == :normal
          # 動かした回数
          add_turn_count if act_rsl.to_s.match(/^player/)
        end

        super
      end

      def ending?
        @ending
      end

      def set_boss(d)
        # BOSS座標取得
        x, y = d.random_point(false)

        # BOSS生成
        @boss = Monster::PinkBig.create(floor*3, x, y)
        @boss.boss_flag = true

        d.add_monster(@boss)
      end

      def add_turn_count
        @turn_count ||= 0
        @turn_count += 1
      end

      def turn_count
        @turn_count ||= 0
        @turn_count
      end

    end
  end
end
