# -*- coding: UTF-8 -*-
module ROgue01
  module Player
    class Swordman < RDGC::Actor::Character::Job

      def name
        'Swordman'
      end

      def str_base
        5.0
      end

      def agi_base
        2.0
      end

      def vit_base
       4.0
      end

      def int_base
        1.0
      end

      def dex_base
        3.0
      end

      def luk_base
        1.0
      end

      def str_up_ratio
        1
      end

      def agi_up_ratio
        0.5
      end

      def vit_up_ratio
        0.6
      end

      def int_up_ratio
        0.2
      end

      def dex_up_ratio
        0.7
      end

      def luk_up_ratio
        0.3
      end

      def hp_base
        20
      end

      def hp_up_ratio
        2.0
      end

      def max_hp_from_lv(lv, vit)
        hp_base + lv + (lv * hp_up_ratio * (1+vit*0.01)).ceil
      end

      def next_lv_exp(lv)
        ((lv+1)**2*1.5).ceil
      end

    end
  end
end
