# -*- coding: UTF-8 -*-
module RDGC
  module Map
    module TiledArea
      include TileType

      attr_accessor :top, :bottom, :left, :right

      def coordinates
        "t:#{top} b:#{bottom} l:#{left} r:#{right}"
      end

      alias :to_co :coordinates

      def height
        bottom - top + 1
      end

      def width
        right - left + 1
      end

      def has_xy?(x, y)
        return false if x < left
        return false if x > right
        return false if y < top
        return false if y > bottom
        true
      end

      def each
        each_x do |x|
          each_y do |y|
            yield(x, y)
          end
        end
      end

      def each_x
        (left..right).each do |x|
          yield(x)
        end
      end

      def each_y
        (top..bottom).each do |y|
          yield(y)
        end
      end

      def each_tile
        each do |x, y|
          yield(x, y, tile(x, y))
        end
      end

      def fill_tile(tile)
        each do |x, y|
          set_tile(x, y, tile)
        end
      end

      def set_tile(x, y, tile)
        return unless has_xy?(x, y)
        tile_data[x][y] = tile
      end

      def tile(x, y)
        return unless has_xy?(x, y)
        tile_data[x][y]
      end

      private

      def tile_data
        @tile_data ||= Hash.new{|hash, key| hash[key] = {}}
        @tile_data
      end

    end
  end
end
