# -*- coding: UTF-8 -*-
module RDGC
  module Map
    class Room < Area

      def self.create(top, bottom, left, right)
        room = super(top, bottom, left, right)
        room.fill
        room
      end

      def self.create_from_block(b)
        room_w = room_size(b.width)
        room_h = room_size(b.height)
        return if (room_w <= 0 || room_h <= 0)

        l_point = b.left+1 + room_point(b.width, room_w)
        t_point = b.top+1 + room_point(b.height, room_h)

        self.create(t_point, t_point + room_h - 1, l_point, l_point + room_w - 1)
      end

      def fill
        fill_tile TileType::ROOM
      end

      private

      def self.room_size(val)
        return 0 if (val - 3) < MIN_ROOM_SIZE
        # 部屋の最大サイズ = ブロックサイズ-壁1*2-通路1
        range_rand(MIN_ROOM_SIZE, val - 3)
      end

      def self.room_point(block_size, room_size)
        # 右と下は余分に空ける => 結ぶ通路は左と上が担当
        range_rand(0, block_size - 3 - room_size)
      end

    end
  end
end
