# -*- coding: UTF-8 -*-
module RDGC
  module Map
    class Article

      attr_accessor :x, :y

      def collision?(a)
        return false unless a
        exist?(a.x, a.y)
      end

      def relative_distance(a)
        return 0 unless a
        (self.x - a.x).abs + (self.y - a.y).abs
      end

      def exist?(x, y)
        return false if disable?
        return false unless self.x == x
        return false unless self.y == y
        true
      end

      def enable?
        ! disable?
      end

      def disable?
        @disable
      end

      def disable=(f)
        @disable = f
      end

      def visible?
        true
      end

      def overlap_ok?
        true
      end

      def effect_from(a)
      end

    end
  end
end