# -*- coding: UTF-8 -*-
module RDGC
  module Actor
    module Character
      module Status

        def lv
          @lv ||= 1
          @lv.floor
        end

        def str
          return 0 unless @raw_str
          @raw_str.floor
        end

        def agi
          return 0 unless @raw_agi
          @raw_agi.floor
        end

        def vit
          return 0 unless @raw_vit
          @raw_vit.floor
        end

        def int
          return 0 unless @raw_int
          @raw_int.floor
        end

        def dex
          return 0 unless @raw_dex
          @raw_dex.floor
        end

        def luk
          return 0 unless @raw_luk
          @raw_luk.floor
        end

        def hp
          return 0 unless @hp
          @hp
        end

        def max_hp
          return 0 unless @max_hp
          @max_hp
        end

        def wep_atk
          return 0 unless @wep_atk
          @wep_atk.floor
        end

        def arm_def
          return 0 unless @arm_def
          @arm_def.floor
        end

        def atk
          wep_atk + str
        end

        def pdef
          arm_def + vit
        end

        def hit
          dex + (lv/2.0).ceil
        end

        def flee
          agi + (lv/5.0).ceil
        end

        def damage_point
          d = 0
          (atk/10.0).ceil.times{d += 2.d6}
          d += (wep_atk + (str/2.0).ceil)
          d
        end

        def reduce_point
          r = 0
          (pdef/10.0).ceil.times{r += 2.d6}
          r += (arm_def + (vit/5.0).ceil)
          r
        end

        def reduce_hp(val)
          @hp ||= 0
          @hp -= val
          if @hp <= 0
            @disable = true
            @hp = 0
          end
        end

        def heal_hp(val)
          @hp += val
          @hp = max_hp if @hp > max_hp
        end

        def auto_heal_hp
          (max_hp * 0.01).ceil
        end

        def critical
          16
        end

        def fumble
          5
        end

        def critical_ratio
          2.0
        end

        def attack_to(c)
          hit_dice = 3.d6
          flee_dice = 3.d6

          crit = false
          if hit_dice >= critical
            crit = true
          elsif hit_dice <= fumble
            return [:fumble, 0]
          elsif (self.hit + hit_dice) < (c.flee + flee_dice)
            return [:miss, 0]
          end

          dm = self.damage_point
          dm = (dm * critical_ratio).ceil if crit

          val = dm - c.reduce_point
          min_val = crit ? self.dex : (self.dex/5.0).ceil
          val = val > min_val ? val : min_val
          c.reduce_hp(val)

          crit ? [:critical, val] : [:hit, val]
        end

      end
    end
  end
end
