# -*- coding: UTF-8 -*-
module RDGC
  module Actor
    module Character
      class Character < Map::Article
        include Actor
        include Timer::TimerOwner

        def overlap_ok?
          false
        end

        def view_range
          @view_range
        end

        def move_to_dir(d, dir)
          nx, ny = dir.apply_to(self.x, self.y)
          move(d, nx, ny)
        end

        def move(d, nx, ny)
          return false unless d.board.movable?(nx, ny)

          # 移動先の物体を全て取得
          list = d.articles(nx, ny)

          # 何もなければ移動
          if list.empty?
            _move(nx, ny)
            return true
          end

          # 上に乗れるものと乗れないものに分ける
          over_list, not_list = list.partition(&:overlap_ok?)

          # 生存している限り各物体から影響を受ける
          not_list.each do |a|
            a.effect_from(self)
            break if disable?
          end

          # 生存してなければ移動できない
          return false if disable?

          # 上に乗れないものが残っていれば移動できない
          return false unless not_list.empty?

          # 移動
          _move(nx, ny)

          # 移動先で踏んだものから影響を受ける
          unless over_list.empty?
            over_list.each do |a|
              a.effect_from(self)
              break if disable?
            end
          end

          true
        end

        private

        def _move(nx, ny)
          self.x = nx
          self.y = ny
        end

      end
    end
  end
end