# -*- coding: UTF-8 -*-
require 'dxruby'
require 'kconv'

class String
  def conv_sjis
    self.kconv(Kconv::SJIS, Kconv::UTF8)
  end
end

# load config
module RDGC
  module Setting
    MIN_ROOM_SIZE = 4
    MIN_BLOCK_SIZE = MIN_ROOM_SIZE+3
    ACT_MAX_COUNT = 200
  end
end
include RDGC::Setting


# RDGC requires
require 'rdgc/util/random_util'
include RDGC::Util::RandomUtil

require 'rdgc/map/tile'
require 'rdgc/map/tile_type'
require 'rdgc/map/tiled_area'
require 'rdgc/map/area'
require 'rdgc/map/block'
require 'rdgc/map/room'
require 'rdgc/map/road'
require 'rdgc/map/board'
require 'rdgc/map/direction'
require 'rdgc/map/article'
require 'rdgc/map/step'

require 'rdgc/timer/timer'
require 'rdgc/timer/timer_owner'
require 'rdgc/timer/auto_healing_timer'
require 'rdgc/timer/monster_pop_timer'

require 'rdgc/actor/actor'
require 'rdgc/actor/strategy_board'
require 'rdgc/actor/character/character'
require 'rdgc/actor/character/status'
require 'rdgc/actor/character/job'
require 'rdgc/actor/character/player_status'
require 'rdgc/actor/character/monster_status'
require 'rdgc/actor/character/player'
require 'rdgc/actor/character/monster'

require 'rdgc/dungeon/monster_factory'
require 'rdgc/dungeon/dungeon'

require 'rdgc/scene/scene'
require 'rdgc/scene/game_master'

# TODO 新しいやり方
require 'rdgc/messages'

def start_scene(scene_class, default_param = nil)
  RDGC::Scene::Manager.start_from(scene_class, default_param)
end

alias :run :start_scene
