# -*- coding: UTF-8 -*-
module RDGC
  module Actor

    class Positon

      attr_accessor :distance

      def dir
        @dir ||= []
        @dir
      end

      def add(d)
        return if dir.include?(Map::Direction::SELF)
        return if dir.include?(d)
        dir << d
        dir.delete(Map::Direction.opposite(d))
      end

      def set(d)
        @dir = [d]
      end
    end

    class StrategyBoard

      FindArticle = Struct.new :article, :position

      attr_reader :range

      def self.create(range)
        return unless range > 0
        @@__strategy_board_cache ||= {}

        unless @@__strategy_board_cache[range]
          obj = self.new
          obj.instance_eval do
            make(range)
          end
          @@__strategy_board_cache[range] = obj
        end

        @@__strategy_board_cache[range]
      end

      def search(d, sx, sy)
        list = []

        each do |x, y, pos|
          next unless pos
          d.articles(sx+x, sy+y).each do |a|
            obj = FindArticle.new
            obj.article = a
            obj.position = pos
            list << obj
          end
        end

        list
      end

      def each
        ((-self.range)..self.range).each do |x|
          ((-self.range)..self.range).each do |y|
            yield(x, y, board[x][y])
          end
        end
      end

      private

      def range=(r)
        r > 0 ? @range = r : @range = 0
      end

      def make(range)
        return unless range > 0
        self.range = range

        # 始点に値書き込み
        set_position(Map::Direction::SELF, 0, 0, 0)

        # 順に適用していく
        Map::Direction.each do |dir|
          sx, sy = dir.apply_to(0, 0)
          fill(dir, sx, sy, 1)
        end
      end

      def fill(base_dir, x, y, dis)
        return unless base_dir
        return if dis > self.range

        # 座標に値書き込み
        set_position(base_dir, x, y, dis)

        Map::Direction.each do |dir|
          # 自分自身の周囲の座標値を取得
          nx, ny = dir.apply_to(x, y)

          # 新しいポイントで再帰処理
          fill(base_dir, nx, ny, dis+1)
        end
      end

      def board
        @__board ||= Hash.new{|h, k| h[k] = Hash.new}
        @__board
      end

      def set_position(dir, x, y, dis)
        unless board[x][y]
          p = Positon.new
          p.distance = dis
          p.set(dir)
          board[x][y] = p
        else
          pos = board[x][y]
          if pos.distance > dis
            pos.set(dir)
            pos.distance = dis
          elsif pos.distance == dis
            pos.add(dir)
          end
        end
      end

    end
  end
end
