// TCoachAgent.h: interface for the TCoachAgent class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TCOACHAGENT_H__C9352BF5_8902_11D1_B242_0000C09B5CBE__INCLUDED_)
#define AFX_TCOACHAGENT_H__C9352BF5_8902_11D1_B242_0000C09B5CBE__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "TBaseAgent.h"
#include "TParseString.h"
#include "SoccermonitorDoc.h"
#include "param.h"

#include <math.h>

class CSoccermonitorDoc;

class TCoachAgent : public TBaseAgent  
{
public:
    TCoachAgent(CSoccermonitorDoc*	pDoc);
    virtual ~TCoachAgent();
    
    // overridables
    BOOL  Connect();
    virtual void OnCreatedSocket();
    virtual void OnReceivedMessage(LPCTSTR message);
    
    void start()
    {
        M_running = true;
        M_play_on = true;
        doChangeMode(PM_PLAY_ON);
    }
    void reset()
    {
        M_running = false;
        M_play_on = false;
    }
    bool isRunning() const
    {
        return M_running;
    }

    // methods
    void	DoCoaching();
    void	SetPlayOn();
    
    // basic methods
    void doChangeMode(int mode);
    void doCoachMove(LPCTSTR objname, double x, double y, double vdir);
    void doMoveBall(const double& x, const double& y)
    {
        doCoachMove("ball", x, y, 0);
    }
    void doMovePlayer(const int side, const int unum,
                      const double& x, const double& y,
                      const double& vdir);
    void doLook();
    void doCheckBall();
    void doEar();
    bool isEyeOn() const
    {
        return M_eye_on;
    }
    void doEye();
    bool isEarOn() const
    {
        return M_ear_on;
    }
    void    Say(CString msg);
    //  parse message
    void    ParseHearMsg(TParseString msg);
    void    ParseSightInf(TParseString inf);
    void    ProcessHearMsg(int time, CString TeamName, int No, CString hearmsg);
    void	HearModeChanged();
    void    ResetValues();
    
    PlayMode playmode;

private:
    bool M_running;
    bool M_play_on;
    bool M_eye_on;
    bool M_ear_on;

    int CurrentTime;
    BOOL m_bGoal;
    BOOL m_bOutOfField;
    CString IP;
    int  port;    

    CString M_left_team_name;
    CString M_right_team_name;
};

#endif // !defined(AFX_TCOACHAGENT_H__C9352BF5_8902_11D1_B242_0000C09B5CBE__INCLUDED_)
