// TCoachAgent.cpp: implementation of the TCoachAgent class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SoccermonitorDoc.h"
#include "SoccermonitorView.h"
#include "TCoachAgent.h"
#include "TParseString.h"
#include <math.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

TCoachAgent::TCoachAgent(CSoccermonitorDoc*	pDoc)
{
    M_running = false;
    M_play_on = false;
    M_ear_on = false;
    M_eye_on = false;

	m_bGoal = FALSE;
	m_bOutOfField = FALSE;
	m_pDoc = pDoc;
    IP = pDoc->serverHost();
    port = pDoc->coachPort();
	//GetOptions(2, buf);
}

TCoachAgent::~TCoachAgent()
{
    reset();
}


/*-----------------------------------------------------------------------------
Function: void TViewingAgent::Connect()
Date    : 14.11.97
-------------------------------------------------------------------------------
Parameter: none
Returnval: (void)
Description: tries to connect with the standard connection parameters. if not 
				 successfull, asks the user for new parameters
-----------------------------------------------------------------------------*/
BOOL TCoachAgent::Connect()
{/*
	DConnectionSetup Dialog;

	// delete the current doc
	//OnNewDocument();

	// ask the user for the name of the team and the server
	Dialog.m_strHandle = _T("Coach");
	Dialog.m_strServer = IP;
	Dialog.m_nChannel = port;


	ResetValues();
	// user can repeat with a different address
	while(TRUE)
	{
		// try to connect		
		if (Dialog.DoModal() != IDOK)
			return;
		if (ConnectAgent(Dialog.m_strHandle, Dialog.m_strServer, Dialog.m_nChannel)){
			IP = Dialog.m_strServer;
			port = Dialog.m_nChannel;
			return;
		}
	}*/
	if (ConnectAgent("Coach", IP , port )){
		return TRUE;
	}
	return FALSE;
}

void TCoachAgent::OnCreatedSocket()
{
}


/*-----------------------------------------------------------------------------
Function: void TCoachAgent::DoCoaching(void)
Date    : 12.01.98
-------------------------------------------------------------------------------
Parameter: none
Returnval: (void)
Description: main function to controll the players and the ball
-----------------------------------------------------------------------------*/
//BOOL tmp = FALSE;

void TCoachAgent::DoCoaching(void)
{
}

/*-----------------------------------------------------------------------------
Function: void TCoachAgent::SetPlayOn()
Date    : 20.01.98
-------------------------------------------------------------------------------
Parameter: none
Returnval: (void)
Description: sets the playmode of play on
-----------------------------------------------------------------------------*/
void TCoachAgent::SetPlayOn()
{
    doChangeMode(PM_PLAY_ON);
}


/*-----------------------------------------------------------------------------
Function: void TCoachAgent::OnReceivedMsg(LPCTSTR message)
Date    : 19.01.98
-------------------------------------------------------------------------------
Parameter: string containing the message received from the socket (server)
Returnval: (void)
Description: parses a received message
-----------------------------------------------------------------------------*/
void TCoachAgent::OnReceivedMessage(LPCTSTR message)
{
	TParseString	str(message);
	CString			temp,msg;
	int time;

	// overread leading bracket
	str.ParseBracket(str);
	//str.m_iPosition = 1;
	str.ParseString(temp);
	if ( temp.Compare("ok") != 0 )
	{
	   // it is an error or hear message
		if ( temp.Compare("hear") == 0 )
        {
			ParseHearMsg(str);			
		}
		else if ( temp.Compare("error") == 0 )
        {
			str.ParseString(temp);
			m_pDoc->DisplayMessage(temp);
		}
		else if ( temp.Compare("see") == 0 )
        {
			ParseSightInf(str);
		}
	}
	else
	{
		// it is a response
		str.ParseString(temp);
		if ( temp.Compare("check_ball") == 0 )
		{
			// it is a check ball information
			// get the time
			m_pDoc->DisplayMessage(temp);
			time = str.ParseInteger();
			CurrentTime = time;
			str.ParseString(temp);
			m_pDoc->DisplayMessage(temp);
			if ( temp.Compare("in_field") == 0 )
			{
				// ball is in the field
				m_bGoal = FALSE;
				m_bOutOfField = FALSE;
			}
			else if ( temp.Compare("out_of_field") == 0 )
			{
				// ball is outside the field
				m_bGoal = FALSE;
				m_bOutOfField = TRUE;
			}
			else if ( temp.Compare("goal_l") == 0 || temp.Compare("goal_r") == 0 )
			{
				// it has been a goal
				m_bGoal = TRUE;
				m_bOutOfField = TRUE;
			}
		}
		else if( temp.Compare("change_mode") == 0 )
        {
			m_pDoc->DisplayMessage("Mode changed!");
		}
		else if ( temp.Compare("ear") == 0 )
        {
			str.ParseString(temp);
			msg.Format("ear %s",temp);
			m_pDoc->DisplayMessage(msg);
		}
        else if ( temp.Compare("eye") == 0 )
        {
			str.ParseString(temp);
			msg.Format("eye %s",temp);
			m_pDoc->DisplayMessage(msg);
		}
		else if( temp.Compare("look") == 0 )
        {
			ParseSightInf(str);
		}
		// all other ok informations are not relevant
	}
}

void TCoachAgent::ParseHearMsg(TParseString msg)
{
	int No;
	CString TeamName, temp, hearmsg, message;
	CurrentTime = msg.ParseInteger();		
	msg.ParseString(temp);
	if ( temp.Compare("referee") == 0 )
    {
		msg.ToString(hearmsg);
		message.Format("(Time %d) referee : %s", CurrentTime, hearmsg);
		m_pDoc->DisplayMessage(message);
        if ( hearmsg.Compare("play_on") == 0 )
        {
			playmode = PM_PLAY_ON;
		}
		else if( hearmsg.Compare("kick_off_r") == 0 )
        {
			playmode = PM_KICK_OFF_R;
		}
		else if ( hearmsg.Compare("kick_off_l") == 0 )
        {
			playmode = PM_KICK_OFF_L;
		}
		else if ( hearmsg.Compare("time_over") == 0 )
        {
			playmode = PM_TIME_OVER;
		}
		else if ( hearmsg.Compare("before_kick_off") == 0 )
        {
			playmode = PM_BEFORE_KICK_OFF;
		}
		else
        {
			playmode= PM_MAX;
		}
		HearModeChanged();
	}
	else
    {
		msg.ParseString(TeamName);
		No = msg.ParseInteger();
		msg.ParseString(hearmsg);
		msg.ToString(hearmsg);

		ProcessHearMsg(CurrentTime, TeamName, No, hearmsg);

		message.Format("(Time %d) %s NO.%d : %s\n",CurrentTime,TeamName,No,hearmsg);
		m_pDoc->DisplayMessage(message);
		/*  add you message process codes here */
	}
}

void TCoachAgent::ProcessHearMsg(int time, CString TeamName, int No, CString hearmsg)
{
	TParseString str(hearmsg),tstr1;
	CString temp;
	CString message;
	str.ParseBracket(tstr1);
	tstr1.ParseString(temp);
	int saytime = tstr1.ParseInteger();

	str.ParseString(temp);
}

void TCoachAgent::HearModeChanged()
{

} 

void TCoachAgent::ParseSightInf(TParseString inf)
{

}

void TCoachAgent::doMovePlayer(const int side, const int unum,
                               const double& x, const double& y,
                               const double& vdir)
{
	CString objname;
    switch ( side ) {
    case 1:
        if ( ! M_left_team_name.IsEmpty() )
        {
			objname.Format("player %s %d", M_left_team_name, unum);
            doCoachMove(objname, x, y, vdir);
		}
		else
        {
			m_pDoc->DisplayMessage("No player of left side seen!");
        }
        break;
    case -1:
		if ( ! M_right_team_name.IsEmpty() )
        {
			objname.Format("player %s %d", M_right_team_name, unum);
            doCoachMove(objname, x, y, vdir);
		}
		else
        {
			m_pDoc->DisplayMessage("No player of right side seen!");
        }
        break;
    default:
        break;
	}
}

void TCoachAgent::doCoachMove(LPCTSTR objname, double x, double y, double vdir)
{
	CString	message;
	message.Format("(move (%s) %.2f %.2f %.2f)", objname, x, y, vdir);
	SendMsg(message);
}

/*-----------------------------------------------------------------------------
Function: void TCoachAgent::doChangeMode(int mode)
Date    : 12.01.98
-------------------------------------------------------------------------------
Parameter: play mode to change to
Returnval: (void)
Description: changes the playmode
-----------------------------------------------------------------------------*/
void TCoachAgent::doChangeMode(int mode)
{
	if ( mode >= 0 && mode < PM_MAX )
	{
		CString	message;
		char* playmode[] = PLAYMODE_STRINGS;

		message.Format("Change mode to %s.",playmode[mode]);
		m_pDoc->DisplayMessage(message);
		message.Format("(change_mode %s)", playmode[mode]);
		SendMsg(message);
	}
}

void TCoachAgent::doCheckBall()
{
	SendMsg(CString("(check_ball)"));
}

void TCoachAgent::doLook()
{
	SendMsg(CString("(look)"));
}

void TCoachAgent::Say(CString msg)
{
	CString message;
	message.Format("(say training%s)",msg);
	SendMsg(message);
}

void TCoachAgent::doEye()
{
    M_eye_on = ! M_eye_on;
    if ( M_eye_on )
    {
		SendMsg(CString("(eye on)"));
    }
	else
    {
		SendMsg(CString("(eye off)"));
    }
}

void TCoachAgent::doEar()
{
    M_ear_on = ! M_ear_on;
    if ( M_ear_on )
    {
		SendMsg(CString("(ear on)"));
    }
    else
    {
        SendMsg(CString("(ear off)"));
    }
}

void TCoachAgent::ResetValues()
{
	m_bOutOfField = FALSE;
}

