// BaseAgent.h: interface for the CBaseAgent class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BASEAGENT_H__7FCEA561_5114_11D1_B242_0000C09B5CBE__INCLUDED_)
#define AFX_BASEAGENT_H__7FCEA561_5114_11D1_B242_0000C09B5CBE__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "Agentsock.h"

/*-----------------------------------------------------------------------------
Class   : CBaseAgent
Date    : 30.10.97
-------------------------------------------------------------------------------
Base Class: CObject

Description: base class for all agents
-----------------------------------------------------------------------------*/
class TBaseAgent : public CAgentSocket
{
public:

		//TBaseAgent(CSoccermonitorDoc* pdoc);
		TBaseAgent();
		virtual ~TBaseAgent();
		BOOL	ConnectAgent(LPCTSTR lpszTeam, LPCTSTR lpszServer, UINT nPort);
		void	DisconnectAgent(void);
 
		// communication functions
		virtual void OnReceive(int nErrorCode);
		void SendMsg(CString& strText);
	
		// overridables
		virtual void OnCreatedSocket();
		virtual void OnSentMessage(LPCTSTR message) {};
		virtual void OnReceivedMessage(LPCTSTR message) {};
		
		virtual void OnErrorCreatingSocket() {};
		virtual void OnErrorSendingMessage() {};
		virtual void OnErrorReceivingMessage() {};
		
		// the agents actions
		void	Move(double x, double y);
		void	Turn(double iMoment);
		void	Dash(double iPower);
		void	Kick(double iPower, double iDirection);
		void	Say(CString csMessage);
		void	ChangeView(int iWidth, int iQuality);

		void  MoveRel(int x);	// moves relative to the current position

protected:

		CString			m_strTeam;	// name of the team the player is in
	
		double				m_iPositionX;	// position of the agent x coordinate
		double				m_iPositionY;	// position of the agent y coordinate
		double				m_iDirection;	// view direction of the agent

    bool M_connected;

};

#endif // !defined(AFX_BASEAGENT_H__7FCEA561_5114_11D1_B242_0000C09B5CBE__INCLUDED_)
