// SoccermonitorView.h : interface of the CSoccermonitorView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_SOCCERMONITORVIEW_H__5C57B36D_5FF6_11D1_B242_0000C09B5CBE__INCLUDED_)
#define AFX_SOCCERMONITORVIEW_H__5C57B36D_5FF6_11D1_B242_0000C09B5CBE__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#define CONNECTION_TIMER	2
#define AUTORUN_TIMER		3
#define COACH_TIMER			4

class CSoccermonitorDoc;

class CSoccermonitorView : public CView
{
protected: // create from serialization only
	CSoccermonitorView();
	DECLARE_DYNCREATE(CSoccermonitorView)
	
// Attributes
public:
	CSoccermonitorDoc*	GetDocument();

    const CPoint& getRefereeFoulPoint() const
    {
        return M_referee_foul_point;
    };

private:

    static const int S_DEFAULT_CONNECTION_TIMEOUT_SEC;

	bool M_set_connect_timer;
	int	M_connect_timer_id;
	int	M_connect_timeout_sec;
    
    CPoint M_referee_foul_point;

    HCURSOR M_old_cursor;


	//for coach
    bool M_set_coach_timer;
	int M_coach_timer_id;
// Operations
public:

	void setConnectTimeout(int sec)
    {
        M_connect_timeout_sec = sec;
    }
	int	getConnectTimeout() const
    {
        return M_connect_timeout_sec;
    }
    void startConnectTimer();
    void stopConnectTimer();


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSoccermonitorView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSoccermonitorView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CSoccermonitorView)
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnDestroy();
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnDropFiles(HDROP hDropInfo);
	afx_msg void OnCoachStart();
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

#ifndef _DEBUG  // debug version in SoccermonitorView.cpp
inline CSoccermonitorDoc* CSoccermonitorView::GetDocument()
   { return (CSoccermonitorDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SOCCERMONITORVIEW_H__5C57B36D_5FF6_11D1_B242_0000C09B5CBE__INCLUDED_)
