// SaveLog.cpp : implementation file
//

#include "stdafx.h"
#include "soccermonitor.h"
#include "SaveLog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// SaveLog dialog


SaveLog::SaveLog(CWnd* pParent /*=NULL*/)
	: CDialog(SaveLog::IDD, pParent)
{
	//{{AFX_DATA_INIT(SaveLog)
	m_filename = _T("");
	//}}AFX_DATA_INIT

    M_logplayer = NULL;
    M_log_count_current = 0;
    M_log_count_max = 0;
}


void SaveLog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(SaveLog)
	DDX_Control(pDX, IDC_CHECK_SAVE_TEXT_PLAYER_TYPES, M_ctrl_record_player_types);
	DDX_Control(pDX, IDC_SPIN_SAVE_TEXT_END, M_spin_end_cycle);
	DDX_Control(pDX, IDC_SPIN_SAVE_TEXT_START, M_spin_start_cycle);
	DDX_Control(pDX, IDC_CHECK_SAVELOG_COUNT, M_ctrl_record_count);
	DDX_Control(pDX, IDC_CHECK_SERVER_PARAMS, M_ctrl_record_server_params);
	DDX_Control(pDX, IDC_CHECK_SAVELOG_DETAIL, M_ctrl_record_detail);
	DDX_Text(pDX, IDC_File_Name, m_filename);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(SaveLog, CDialog)
	//{{AFX_MSG_MAP(SaveLog)
	ON_BN_CLICKED(IDC_Browser, OnBrowser)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// SaveLog message handlers

int SaveLog::DoModal() 
{
	// TODO: Add your specialized code here and/or call the base class

	return CDialog::DoModal();
}

void SaveLog::OnBrowser() 
{
	// TODO: Add your control notification handler code here
	CFileDialog getfile(FALSE);
	getfile.m_ofn.lpstrFilter = "Text files(*.txt)\0*.txt\0\0";
    getfile.m_ofn.lpstrDefExt = "txt";
	if ( getfile.DoModal() != IDOK )
    {
		return;
    }

	UpdateData(TRUE);
	m_filename = getfile.GetPathName(); 
	UpdateData(FALSE);
}	

void SaveLog::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
    UpdateData(TRUE); // get data from dialog

    if ( M_logplayer )
    {
        int start = M_spin_start_cycle.GetPos();
        int end = M_spin_end_cycle.GetPos();

        if ( start > end )
        {
            AfxMessageBox("start cycle > end cycle !!");
        }
        else if ( start > M_log_count_max - 1 || end > M_log_count_max - 1 )
        {
            AfxMessageBox("log range over!!");
        }
        else
        {
            EnableWindow(FALSE); // ۑ̓_CAOւ̃ANZX֎~
            BeginWaitCursor(); // vJ[\\܂B
            M_logplayer->saveTextData(m_filename, start, end,
                                      M_ctrl_record_player_types.GetCheck(),
                                      M_ctrl_record_server_params.GetCheck(),
                                      M_ctrl_record_detail.GetCheck(),
                                      M_ctrl_record_count.GetCheck());
            EndWaitCursor(); // vJ[\܂B
        }
    }

	CDialog::OnOK();
    EnableWindow(TRUE);
}

BOOL SaveLog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
    M_spin_start_cycle.SetRange(0, M_log_count_max - 1);
    M_spin_end_cycle.SetRange(0, M_log_count_max - 1);

    M_spin_end_cycle.SetPos(M_log_count_current);

    UDACCEL spin_acc[4];
    spin_acc[0].nSec = 0;
    spin_acc[0].nInc = 1;
    spin_acc[1].nSec = 2;
    spin_acc[1].nInc = 10;
    spin_acc[2].nSec = 4;
    spin_acc[2].nInc = 50;
    spin_acc[3].nSec = 6;
    spin_acc[3].nInc = 200;
    M_spin_start_cycle.SetAccel(4, spin_acc);
    M_spin_end_cycle.SetAccel(4, spin_acc);

	// TODO: ̈ʒuɏ̕⑫ǉĂ
    if ( M_protocol_version < 2 )
    {
        M_ctrl_record_player_types.EnableWindow(FALSE);
        M_ctrl_record_server_params.EnableWindow(FALSE);
    	//M_ctrl_record_detail.EnableWindow(FALSE);
        M_ctrl_record_count.EnableWindow(FALSE);
    }
    else
    {
        M_ctrl_record_player_types.SetCheck(1);
        M_ctrl_record_server_params.SetCheck(0);
        M_ctrl_record_detail.SetCheck(1);
        M_ctrl_record_count.SetCheck(0);
    }

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}
