// PlayerTypeDialog.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "soccermonitor.h"
#include "PlayerTypeDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define WS_EX_LAYERED	0x80000
#define LWA_COLORKEY	1
#define LWA_ALPHA		2
typedef BOOL (WINAPI *SLWA)(HWND, COLORREF, BYTE, DWORD);


/////////////////////////////////////////////////////////////////////////////
// PlayerTypeDialog _CAO


PlayerTypeDialog::PlayerTypeDialog(CWnd* pParent /*=NULL*/)
	: CDialog(PlayerTypeDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(PlayerTypeDialog)
	M_id = _T("");
	M_speed_max = _T("");
	M_stamina_inc_max = _T("");
	M_decay = _T("");
	M_inertia_moment = _T("");
	M_dash_power_rate = _T("");
	M_size = _T("");
	M_kickable_margin = _T("");
	M_kick_rand = _T("");
	M_extra_stamina = _T("");
	M_effort_max = _T("");
	M_effort_min = _T("");
	M_real_speed_max = _T("");
	M_accel_max = _T("");
	//}}AFX_DATA_INIT
}


void PlayerTypeDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(PlayerTypeDialog)
	DDX_Text(pDX, IDC_PT_ID, M_id);
	DDV_MaxChars(pDX, M_id, 4);
	DDX_Text(pDX, IDC_PT_SPEED_MAX, M_speed_max);
	DDV_MaxChars(pDX, M_speed_max, 8);
	DDX_Text(pDX, IDC_PT_STAMINA_INC_MAX, M_stamina_inc_max);
	DDV_MaxChars(pDX, M_stamina_inc_max, 8);
	DDX_Text(pDX, IDC_PT_DECAY, M_decay);
	DDV_MaxChars(pDX, M_decay, 8);
	DDX_Text(pDX, IDC_PT_INERTIA_MOMENT, M_inertia_moment);
	DDV_MaxChars(pDX, M_inertia_moment, 8);
	DDX_Text(pDX, IDC_PT_DASH_POWER_RATE, M_dash_power_rate);
	DDV_MaxChars(pDX, M_dash_power_rate, 8);
	DDX_Text(pDX, IDC_PT_SIZE, M_size);
	DDV_MaxChars(pDX, M_size, 8);
	DDX_Text(pDX, IDC_PT_KICKABLE_MARGIN, M_kickable_margin);
	DDV_MaxChars(pDX, M_kickable_margin, 8);
	DDX_Text(pDX, IDC_PT_KICK_RAND, M_kick_rand);
	DDV_MaxChars(pDX, M_kick_rand, 8);
	DDX_Text(pDX, IDC_PT_EXTRA_STAMINA, M_extra_stamina);
	DDV_MaxChars(pDX, M_extra_stamina, 8);
	DDX_Text(pDX, IDC_PT_EFFORT_MAX, M_effort_max);
	DDV_MaxChars(pDX, M_effort_max, 8);
	DDX_Text(pDX, IDC_PT_EFFORT_MIN, M_effort_min);
	DDV_MaxChars(pDX, M_effort_min, 8);
	DDX_Text(pDX, IDC_PT_REAL_SPEED_MAX, M_real_speed_max);
	DDV_MaxChars(pDX, M_real_speed_max, 8);
	DDX_Text(pDX, IDC_PT_ACCEL_MAX, M_accel_max);
	DDV_MaxChars(pDX, M_accel_max, 8);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(PlayerTypeDialog, CDialog)
	//{{AFX_MSG_MAP(PlayerTypeDialog)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// PlayerTypeDialog bZ[W nh


void PlayerTypeDialog::update(const PlayerType &player_type)
{
    M_id.Format("%d", player_type.id);
	M_speed_max.Format("%.4f", player_type.player_speed_max);

    double max_accel = 100.0 * player_type.dash_power_rate * player_type.effort_max;
    double real_speed_max = max_accel / (1.0 - player_type.player_decay);
    if ( real_speed_max > player_type.player_speed_max )
    {
        real_speed_max = player_type.player_speed_max;
    }
    M_real_speed_max.Format("%.4f", real_speed_max);
    M_accel_max.Format("%.4f", max_accel);

	M_stamina_inc_max.Format("%.3f", player_type.stamina_inc_max);
	M_decay.Format("%.4f", player_type.player_decay);
	M_inertia_moment.Format("%.4f", player_type.inertia_moment);
	M_dash_power_rate.Format("%.5f", player_type.dash_power_rate);
	M_size.Format("%.4f", player_type.player_size);
	M_kickable_margin.Format("%.4f", player_type.kickable_margin);
	M_kick_rand.Format("%.4f", player_type.kick_rand);
	M_extra_stamina.Format("%.3f", player_type.extra_stamina);
	M_effort_max.Format("%.3f", player_type.effort_max);
	M_effort_min.Format("%.3f", player_type.effort_min);

    UpdateData(FALSE);
}

void PlayerTypeDialog::reset()
{
    M_id = _T("");
	M_speed_max = _T("");
    M_real_speed_max = _T("");
    M_accel_max = _T("");
	M_stamina_inc_max = _T("");
	M_decay = _T("");
	M_inertia_moment = _T("");
	M_dash_power_rate = _T("");
	M_size = _T("");
	M_kickable_margin = _T("");
	M_kick_rand = _T("");
	M_extra_stamina = _T("");
	M_effort_max = _T("");
	M_effort_min = _T("");

    UpdateData(FALSE);
}




BOOL PlayerTypeDialog::SetWindowStyleLayered()
{
	BOOL ret = FALSE;
	HMODULE hModule = LoadLibrary("user32.dll");
	if ( hModule ) {
		SLWA slwa = (SLWA)GetProcAddress(hModule, "SetLayeredWindowAttributes");
		if ( slwa ) {
			SetWindowLong(GetSafeHwnd(), GWL_EXSTYLE,
				GetWindowLong(GetSafeHwnd(), GWL_EXSTYLE) | WS_EX_LAYERED
				);
			ret = TRUE;
		}
		FreeLibrary(hModule);
	}
	return ret;
}


BOOL PlayerTypeDialog::WindowStyleLayered()
{
	return ((GetWindowLong(GetSafeHwnd(), GWL_EXSTYLE) & WS_EX_LAYERED) != 0) ? TRUE : FALSE;
}


BOOL PlayerTypeDialog::SetLayeredWindowAttributes(COLORREF crKey, BYTE bAlpha, DWORD dwFlags)
{
	BOOL ret = FALSE;
	HMODULE hModule = LoadLibrary("user32.dll");
	if ( hModule ) {
		SLWA slwa = (SLWA)GetProcAddress(hModule, "SetLayeredWindowAttributes");
		if ( slwa ) {
			ret = slwa(GetSafeHwnd(), crKey, bAlpha, dwFlags);
		}
		FreeLibrary(hModule);
	}
	return ret;
}



BOOL PlayerTypeDialog::OnInitDialog()
{
    SetWindowStyleLayered();

	CDialog::OnInitDialog();


    SetLayeredWindowAttributes(0, 160, LWA_ALPHA);
	return TRUE;
}
