// PlayerStatusDialog.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "soccermonitor.h"
#include "PlayerStatusDialog.h"
#include "MainFrm.h"
#include "SoccermonitorDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



#define WS_EX_LAYERED	0x80000
#define LWA_COLORKEY	1
#define LWA_ALPHA		2
typedef BOOL (WINAPI *SLWA)(HWND, COLORREF, BYTE, DWORD);


/////////////////////////////////////////////////////////////////////////////
// PlayerStatusDialog _CAO


PlayerStatusDialog::PlayerStatusDialog(CWnd* pParent /*=NULL*/)
	: CDialog(PlayerStatusDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(PlayerStatusDialog)
	M_player_id = _T("");
	M_pos = _T("");
	M_vel = _T("");
	M_vel_r = _T("");
	M_vel_th = _T("");
	M_body = _T("");
	M_neck = _T("");
	M_neck_rel = _T("");
	M_view_width = _T("");
	M_view_quality = _T("");
	M_stamina = _T("");
	M_effort = _T("");
	M_recovery = _T("");
	M_dash_n = _T("");
	M_kick_n = _T("");
	M_turn_n = _T("");
	M_say_n = _T("");
	M_turn_neck_n = _T("");
	M_catch_n = _T("");
	M_move_n = _T("");
	M_change_view_n = _T("");
	M_ball_rel_pos = _T("");
	M_last_move = _T("");
	M_last_move_r = _T("");
	M_last_move_th = _T("");
	//}}AFX_DATA_INIT
}


void PlayerStatusDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(PlayerStatusDialog)
	DDX_Control(pDX, IDC_PLAYER_TYPE_BUTTON, M_player_type_button);
	DDX_Text(pDX, IDC_PLAYER_ID, M_player_id);
	DDV_MaxChars(pDX, M_player_id, 10);
	DDX_Text(pDX, IDC_PLAYER_POS, M_pos);
	DDV_MaxChars(pDX, M_pos, 18);
	DDX_Text(pDX, IDC_PLAYER_VEL, M_vel);
	DDV_MaxChars(pDX, M_vel, 18);
	DDX_Text(pDX, IDC_PLAYER_VEL_R, M_vel_r);
	DDV_MaxChars(pDX, M_vel_r, 8);
	DDX_Text(pDX, IDC_PLAYER_VEL_TH, M_vel_th);
	DDV_MaxChars(pDX, M_vel_th, 8);
	DDX_Text(pDX, IDC_PLAYER_BODY, M_body);
	DDV_MaxChars(pDX, M_body, 8);
	DDX_Text(pDX, IDC_PLAYER_NECK, M_neck);
	DDV_MaxChars(pDX, M_neck, 8);
	DDX_Text(pDX, IDC_PLAYER_NECK_REL, M_neck_rel);
	DDV_MaxChars(pDX, M_neck_rel, 8);
	DDX_Text(pDX, IDC_PLAYER_VWIDTH, M_view_width);
	DDV_MaxChars(pDX, M_view_width, 8);
	DDX_Text(pDX, IDC_PLAYER_VQUAL, M_view_quality);
	DDV_MaxChars(pDX, M_view_quality, 8);
	DDX_Text(pDX, IDC_PLAYER_STAMINA, M_stamina);
	DDV_MaxChars(pDX, M_stamina, 8);
	DDX_Text(pDX, IDC_PLAYER_EFFORT, M_effort);
	DDV_MaxChars(pDX, M_effort, 8);
	DDX_Text(pDX, IDC_PLAYER_RECOVERY, M_recovery);
	DDV_MaxChars(pDX, M_recovery, 8);
	DDX_Text(pDX, IDC_PLAYER_DASH_N, M_dash_n);
	DDV_MaxChars(pDX, M_dash_n, 8);
	DDX_Text(pDX, IDC_PLAYER_KICK_N, M_kick_n);
	DDV_MaxChars(pDX, M_kick_n, 8);
	DDX_Text(pDX, IDC_PLAYER_TURN_N, M_turn_n);
	DDV_MaxChars(pDX, M_turn_n, 8);
	DDX_Text(pDX, IDC_PLAYER_SAY_N, M_say_n);
	DDV_MaxChars(pDX, M_say_n, 8);
	DDX_Text(pDX, IDC_PLAYER_TURN_NECK_N, M_turn_neck_n);
	DDV_MaxChars(pDX, M_turn_neck_n, 8);
	DDX_Text(pDX, IDC_PLAYER_CATCH_N, M_catch_n);
	DDV_MaxChars(pDX, M_catch_n, 8);
	DDX_Text(pDX, IDC_PLAYER_MOVE_N, M_move_n);
	DDV_MaxChars(pDX, M_move_n, 8);
	DDX_Text(pDX, IDC_PLAYER_CHANGE_VIEW_N, M_change_view_n);
	DDV_MaxChars(pDX, M_change_view_n, 8);
	DDX_Text(pDX, IDC_PLAYER_BALL_REL_POS, M_ball_rel_pos);
	DDV_MaxChars(pDX, M_ball_rel_pos, 16);
	DDX_Text(pDX, IDC_PLAYER_LAST_MOVE, M_last_move);
	DDV_MaxChars(pDX, M_last_move, 18);
	DDX_Text(pDX, IDC_PLAYER_LAST_MOVE_R, M_last_move_r);
	DDV_MaxChars(pDX, M_last_move_r, 8);
	DDX_Text(pDX, IDC_PLAYER_LAST_MOVE_TH, M_last_move_th);
	DDV_MaxChars(pDX, M_last_move_th, 8);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(PlayerStatusDialog, CDialog)
	//{{AFX_MSG_MAP(PlayerStatusDialog)
	ON_BN_CLICKED(IDC_PLAYER_TYPE_BUTTON, OnPlayerTypeButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// PlayerStatusDialog bZ[W nh

void PlayerStatusDialog::setData(const int idx,
                                 const player_t &player,
                                 const PlayerType &type,
                                 const ball_t &ball,
                                 const bool reverse_x)
{
    // idx must be within [0, 21]

    CString text;
    double x, y;
    double turnright = reverse_x ? -1.0 : 1.0;

    M_player_id.Format("%s %d",
                       (idx < 11) ? "left" : "right",
                       (idx < 11) ? idx + 1 : idx - 11 + 1);
    text.Format("%d", (int)player.type);
    M_player_type_button.SetWindowText(text);
    GetDlgItemText(IDC_PLAYER_TYPE_BUTTON, text);
    x = (double)player.x / SHOWINFO_SCALE2;
    y = (double)player.y / SHOWINFO_SCALE2;
    M_pos.Format("%6.2f,  %6.2f", x * turnright, y * turnright);
    M_ball_rel_pos.Format("%6.2f,  %6.2f",
                          ((double)ball.x / SHOWINFO_SCALE2 - x) * turnright,
                          ((double)ball.y / SHOWINFO_SCALE2 - y) * turnright);
    x = (double)player.deltax / SHOWINFO_SCALE2 * turnright;
    y = (double)player.deltay / SHOWINFO_SCALE2 * turnright;
    M_vel.Format("%6.2f,  %6.2f", x, y);
    M_vel_r.Format("%.4f", sqrt(x*x + y*y));
    M_vel_th.Format("%.1f", atan2(y, x) * 180.0 / PI);
    x /= type.player_decay;
    y /= type.player_decay;
    M_last_move.Format("%6.2f,  %6.2f", x, y);
    M_last_move_r.Format("%.4f", sqrt(x*x + y*y));
    M_last_move_th.Format("%.1f", atan2(y, x) * 180.0 / PI);

    // x̂̌Cy̌
    x = (double)player.body_angle / SHOWINFO_SCALE2;
    y = x + (double)player.head_angle / SHOWINFO_SCALE2;
    if ( y > PI ) y -= 2.0 * PI;
    else if ( y < -PI ) y += 2.0 * PI;
    if ( reverse_x )
    {
       x += PI; if ( x > PI ) x -= 2.0 * PI;
       y += PI; if ( y > PI ) y -= 2.0 * PI;
    }
    M_body.Format("%.1f", x * 180.0 / PI);
    M_neck.Format("%.1f", y * 180.0 / PI);
    M_neck_rel.Format("%.1f", (double)player.head_angle / SHOWINFO_SCALE2 * 180.0 / PI);
    M_view_width.Format("%.1f", (double)player.view_width / SHOWINFO_SCALE2 * 180.0 / PI);
    M_view_quality.Format("%s", player.view_quality ? "high" : "low");
    M_stamina.Format("%.2f", (double)player.stamina / SHOWINFO_SCALE2);
    M_effort.Format("%.3f", (double)player.effort / SHOWINFO_SCALE2);
    M_recovery.Format("%.3f", (double)player.recovery / SHOWINFO_SCALE2);
    M_kick_n.Format("%d", (int)player.kick_count);
    M_dash_n.Format("%d", (int)player.dash_count);
    M_turn_n.Format("%d", (int)player.turn_count);
    M_say_n.Format("%d", (int)player.say_count);
    M_turn_neck_n.Format("%d", (int)player.tneck_count);
    M_catch_n.Format("%d", (int)player.catch_count);
    M_move_n.Format("%d", (int)player.move_count);
    M_change_view_n.Format("%d", (int)player.chg_view_count);

    UpdateData(FALSE);
}

void PlayerStatusDialog::reset()
{
	M_player_id = _T("");
    M_player_type_button.SetWindowText(_T(""));
	M_pos = _T("");
	M_vel = _T("");
	M_vel_r = _T("");
	M_vel_th = _T("");
    M_last_move = _T("");
    M_last_move_r = _T("");
    M_last_move_th = _T("");
	M_body = _T("");
	M_neck = _T("");
	M_neck_rel = _T("");
	M_view_width = _T("");
	M_view_quality = _T("");
	M_stamina = _T("");
	M_effort = _T("");
	M_recovery = _T("");
	M_dash_n = _T("");
	M_kick_n = _T("");
	M_turn_n = _T("");
	M_say_n = _T("");
	M_turn_neck_n = _T("");
	M_catch_n = _T("");
	M_move_n = _T("");
	M_change_view_n = _T("");

    M_ball_rel_pos = _T("");

    UpdateData(FALSE);
}

BOOL PlayerStatusDialog::SetWindowStyleLayered()
{
	BOOL ret = FALSE;
	HMODULE hModule = LoadLibrary("user32.dll");
	if ( hModule ) {
		SLWA slwa = (SLWA)GetProcAddress(hModule, "SetLayeredWindowAttributes");
		if ( slwa ) {
			SetWindowLong(GetSafeHwnd(), GWL_EXSTYLE,
				GetWindowLong(GetSafeHwnd(), GWL_EXSTYLE) | WS_EX_LAYERED
				);
			ret = TRUE;
		}
		FreeLibrary(hModule);
	}
	return ret;
}


BOOL PlayerStatusDialog::WindowStyleLayered()
{
	return ((GetWindowLong(GetSafeHwnd(), GWL_EXSTYLE) & WS_EX_LAYERED) != 0) ? TRUE : FALSE;
}


BOOL PlayerStatusDialog::SetLayeredWindowAttributes(COLORREF crKey, BYTE bAlpha, DWORD dwFlags)
{
	BOOL ret = FALSE;
	HMODULE hModule = LoadLibrary("user32.dll");
	if ( hModule ) {
		SLWA slwa = (SLWA)GetProcAddress(hModule, "SetLayeredWindowAttributes");
		if ( slwa ) {
			ret = slwa(GetSafeHwnd(), crKey, bAlpha, dwFlags);
		}
		FreeLibrary(hModule);
	}
	return ret;
}



BOOL PlayerStatusDialog::OnInitDialog()
{
    SetWindowStyleLayered();

	CDialog::OnInitDialog();


    SetLayeredWindowAttributes(0, 160, LWA_ALPHA);
	return TRUE;
}

void PlayerStatusDialog::OnPlayerTypeButton() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
    CString str;
    M_player_type_button.GetWindowText(str);
    if ( str.IsEmpty() )
    {
        return;
    }

    CMainFrame *pFrame = (CMainFrame*)AfxGetApp()->m_pMainWnd;
    if ( pFrame )
    {
        CSoccermonitorDoc *pDoc = (CSoccermonitorDoc*)pFrame->GetActiveDocument();
        if ( pDoc )
        {
            int id = atoi(str);
            pDoc->selectPlayerType(id);
        }
    }
}
