#ifndef SOM_H
#define SOM_H

#include <math.h>
#include <vector>

class SomCell {
private:
    double M_x;
    double M_y;
    
public:
    SomCell()
        : M_x(0.0), M_y(0.0)
    { }

    SomCell(const double &x, const double &y)
        : M_x(x), M_y(y)
    { }
    
    void assign(const double &x, const double &y)
    {
        M_x = x;
        M_y = y;
    }
    
    const
    double & x() const
    {
        return M_x;
    }
    const
    double & y() const
    {
        return M_y;
    }
    
    const
    SomCell& add(const double &x, const double &y)
    {
        M_x += x;
        M_y += y;
        return *this;
    }
    
    double dist2(const double &x, const double &y) const
    {
        return pow(M_x - x, 2.0) + pow(M_y - y, 2.0);
    }
    double dist(const double &x, const double &y) const
    {
        return sqrt(dist2(x, y));
    }
    double dist2(const SomCell &v) const
    {
        return dist2(v.x(), v.y());
    }
    double dist(const SomCell &v) const
    {
        return dist(v.x(), v.y());
    }
};



class Som {
private:
    int M_input_size;
    int M_cell_size;
    int M_neighborhood_size;
    int M_max_train;
    int M_train_count;

    std::vector<SomCell> M_cells;
    
    
    
    // wKilj
    static const double S_ALPHA;
    // wǨi̊wK񐔂ŊwKقڔj
    static const double S_A_UDW;
    // 𑁂߂
    static const double S_B_UDW;

    double M_c_udw;
public:
    Som(const int input_size = 11,
        const double &size_rate = 5.0);

    void reset(const double &center_x,
               const double &center_y,
               const double &radius);

    void update(const double &x,
                const double &y);
    void incTrainCount()
    {
        M_train_count++;
    }

    const
    std::vector<SomCell>& cells() const
    {
        return M_cells;
    }
};

#endif
