// SoccermonitorDoc.h : interface of the CSoccermonitorDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_SOCCERMONITORDOC_H__5C57B36B_5FF6_11D1_B242_0000C09B5CBE__INCLUDED_)
#define AFX_SOCCERMONITORDOC_H__5C57B36B_5FF6_11D1_B242_0000C09B5CBE__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
#include <math.h>
#include "Agentsock.h"
#include "BallStatusDialog.h"
#include "PlayerStatusDialog.h"
#include "PlayerTypeDialog.h"
#include "PlayerTypeListDialog.h"
#include "CoachMessageDialog.h"

#include "param.h"
#include "Som.h"
#include "geometry.h"

// results of each single agent is added to result file
#define xADD_RESULTS_OF_SINGLE_AGENT


// types from the server
class CAgentSocket;
class TCoachAgent;
class TLogPlayer;
class CSoccermonitorView;
class TMessageView;
class TCoachView;

class CSoccermonitorDoc : public CDocument
{
protected: // create from serialization only
	CSoccermonitorDoc();
	DECLARE_DYNCREATE(CSoccermonitorDoc)


    enum FieldGrassType {
        GRASS_MONO,
        GRASS_LINES,
        GRASS_CHECKER,
        GRASS_KEEPAWAY
    };

    enum FocusType {
        FOCUS_BALL,
        FOCUS_PLAYER,
        FOCUS_POINT,
        FOCUS_AUTO
    };

public:
    static const COLORREF COLOR_FIELD;
    static const COLORREF COLOR_FIELD_DARK;
    static const COLORREF COLOR_LINES;
    static const COLORREF COLOR_FLAG;
    static const COLORREF COLOR_GOAL;
    static const COLORREF COLOR_GOALPOST;

    static const COLORREF COLOR_BALL;

    static const COLORREF COLOR_TEAM_L;
    static const COLORREF COLOR_TEAM_L_GOALIE;
    static const COLORREF COLOR_TEAM_R;
    static const COLORREF COLOR_TEAM_R_GOALIE;

    static const COLORREF COLOR_BODY_DIR;
    static const COLORREF COLOR_VIEW_CONE;
    static const COLORREF COLOR_VIEW_AREA;

    static const COLORREF COLOR_KICK_FAULT;
    static const COLORREF COLOR_GOALIE_CATCH;
    static const COLORREF COLOR_GOALIE_CATCH_FAULT;
    static const COLORREF COLOR_TACKLE;
    static const COLORREF COLOR_TACKLE_FAULT;
    static const COLORREF COLOR_BALL_COLLIDE;
    static const COLORREF COLOR_PLAYER_COLLIDE;

    static const COLORREF COLOR_PLAYER_FONT2;

private:
    Vector2D getFoulCoordinate();
    
    static const double S_MAX_FIELD_SCALE;
    static const double S_MIN_FIELD_SCALE;

    static const int S_MAX_FONT_SIZE;
    static const int S_MIN_FONT_SIZE;
    static const int S_MAX_PLAYER_FONT_SIZE;
    static const int S_MIN_PLAYER_FONT_SIZE;


    BOOL		m_bStarted; // true after kickoff
    BOOL		m_bViewReferee;	// if true, only messages of referee are displayed

    bool M_monitor_move_player;
    bool M_monitor_discard_player;

    bool M_view_ball;
    bool M_view_players;
    bool M_view_flags;
    FieldGrassType M_field_grass_type;
    bool M_view_body_shadow;
    bool M_view_eyes;

    int M_selected_player;
    bool M_player_auto_select;

    bool M_view_numbers; // if true, numbers of players are displayed
    bool M_view_player_type;
    //	BOOL		m_bViewColor;		// if true, the field gets an extra color
    BOOL		m_bHadConnectionError;	// TRUE, if a connection error occured
    bool M_enlarged;
    bool M_view_control_area;
    bool M_view_visible_cone;
    bool M_view_offside_line;
    bool M_view_voronoi_diagram;

    int M_ball_trace_start_cycle;
    int M_player_trace_start_cycle;

    bool M_view_player_detail;
    BallStatusDialog*   M_ball_dlg_ptr;
    PlayerStatusDialog* M_status_dlg_ptr;
    PlayerTypeDialog*   M_player_type_dlg_ptr;
    PlayerTypeListDialog*  M_player_type_list_dlg_ptr;
    CoachMessageDialog* M_say_message_dlg_ptr;
    short M_last_draw_cycle;
    char M_last_draw_pmode;
    void getBallDialog();
    void getStatusDialog();
    void getPlayerTypeDialog();
    void getPlayerTypeListDialog();
    void getCoachMessageDialog();

    CPoint M_drag_start_pos;
    CPoint M_drag_end_pos;
    bool M_l_clicked;
    bool M_view_ball_detail;
    bool M_view_measure;
    bool M_reverse_x;
    FocusType M_focus_type;
    bool M_drag_zoom;
    bool M_zoomed;

    CSoccermonitorView*	m_pView;
    TMessageView* m_pMsgView;
    TLogPlayer*   m_pLogPlayer; // log player object
    CAgentSocket* m_pSocket; // communication class
    showinfo_t2*  m_pInfo;   // information sent by the server

    BOOL				m_bTryingToConnect;
    bool M_connected;
    
    CString M_server_host;		
    UINT M_monitor_port;
    UINT M_coach_port;
    
    TCoachView*			M_coach_view_ptr;
    TCoachAgent* M_coach_ptr;
    bool M_coach_connected;
    
    int				m_iOldTime;
    char M_last_playmode;
    int				m_iSizeX;
    int				m_iSizeY;
    int M_field_center_x;
    int M_field_center_y;
    double M_field_scale;
    double M_focus_point_x;
    double M_focus_point_y;
    int M_segment_markin_cycle;
    int M_segment_markout_cycle;

    int M_last_pointto_unum;
    int M_pointto_x;
    int M_pointto_y;
    int M_pointto_start_time;


    bool M_color_save;

    COLORREF M_color_score;

    COLORREF M_color_field;
    COLORREF M_color_field_dark;

    COLORREF M_color_lines;
    COLORREF M_color_flag;
    COLORREF M_color_goal;
    COLORREF M_color_goalpost;
    COLORREF M_color_offside_line;
    COLORREF M_color_voronoi_diagram;

    COLORREF M_color_ball;

    COLORREF M_color_player_edge;
    COLORREF M_color_left_team;
    COLORREF M_color_left_goalie;
    COLORREF M_color_right_team;
    COLORREF M_color_right_goalie;

    COLORREF M_color_player_font1;
    COLORREF M_color_player_font2;

    COLORREF M_color_body_dir;
    COLORREF M_color_view_cone;
    COLORREF M_color_view_area;
    COLORREF M_color_control_area;
    COLORREF M_color_effort_tired;
    COLORREF M_color_recovery_tired;

    COLORREF M_color_kick_edge;
    COLORREF M_color_kick_fault;
    COLORREF M_color_goalie_catch;
    COLORREF M_color_goalie_catch_fault;
    COLORREF M_color_tackle;
    COLORREF M_color_tackle_fault;
    COLORREF M_color_ball_collide;
    COLORREF M_color_player_collide;

    COLORREF M_color_click_point;
    COLORREF M_color_drag_line;

    // field
    CBrush* M_brush_field;
    CPen* M_pen_line;
    CPen* M_pen_goal_post;
    CBrush* M_brush_goal_post;
    CPen* M_pen_flag;
    CPen* M_pen_offside_line;
    CPen* M_pen_voronoi_diagram;

    // ball
   	CPen* M_pen_ball;
    CBrush*	M_brush_ball;

    // player
    CPen* M_pen_player_edge;
    CPen* M_pen_left_player_edge;
    CPen* M_pen_right_player_edge;
    CPen* M_pen_player_body_dir;
    CBrush*	M_brush_body_dir;
    CBrush*	M_brush_player_eye;
    CBrush*	M_brush_left_player;
    CBrush*	M_brush_left_goalie;
    CBrush*	M_brush_right_player;
    CBrush*	M_brush_right_goalie;
    // player state
    CPen* M_pen_player_kick;
    CPen* M_pen_player_kick_fault;
    CBrush*	M_brush_kick_fault;
    CPen* M_pen_player_catch;
    CBrush*	M_brush_catch;
    CBrush*	M_brush_catch_fault;
    CPen* M_pen_player_tackle;
    CBrush* M_brush_tackle;
    CPen* M_pen_player_tackle_fault;
    CBrush* M_brush_tackle_fault;
    CBrush*	M_brush_ball_collide;
    CBrush*	M_brush_player_collide;
    // stamina
    CPen* M_pen_player_rec_tired;
    CPen* M_pen_player_eff_tired;
    // control
    CPen* M_pen_player_control_area;
    CPen* M_pen_player_vcone;
    CPen* M_pen_player_varea;

    // mouse
    CPen* M_pen_click_point;
    CPen* M_pen_drag_line;

    // font
    CFont* M_font_team_name;
    CFont* M_font_score;
    CFont* M_font_player;
    CFont* M_font_time;

#ifdef DRAW_SOM
    Som M_som;
#endif

// Operations
public:
   	void newInfo(showinfo_t* info);
	void		NewInfo(showinfo_t2* info);
	void		NewMsg(msginfo_t* info);
    void newParam(player_params_t* pparam);
    void newParam(player_type_t* ptinfo);
    void newParam(server_params_t* sparam);

    void RedrawDoc();
private:
    void createGdiObject();
    void deleteGdiObject();
	void DrawSoccer(CDC* pDC);
	void Drawcurpos(CDC* hdc);
    void DrawField(CDC *pDC);
    void DrawFlags(CDC *pDC);
    void DrawGameInfo(CDC *pDC);
    void DrawPlayers(CDC *pDC);
    void setPlayerColor(CDC *pDC, const player_t& player, const int player_idx);
    void setKickableMarginColor(CDC *pDC, const player_t& player, const int player_idx);
    //void drawPlayerDetail(CDC *pDC, const player_t& player, const bool selected);
    void DrawBall(CDC *pDC);

    void drawOffsideLine(CDC *pDC);
    void drawVoronoiDiagram(CDC *pDC);
    void getEdgePoint(const Line2D &line, Vector2D *left_edge, Vector2D *right_edge);
    Line2D getCenterPerpendicular(const Vector2D &first_point,
                                  const Vector2D &second_point);

#define USE_MOUSE_RELEASE_FUNC
    void releaseMouseLeft()
    {
        M_view_measure = false;
        M_focus_type = FOCUS_AUTO;
        M_drag_zoom = false;
        M_monitor_move_player = false;
        M_monitor_discard_player = false;
    }
public:
    BOOL isConnected()
    {
        return M_connected;
    }

    CSoccermonitorView* view()
    {
        return m_pView;
    }
    TLogPlayer *logplayer()
    {
        return m_pLogPlayer;
    }
    TCoachAgent* coach()
    {
        return M_coach_ptr;
    }

    int scale(const double &len)
    {
        //return (int)(len * M_field_scale);
        double d = len * M_field_scale;
        if ( fabs(d) < 0.5 ) return 0;
        return (int)(d + (d > 0.0 ? 0.5 : -0.5));
    }

    int screenX(const double &field_x)
    {
       return M_field_center_x + scale(field_x);
    }
    int screenY(const double &field_y)
    {
        return M_field_center_y + scale(field_y);
    }


    void doDragZoom();
    Vector2D convertPoint(const CPoint &point);

    void		ConnectionTimeout(void);
	void		DeleteSocket(void);
	void		ShowString(long tm, LPCTSTR msg, BYTE board);
	void		TestSocket();

	void		DisplayMessage(LPCTSTR msg);
	int FindPlayer(const Vector2D &pt, double thr=1.5);
    void doMovePlayer(const CPoint& point);
	void doMovePlayer(int side, int unum,
                      int x, int y,
                      const double& angle = 0.0f);
    void doDiscardPlayer(const int idx);

    // set
    void resetPlayerStateDialog();
    void resetPlayerTypeDialog();
    void selectPlayerType();
    void selectPlayerType(const int id);

    void setLButtonDown(const CPoint &p)
    {
        M_l_clicked = true;
        M_drag_start_pos = M_drag_end_pos = p;
    }
    void setLButtonDrag(const CPoint &p)
    {
        M_drag_end_pos = p;
    }
    void setLButtonUp()
    {
        M_l_clicked = false;
    }
    void setFocusPoint(const double &x, const double &y)
    {
        M_focus_point_x = x;
        M_focus_point_y = y;
    }
    void selectPlayer(const int idx);
    void setSelectPlayer(const int idx)
    {
        if ( idx < 0 || 22 < idx )
        {
            M_selected_player = 0;
            return;
        }
        M_selected_player = idx;
    }

    // get
    const CString& serverHost() const
    {
        return M_server_host;
    }
    UINT coachPort() const
    {
        return M_coach_port;
    }

    bool isMonitorMovePlayer() const
    {
        return M_monitor_move_player;
    }
    bool isMonitorDiscardPlayer() const
    {
        return M_monitor_discard_player;
    }

    bool isViewMeasure() const
    {
        return M_view_measure;
    }
    bool isDragZoom() const
    {
        return M_drag_zoom;
    }
    bool isLButtonDown() const
    {
        return M_l_clicked;
    }
    FocusType focusType() const
    {
        return M_focus_type;
    }

    bool isPlayerAutoSelect() const
    {
        return M_player_auto_select;
    }
    int selectedPlayer() const
    {
        return M_selected_player;
    }

    void zoom(bool out);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSoccermonitorDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual void DeleteContents();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	protected:
	virtual BOOL SaveModified();
	//}}AFX_VIRTUAL

// Implementation
public:	
	virtual ~CSoccermonitorDoc();
	
	void		SetStarted(BOOL val) { m_bStarted = val; };
	void		SetInfo(showinfo_t2* info) { m_pInfo = info; };
	void		SetCycle(int pos);
    void setGameCycle(const int cyc);

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


// Generated message map functions
protected:
    afx_msg void OnChangeFieldGrassType(UINT nID);
    afx_msg void OnUpdateChangeFieldGrassType(CCmdUI* pCmdUI);
    afx_msg void OnChangeFocusType(UINT nID);
    afx_msg void OnUpdateChangeFocusType(CCmdUI* pCmdUI);
    afx_msg void OnSelectPlayer(UINT nID);
    afx_msg void OnUpdateSelectPlayer(CCmdUI* pCmdUI);
    afx_msg void OnPlayModeCommand(UINT nID);
    afx_msg void OnUpdatePlayModeCommand(CCmdUI* pCmdUI);
	//{{AFX_MSG(CSoccermonitorDoc)
	afx_msg void OnKickOff();
	afx_msg void OnUpdateKickOff(CCmdUI* pCmdUI);
	afx_msg void OnViewNumbers();
	afx_msg void OnChangeColor();
	afx_msg void OnUpdateViewNumbers(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLogRewind(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLogStart(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLogStop(CCmdUI* pCmdUI);
	afx_msg void OnConnect();
	afx_msg void OnUpdateConnect(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSaveAs(CCmdUI* pCmdUI);
	afx_msg void OnDisconnect();
	afx_msg void OnUpdateDisconnect(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLogAccelerate(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLogDecelerate(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLogGoto(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileOpen(CCmdUI* pCmdUI);
	afx_msg void OnViewRefereeMsg();
	afx_msg void OnUpdateViewRefereeMsg(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLogStep(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLogStepBack(CCmdUI* pCmdUI);
	afx_msg void OnFoulLeft();
	afx_msg void OnFoulRight();
	afx_msg void OnUpdateFoulLeft(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFoulRight(CCmdUI* pCmdUI);
	afx_msg void OnFoulDropBall();
	afx_msg void OnUpdateFoulDropBall(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLogBackplay(CCmdUI* pCmdUI);
	afx_msg void OnConnectTo();
	afx_msg void OnUpdateViewEnlargePlayers(CCmdUI* pCmdUI);
	afx_msg void OnViewKickableMargin();
	afx_msg void OnUpdateViewKickableMargin(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCoachConnect(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCoachDisconnect(CCmdUI* pCmdUI);
	afx_msg void OnCoachConnect();
	afx_msg void OnCoachDisconnect();
	afx_msg void OnUpdateCoachLook(CCmdUI* pCmdUI);
	afx_msg void OnUpdateTrainerStopGame(CCmdUI* pCmdUI);
	afx_msg void OnUpdateTrainerPauseGame(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCoachEar(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCoachEye(CCmdUI* pCmdUI);
	afx_msg void OnUpdateMonitorMovePlayer(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCoachStart(CCmdUI* pCmdUI);
	afx_msg void OnRefreshMonitor();
	afx_msg void OnViewVisibleCone();
	afx_msg void OnUpdateViewPlayerDetail(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewMeasure(CCmdUI* pCmdUI);
	afx_msg void OnViewMeasure();
	afx_msg void OnUpdateReverseX(CCmdUI* pCmdUI);
	afx_msg void OnReverseX();
	afx_msg void OnSegmentMarkIn();
	afx_msg void OnSegmentMarkOut();
	afx_msg void OnViewPlayerType();
	afx_msg void OnUpdateViewPlayerType(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewVisibleCone(CCmdUI* pCmdUI);
	afx_msg void OnUnzoom();
	afx_msg void OnDragZoom();
	afx_msg void OnUpdateDragZoom(CCmdUI* pCmdUI);
	afx_msg void OnZoomIn();
	afx_msg void OnZoomOut();
	afx_msg void OnViewBodyShadow();
	afx_msg void OnUpdateViewBodyShadow(CCmdUI* pCmdUI);
	afx_msg void OnViewEyes();
	afx_msg void OnUpdateViewEyes(CCmdUI* pCmdUI);
	afx_msg void OnViewEnlargePlayers();
	afx_msg void OnViewFlags();
	afx_msg void OnUpdateViewFlags(CCmdUI* pCmdUI);
	afx_msg void OnViewOffsideLine();
	afx_msg void OnUpdateViewOffsideLine(CCmdUI* pCmdUI);
	afx_msg void OnViewPlayerDetail();
	afx_msg void OnUpdateViewStatusDialog(CCmdUI* pCmdUI);
	afx_msg void OnViewPlayerTypeList();
	afx_msg void OnUpdateViewPlayerTypeList(CCmdUI* pCmdUI);
	afx_msg void OnViewStatusDialog();
	afx_msg void OnViewBallDetail();
	afx_msg void OnUpdateBallVel(CCmdUI* pCmdUI);
	afx_msg void OnViewPlayerTypeDialog();
	afx_msg void OnUpdateViewPlayerTypeDialog(CCmdUI* pCmdUI);
	afx_msg void OnHidePlayer();
	afx_msg void OnUpdateHidePlayer(CCmdUI* pCmdUI);
	afx_msg void OnHideBall();
	afx_msg void OnUpdateHideBall(CCmdUI* pCmdUI);
	afx_msg void OnViewBallLocus();
	afx_msg void OnUpdateViewBallLocus(CCmdUI* pCmdUI);
	afx_msg void OnViewPlayerLocus();
	afx_msg void OnUpdateViewPlayerLocus(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLogGotoEnd(CCmdUI* pCmdUI);
	afx_msg void OnSaveLogToText();
	afx_msg void OnUpdateSaveLogToText(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSegmentMarkIn(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSegmentMarkOut(CCmdUI* pCmdUI);
	afx_msg void OnOpenRclFile();
	afx_msg void OnUpdateOpenRclFile(CCmdUI* pCmdUI);
	afx_msg void OnViewSayMessage();
	afx_msg void OnUpdateViewSayMessage(CCmdUI* pCmdUI);
	afx_msg void OnPlayerAutoSelect();
	afx_msg void OnUpdatePlayerAutoSelect(CCmdUI* pCmdUI);
	afx_msg void OnLogAccelerate();
	afx_msg void OnLogBackplay();
	afx_msg void OnLogDecelerate();
	afx_msg void OnLogGoto();
	afx_msg void OnLogGotoEnd();
	afx_msg void OnLogRewind();
	afx_msg void OnLogStart();
	afx_msg void OnLogStep();
	afx_msg void OnLogStepBack();
	afx_msg void OnLogStop();
	afx_msg void OnMonitorMovePlayer();
	afx_msg void OnMonitorDiscardPlayer();
	afx_msg void OnUpdateMonitorDiscardPlayer(CCmdUI* pCmdUI);
	afx_msg void OnCoachEye();
	afx_msg void OnCoachEar();
	afx_msg void OnCoachLook();
	afx_msg void OnTrainerMoveBall();
	afx_msg void OnUpdateTrainerMoveBall(CCmdUI* pCmdUI);
	afx_msg void OnTrainerPauseGame();
	afx_msg void OnTrainerStopGame();
	afx_msg void OnUpdateChangeColor(CCmdUI* pCmdUI);
	afx_msg void OnLogGotoNextScore();
	afx_msg void OnUpdateLogGotoNextScore(CCmdUI* pCmdUI);
	afx_msg void OnLogGotoPassScene();
	afx_msg void OnUpdateLogGotoPassScene(CCmdUI* pCmdUI);
	afx_msg void OnLogGotoInterceptScene();
	afx_msg void OnUpdateLogGotoInterceptScene(CCmdUI* pCmdUI);
	afx_msg void OnViewVoronoiDiagram();
	afx_msg void OnUpdateViewVoronoiDiagram(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SOCCERMONITORDOC_H__5C57B36B_5FF6_11D1_B242_0000C09B5CBE__INCLUDED_)
