// SoccermonitorDoc.cpp : implementation of the CSoccermonitorDoc class
//

#include "stdafx.h"

#include "Soccermonitor.h"
#include "SoccermonitorView.h"
#include "TMessageView.h"
#include "TCoachView.h"
#include "TCoachAgent.h"
#include "setupdlg.h"
#include "DCycleSlider.h"
#include "SaveLog.h"
#include "TLogPlayer.h"
#include "PlayerTypeListDialog.h"
#include "ColorSettingDialog.h"

#include "MainFrm.h"
#include "SoccermonitorDoc.h"

#include <math.h>
#include <vector>
#include <algorithm>

using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSoccermonitorDoc

const COLORREF CSoccermonitorDoc::COLOR_FIELD = COLOR_LIGHTGREEN;
const COLORREF CSoccermonitorDoc::COLOR_FIELD_DARK = COLOR_DARKGREEN;
const COLORREF CSoccermonitorDoc::COLOR_LINES = RGB(255, 255, 255);
const COLORREF CSoccermonitorDoc::COLOR_FLAG = RGB(255, 255, 255);
const COLORREF CSoccermonitorDoc::COLOR_GOAL = RGB(0, 0, 0);
const COLORREF CSoccermonitorDoc::COLOR_GOALPOST = RGB(55, 55, 55);

const COLORREF CSoccermonitorDoc::COLOR_BALL = RGB(230, 255, 255);

const COLORREF CSoccermonitorDoc::COLOR_TEAM_L = RGB(255, 215, 0); //RGB(130, 175, 250);
const COLORREF CSoccermonitorDoc::COLOR_TEAM_L_GOALIE = RGB(40, 230, 30);
const COLORREF CSoccermonitorDoc::COLOR_TEAM_R = RGB(240, 20, 20);
const COLORREF CSoccermonitorDoc::COLOR_TEAM_R_GOALIE = RGB(195, 55, 240);

const COLORREF CSoccermonitorDoc::COLOR_BODY_DIR = RGB(0, 0, 0);
const COLORREF CSoccermonitorDoc::COLOR_VIEW_CONE = COLOR_LIGHTBLUE;
const COLORREF CSoccermonitorDoc::COLOR_VIEW_AREA = COLOR_WHITE;

const COLORREF CSoccermonitorDoc::COLOR_KICK_FAULT = RGB(255, 0, 255); //RGB(255, 255, 0);
const COLORREF CSoccermonitorDoc::COLOR_GOALIE_CATCH = RGB(10, 80, 10);
const COLORREF CSoccermonitorDoc::COLOR_GOALIE_CATCH_FAULT = RGB(10, 80, 80);
const COLORREF CSoccermonitorDoc::COLOR_TACKLE = RGB(255, 136, 126);
const COLORREF CSoccermonitorDoc::COLOR_TACKLE_FAULT = RGB(80, 180, 160);
const COLORREF CSoccermonitorDoc::COLOR_BALL_COLLIDE = RGB(5, 255, 255);
const COLORREF CSoccermonitorDoc::COLOR_PLAYER_COLLIDE = RGB(105, 185, 255); //RGB(255, 210, 255);

const COLORREF CSoccermonitorDoc::COLOR_PLAYER_FONT2 = RGB(120, 255, 30);


IMPLEMENT_DYNCREATE(CSoccermonitorDoc, CDocument)

BEGIN_MESSAGE_MAP(CSoccermonitorDoc, CDocument)
    ON_COMMAND_RANGE(ID_GRASS_MONO, ID_KEEPAWAY, OnChangeFieldGrassType)
    ON_UPDATE_COMMAND_UI_RANGE(ID_GRASS_MONO, ID_KEEPAWAY, OnUpdateChangeFieldGrassType)
    ON_COMMAND_RANGE(ID_FOCUS_BALL, ID_FOCUS_POINT, OnChangeFocusType)
    ON_UPDATE_COMMAND_UI_RANGE(ID_FOCUS_BALL, ID_FOCUS_POINT, OnUpdateChangeFocusType)
    ON_COMMAND_RANGE(ID_UNSELECT, ID_SELECT_PLAYER_RIGHT_11, OnSelectPlayer)
    ON_UPDATE_COMMAND_UI_RANGE(ID_UNSELECT, ID_SELECT_PLAYER_RIGHT_11, OnUpdateSelectPlayer)
    ON_COMMAND_RANGE(IDC_PM_BEFORE_KICK_OFF, IDC_PM_DROP_BALL, OnPlayModeCommand)
    ON_UPDATE_COMMAND_UI_RANGE(IDC_PM_BEFORE_KICK_OFF, IDC_PM_DROP_BALL, OnUpdatePlayModeCommand)
    //{{AFX_MSG_MAP(CSoccermonitorDoc)
    ON_COMMAND(ID_KICK_OFF, OnKickOff)
    ON_UPDATE_COMMAND_UI(ID_KICK_OFF, OnUpdateKickOff)
    ON_COMMAND(ID_VIEW_NUMBERS, OnViewNumbers)
    ON_COMMAND(ID_CHANGE_COLOR, OnChangeColor)
    ON_UPDATE_COMMAND_UI(ID_VIEW_NUMBERS, OnUpdateViewNumbers)
    ON_UPDATE_COMMAND_UI(ID_LOG_REWIND, OnUpdateLogRewind)
    ON_UPDATE_COMMAND_UI(ID_LOG_START, OnUpdateLogStart)
    ON_UPDATE_COMMAND_UI(ID_LOG_STOP, OnUpdateLogStop)
    ON_COMMAND(ID_CONNECT, OnConnect)
    ON_UPDATE_COMMAND_UI(ID_CONNECT, OnUpdateConnect)
    ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
    ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_AS, OnUpdateFileSaveAs)
    ON_COMMAND(ID_DISCONNECT, OnDisconnect)
    ON_UPDATE_COMMAND_UI(ID_DISCONNECT, OnUpdateDisconnect)
    ON_UPDATE_COMMAND_UI(ID_LOG_ACCELERATE, OnUpdateLogAccelerate)
    ON_UPDATE_COMMAND_UI(ID_LOG_DECELERATE, OnUpdateLogDecelerate)
    ON_UPDATE_COMMAND_UI(ID_LOG_GOTO, OnUpdateLogGoto)
    ON_UPDATE_COMMAND_UI(ID_FILE_OPEN, OnUpdateFileOpen)
    ON_COMMAND(ID_VIEW_REFEREE_MSG, OnViewRefereeMsg)
    ON_UPDATE_COMMAND_UI(ID_VIEW_REFEREE_MSG, OnUpdateViewRefereeMsg)
    ON_UPDATE_COMMAND_UI(ID_LOG_STEP, OnUpdateLogStep)
    ON_UPDATE_COMMAND_UI(ID_LOG_STEP_BACK, OnUpdateLogStepBack)
    ON_COMMAND(ID_FOUL_LEFT, OnFoulLeft)
    ON_COMMAND(ID_FOUL_RIGHT, OnFoulRight)
    ON_UPDATE_COMMAND_UI(ID_FOUL_LEFT, OnUpdateFoulLeft)
    ON_UPDATE_COMMAND_UI(ID_FOUL_RIGHT, OnUpdateFoulRight)
    ON_COMMAND(ID_FOUL_DROP_BALL, OnFoulDropBall)
    ON_UPDATE_COMMAND_UI(ID_FOUL_DROP_BALL, OnUpdateFoulDropBall)
    ON_UPDATE_COMMAND_UI(ID_LOG_BACKPLAY, OnUpdateLogBackplay)
    ON_COMMAND(ID_CONNECT_TO, OnConnectTo)
    ON_UPDATE_COMMAND_UI(ID_VIEW_ENLARGE_PLAYERS, OnUpdateViewEnlargePlayers)
    ON_COMMAND(ID_VIEW_KICKABLE_MARGIN, OnViewKickableMargin)
    ON_UPDATE_COMMAND_UI(ID_VIEW_KICKABLE_MARGIN, OnUpdateViewKickableMargin)
    ON_UPDATE_COMMAND_UI(ID_COACH_CONNECT, OnUpdateCoachConnect)
    ON_UPDATE_COMMAND_UI(ID_COACH_DISCONNECT, OnUpdateCoachDisconnect)
    ON_COMMAND(ID_COACH_CONNECT, OnCoachConnect)
    ON_COMMAND(ID_COACH_DISCONNECT, OnCoachDisconnect)
    ON_UPDATE_COMMAND_UI(ID_COACH_LOOK, OnUpdateCoachLook)
    ON_UPDATE_COMMAND_UI(ID_TRAINER_STOP_GAME, OnUpdateTrainerStopGame)
    ON_UPDATE_COMMAND_UI(ID_TRAINER_PAUSE_GAME, OnUpdateTrainerPauseGame)
    ON_UPDATE_COMMAND_UI(ID_COACH_EAR, OnUpdateCoachEar)
    ON_UPDATE_COMMAND_UI(ID_COACH_EYE, OnUpdateCoachEye)
    ON_UPDATE_COMMAND_UI(ID_MONITOR_MOVE_PLAYER, OnUpdateMonitorMovePlayer)
    ON_UPDATE_COMMAND_UI(ID_COACH_START, OnUpdateCoachStart)
    ON_COMMAND(ID_REFRESH_MONITOR, OnRefreshMonitor)
    ON_COMMAND(ID_VIEW_VISIBLE_CONE, OnViewVisibleCone)
    ON_UPDATE_COMMAND_UI(ID_VIEW_PLAYER_DETAIL, OnUpdateViewPlayerDetail)
    ON_UPDATE_COMMAND_UI(ID_VIEW_MEASURE, OnUpdateViewMeasure)
    ON_COMMAND(ID_VIEW_MEASURE, OnViewMeasure)
    ON_UPDATE_COMMAND_UI(ID_REVERSE_X, OnUpdateReverseX)
    ON_COMMAND(ID_REVERSE_X, OnReverseX)
    ON_COMMAND(ID_SEGMENT_MARK_IN, OnSegmentMarkIn)
    ON_COMMAND(ID_SEGMENT_MARK_OUT, OnSegmentMarkOut)
	ON_COMMAND(ID_VIEW_PLAYER_TYPE, OnViewPlayerType)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PLAYER_TYPE, OnUpdateViewPlayerType)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VISIBLE_CONE, OnUpdateViewVisibleCone)
	ON_COMMAND(ID_UNZOOM, OnUnzoom)
	ON_COMMAND(ID_DRAG_ZOOM, OnDragZoom)
	ON_UPDATE_COMMAND_UI(ID_DRAG_ZOOM, OnUpdateDragZoom)
	ON_COMMAND(ID_ZOOM_IN, OnZoomIn)
	ON_COMMAND(ID_ZOOM_OUT, OnZoomOut)
	ON_COMMAND(ID_VIEW_BODY_SHADOW, OnViewBodyShadow)
	ON_UPDATE_COMMAND_UI(ID_VIEW_BODY_SHADOW, OnUpdateViewBodyShadow)
	ON_COMMAND(ID_VIEW_EYES, OnViewEyes)
	ON_UPDATE_COMMAND_UI(ID_VIEW_EYES, OnUpdateViewEyes)
	ON_COMMAND(ID_VIEW_ENLARGE_PLAYERS, OnViewEnlargePlayers)
	ON_COMMAND(ID_VIEW_FLAGS, OnViewFlags)
	ON_UPDATE_COMMAND_UI(ID_VIEW_FLAGS, OnUpdateViewFlags)
	ON_COMMAND(ID_VIEW_OFFSIDE_LINE, OnViewOffsideLine)
	ON_UPDATE_COMMAND_UI(ID_VIEW_OFFSIDE_LINE, OnUpdateViewOffsideLine)
	ON_COMMAND(ID_VIEW_PLAYER_DETAIL, OnViewPlayerDetail)
	ON_UPDATE_COMMAND_UI(ID_VIEW_STATUS_DIALOG, OnUpdateViewStatusDialog)
	ON_COMMAND(ID_VIEW_PLAYER_TYPE_LIST, OnViewPlayerTypeList)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PLAYER_TYPE_LIST, OnUpdateViewPlayerTypeList)
	ON_COMMAND(ID_VIEW_STATUS_DIALOG, OnViewStatusDialog)
	ON_COMMAND(ID_VIEW_BALL_DETAIL, OnViewBallDetail)
	ON_UPDATE_COMMAND_UI(ID_VIEW_BALL_DETAIL, OnUpdateBallVel)
	ON_COMMAND(ID_VIEW_PLAYER_TYPE_DIALOG, OnViewPlayerTypeDialog)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PLAYER_TYPE_DIALOG, OnUpdateViewPlayerTypeDialog)
	ON_COMMAND(ID_HIDE_PLAYER, OnHidePlayer)
	ON_UPDATE_COMMAND_UI(ID_HIDE_PLAYER, OnUpdateHidePlayer)
	ON_COMMAND(ID_HIDE_BALL, OnHideBall)
	ON_UPDATE_COMMAND_UI(ID_HIDE_BALL, OnUpdateHideBall)
	ON_COMMAND(ID_VIEW_BALL_LOCUS, OnViewBallLocus)
	ON_UPDATE_COMMAND_UI(ID_VIEW_BALL_LOCUS, OnUpdateViewBallLocus)
	ON_COMMAND(ID_VIEW_PLAYER_LOCUS, OnViewPlayerLocus)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PLAYER_LOCUS, OnUpdateViewPlayerLocus)
	ON_UPDATE_COMMAND_UI(ID_LOG_GOTO_END, OnUpdateLogGotoEnd)
	ON_COMMAND(ID_SAVE_LOG_TO_TEXT, OnSaveLogToText)
	ON_UPDATE_COMMAND_UI(ID_SAVE_LOG_TO_TEXT, OnUpdateSaveLogToText)
	ON_UPDATE_COMMAND_UI(ID_SEGMENT_MARK_IN, OnUpdateSegmentMarkIn)
	ON_UPDATE_COMMAND_UI(ID_SEGMENT_MARK_OUT, OnUpdateSegmentMarkOut)
	ON_COMMAND(ID_OPEN_RCL_FILE, OnOpenRclFile)
	ON_UPDATE_COMMAND_UI(ID_OPEN_RCL_FILE, OnUpdateOpenRclFile)
	ON_COMMAND(ID_VIEW_SAY_MESSAGE, OnViewSayMessage)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SAY_MESSAGE, OnUpdateViewSayMessage)
	ON_COMMAND(ID_PLAYER_AUTO_SELECT, OnPlayerAutoSelect)
	ON_UPDATE_COMMAND_UI(ID_PLAYER_AUTO_SELECT, OnUpdatePlayerAutoSelect)
	ON_COMMAND(ID_LOG_ACCELERATE, OnLogAccelerate)
	ON_COMMAND(ID_LOG_BACKPLAY, OnLogBackplay)
	ON_COMMAND(ID_LOG_DECELERATE, OnLogDecelerate)
	ON_COMMAND(ID_LOG_GOTO, OnLogGoto)
	ON_COMMAND(ID_LOG_GOTO_END, OnLogGotoEnd)
	ON_COMMAND(ID_LOG_REWIND, OnLogRewind)
	ON_COMMAND(ID_LOG_START, OnLogStart)
	ON_COMMAND(ID_LOG_STEP, OnLogStep)
	ON_COMMAND(ID_LOG_STEP_BACK, OnLogStepBack)
	ON_COMMAND(ID_LOG_STOP, OnLogStop)
	ON_COMMAND(ID_MONITOR_MOVE_PLAYER, OnMonitorMovePlayer)
	ON_COMMAND(ID_MONITOR_DISCARD_PLAYER, OnMonitorDiscardPlayer)
	ON_UPDATE_COMMAND_UI(ID_MONITOR_DISCARD_PLAYER, OnUpdateMonitorDiscardPlayer)
	ON_COMMAND(ID_COACH_EYE, OnCoachEye)
	ON_COMMAND(ID_COACH_EAR, OnCoachEar)
	ON_COMMAND(ID_COACH_LOOK, OnCoachLook)
	ON_COMMAND(ID_TRAINER_MOVE_BALL, OnTrainerMoveBall)
	ON_UPDATE_COMMAND_UI(ID_TRAINER_MOVE_BALL, OnUpdateTrainerMoveBall)
	ON_COMMAND(ID_TRAINER_PAUSE_GAME, OnTrainerPauseGame)
	ON_COMMAND(ID_TRAINER_STOP_GAME, OnTrainerStopGame)
	ON_UPDATE_COMMAND_UI(ID_CHANGE_COLOR, OnUpdateChangeColor)
	ON_COMMAND(ID_LOG_GOTO_NEXT_SCORE, OnLogGotoNextScore)
	ON_UPDATE_COMMAND_UI(ID_LOG_GOTO_NEXT_SCORE, OnUpdateLogGotoNextScore)
	ON_COMMAND(ID_LOG_GOTO_PASS_SCENE, OnLogGotoPassScene)
	ON_UPDATE_COMMAND_UI(ID_LOG_GOTO_PASS_SCENE, OnUpdateLogGotoPassScene)
	ON_COMMAND(ID_LOG_GOTO_INT_SCENE, OnLogGotoInterceptScene)
	ON_UPDATE_COMMAND_UI(ID_LOG_GOTO_INT_SCENE, OnUpdateLogGotoInterceptScene)
	ON_COMMAND(ID_VIEW_VORONOI_DIAGRAM, OnViewVoronoiDiagram)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VORONOI_DIAGRAM, OnUpdateViewVoronoiDiagram)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



const double CSoccermonitorDoc::S_MAX_FIELD_SCALE = 400.0;
const double CSoccermonitorDoc::S_MIN_FIELD_SCALE = 4.0;
const int CSoccermonitorDoc::S_MAX_FONT_SIZE = 200;
const int CSoccermonitorDoc::S_MIN_FONT_SIZE = 100;
const int CSoccermonitorDoc::S_MAX_PLAYER_FONT_SIZE = 150;
const int CSoccermonitorDoc::S_MIN_PLAYER_FONT_SIZE = 80;

/////////////////////////////////////////////////////////////////////////////
// CSoccermonitorDoc construction/destruction

CSoccermonitorDoc::CSoccermonitorDoc()
{
    M_segment_markin_cycle = 0;
    M_segment_markout_cycle = 0;//ciwp
    // initialize members
    m_pLogPlayer = new TLogPlayer(this);
    m_pSocket = NULL;
    // if initialized with TRUE, the connection dialog comes up at each first connection
    m_bHadConnectionError = TRUE;
    M_l_clicked = false;
    // create all pens and brushes and fonts
    M_brush_field = new CBrush;
    M_brush_goal_post = new CBrush;
    M_brush_ball = new CBrush;
    M_brush_player_eye = new CBrush;
    M_brush_body_dir = new CBrush;
    M_brush_left_player = new CBrush;
    M_brush_left_goalie = new CBrush;
    M_brush_right_player = new CBrush;
    M_brush_right_goalie = new CBrush;
    M_brush_ball_collide = new CBrush;
    M_brush_player_collide = new CBrush;
    
    M_brush_kick_fault = new CBrush;
    M_brush_catch = new CBrush;
    M_brush_catch_fault = new CBrush;
    M_brush_tackle = new CBrush;
    M_brush_tackle_fault = new CBrush;
    
    M_pen_line = new CPen;
    M_pen_goal_post = new CPen;
    M_pen_flag = new CPen;
    M_pen_offside_line = new CPen;
    M_pen_voronoi_diagram = new CPen;

    M_pen_player_edge = new CPen;
    M_pen_player_body_dir = new CPen;
    M_pen_left_player_edge = new CPen;
    M_pen_right_player_edge = new CPen;
	M_pen_player_rec_tired = new CPen;
	M_pen_player_eff_tired = new CPen;
    M_pen_player_control_area = new CPen;
    M_pen_player_kick = new CPen;
    M_pen_player_kick_fault = new CPen;
    M_pen_player_tackle = new CPen;
    M_pen_player_tackle_fault = new CPen;
    M_pen_player_vcone = new CPen;
    M_pen_player_varea = new CPen;
    M_pen_player_catch = new CPen;
    M_pen_ball = new CPen;

    M_font_team_name = new CFont;
    M_font_score = new CFont;
    M_font_player = new CFont;
    M_font_time = new CFont;

    M_pen_click_point = new CPen;
    M_pen_drag_line = new CPen;


    M_monitor_port = 6000U;
    M_server_host = "127.0.0.1";
    
    M_coach_port = 6001U;
    M_connected = false;
    M_coach_connected = false;
    m_pMsgView = NULL;
    M_coach_view_ptr = NULL;

    M_focus_point_x = M_focus_point_y = 0.0;

    M_view_flags = false;
    M_field_grass_type = GRASS_MONO;

    M_view_body_shadow = true;
    M_view_eyes = false;

    M_selected_player = 0;
    M_player_auto_select = false;

    M_ball_dlg_ptr = NULL;
    M_status_dlg_ptr = NULL;
    M_player_type_dlg_ptr = NULL;
    M_player_type_list_dlg_ptr = NULL;
    M_say_message_dlg_ptr = NULL;

    M_last_draw_cycle = 0;
    M_last_draw_pmode = 0;


    M_color_save = false;
    // load settings from .ini

    CWinApp* pApp = AfxGetApp();
    CString strSection = "SoccerWindow ColorSection";
    CString strKey;
    CString strValue;

    strKey = "Score";
    strValue.Format("%ld", COLOR_BLACK);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_score = atol(strValue);

    strKey = "FieldLight";
    strValue.Format("%ld", COLOR_FIELD);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_field = atol(strValue);

    strKey = "FieldDark";
    strValue.Format("%ld", COLOR_FIELD_DARK);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_field_dark = atol(strValue);

    strKey = "Lines";
    strValue.Format("%ld", COLOR_LINES);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_lines = atol(strValue);

    strKey = "Flag";
    strValue.Format("%ld", COLOR_FLAG);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_flag = atol(strValue);

    strKey = "Goal";
    strValue.Format("%ld", COLOR_GOAL);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_goal = atol(strValue);

    strKey = "GoalPost";
    strValue.Format("%ld", COLOR_GOALPOST);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_goalpost = atol(strValue);

    strKey = "OffsideLine";
    strValue.Format("%ld", COLOR_RED);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_offside_line = atol(strValue);

    strKey = "VoronoiDiagram";
    strValue.Format("%ld", COLOR_WHITE);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_voronoi_diagram = atol(strValue);

    strKey = "Ball";
    strValue.Format("%ld", COLOR_BALL);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_ball = atol(strValue);

    strKey = "PlayerEdge";
    strValue.Format("%ld", COLOR_BLACK);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_player_edge = atol(strValue);

    strKey = "LeftTeam";
    strValue.Format("%ld", COLOR_TEAM_L);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_left_team = atol(strValue);

    strKey = "LeftGoalie";
    strValue.Format("%ld", COLOR_TEAM_L_GOALIE);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_left_goalie = atol(strValue);

    strKey = "RightTeam";
    strValue.Format("%ld", COLOR_TEAM_R);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_right_team = atol(strValue);

    strKey = "RightGoalie";
    strValue.Format("%ld", COLOR_TEAM_R_GOALIE);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_right_goalie = atol(strValue);

    strKey = "PlayerFont1";
    strValue.Format("%ld", COLOR_WHITE);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_player_font1 = atol(strValue);

    strKey = "PlayerFont2";
    //strValue.Format("%ld", COLOR_YELLOW);
    strValue.Format("%ld", COLOR_PLAYER_FONT2);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_player_font2 = atol(strValue);

    strKey = "BodyDir";
    strValue.Format("%ld", COLOR_BODY_DIR);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_body_dir = atol(strValue);

    strKey = "ViewCone";
    strValue.Format("%ld", COLOR_VIEW_CONE);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_view_cone = atol(strValue);

    strKey = "ViewArea";
    strValue.Format("%ld", COLOR_VIEW_AREA);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_view_area = atol(strValue);

    strKey = "ControlArea";
    strValue.Format("%ld", COLOR_YELLOW);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_control_area = atol(strValue);
    
    strKey = "EffortTired";
    strValue.Format("%ld", COLOR_RED);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_effort_tired = atol(strValue);

    strKey = "RecoveryTired";
    strValue.Format("%ld", COLOR_YELLOW);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_recovery_tired = atol(strValue);

    strKey = "KickEdge";
    strValue.Format("%ld", COLOR_WHITE);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_kick_edge = atol(strValue);

    strKey = "KickFault";
    strValue.Format("%ld", COLOR_KICK_FAULT);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_kick_fault = atol(strValue);

    strKey = "GoalieCatch";
    strValue.Format("%ld", COLOR_GOALIE_CATCH);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_goalie_catch = atol(strValue);

    strKey = "GoalieCatchFault";
    strValue.Format("%ld", COLOR_GOALIE_CATCH_FAULT);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_goalie_catch_fault = atol(strValue);

    strKey = "Tackle";
    strValue.Format("%ld", COLOR_TACKLE);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_tackle = atol(strValue);

    strKey = "TackleFault";
    strValue.Format("%ld", COLOR_TACKLE_FAULT);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_tackle_fault = atol(strValue);

    strKey = "BallCollide";
    strValue.Format("%ld", COLOR_BALL_COLLIDE);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_ball_collide = atol(strValue);

    strKey = "PlayerCollide";
    strValue.Format("%ld", COLOR_PLAYER_COLLIDE);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_player_collide = atol(strValue);
    
    strKey = "ClickPoint";
    strValue.Format("%ld", COLOR_RED);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_click_point = atol(strValue);
    
    strKey = "DragLine";
    strValue.Format("%ld", COLOR_BLUE);
    strValue = pApp->GetProfileString(strSection, strKey, strValue);
    M_color_drag_line = atol(strValue);

    // create gdi objects
    createGdiObject();
}

CSoccermonitorDoc::~CSoccermonitorDoc()
{
    if ( M_ball_dlg_ptr )
    {
        delete M_ball_dlg_ptr;
        M_ball_dlg_ptr = NULL;
    }
    if ( M_status_dlg_ptr )
    {
        delete M_status_dlg_ptr;
        M_status_dlg_ptr = NULL;
    }
    if ( M_player_type_dlg_ptr )
    {
        delete M_player_type_dlg_ptr;
        M_player_type_dlg_ptr = NULL;
    }
    if ( M_player_type_list_dlg_ptr )
    {
        delete M_player_type_list_dlg_ptr;
        M_player_type_list_dlg_ptr = NULL;
    }
    if ( M_say_message_dlg_ptr )
    {
        delete M_say_message_dlg_ptr;
        M_say_message_dlg_ptr = NULL;
    }

    // delete the gdi objects
    deleteGdiObject();

    
    // and delete the objects
    delete M_brush_field;
    delete M_pen_line;
    delete M_pen_goal_post;
    delete M_brush_goal_post;
    delete M_pen_flag;
    delete M_pen_offside_line;
    delete M_pen_voronoi_diagram;

    delete M_pen_ball;
    delete M_brush_ball;

    delete M_pen_player_edge;
    delete M_pen_left_player_edge;
    delete M_pen_right_player_edge;
    delete M_pen_player_body_dir;
    delete M_brush_body_dir;
    delete M_brush_player_eye;
    delete M_brush_left_player;
    delete M_brush_left_goalie;
    delete M_brush_right_player;
    delete M_brush_right_goalie;

    delete M_pen_player_kick;
    delete M_pen_player_kick_fault;
    delete M_brush_kick_fault;
    delete M_pen_player_catch;
    delete M_brush_catch;
    delete M_brush_catch_fault;
    delete M_pen_player_tackle;
    delete M_brush_tackle;
    delete M_pen_player_tackle_fault;
    delete M_brush_tackle_fault;
    delete M_brush_ball_collide;
    delete M_brush_player_collide;
    
	delete M_pen_player_rec_tired;
	delete M_pen_player_eff_tired;

    delete M_pen_player_control_area;
    delete M_pen_player_vcone;
    delete M_pen_player_varea;

    delete M_pen_click_point;
    delete M_pen_drag_line;

    delete M_font_team_name;
    delete M_font_score;
    delete M_font_player;
    delete M_font_time;
    
    delete m_pLogPlayer;


    if ( M_color_save )
    {
        CWinApp* pApp = AfxGetApp();
        CString strSection = "SoccerWindow ColorSection";
        CString strKey;
        CString strValue;

        strKey = "Score";
        strValue.Format("%ld", (long)M_color_score);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "FieldLight";
        strValue.Format("%ld", (long)M_color_field);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "FieldDark";
        strValue.Format("%ld", (long)M_color_field_dark);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "Lines";
        strValue.Format("%ld", (long)M_color_lines);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "Flag";
        strValue.Format("%ld", (long)M_color_flag);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "Goal";
        strValue.Format("%ld", (long)M_color_goal);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "GoalPost";
        strValue.Format("%ld", (long)M_color_goalpost);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "OffsideLine";
        strValue.Format("%ld", (long)M_color_offside_line);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "VoronoiDiagram";
        strValue.Format("%ld", (long)M_color_voronoi_diagram);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "Ball";
        strValue.Format("%ld", (long)M_color_ball);
        pApp->WriteProfileString(strSection, strKey, strValue);
        
        strKey = "PlayerEdge";
        strValue.Format("%ld", (long)M_color_player_edge);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "LeftTeam";
        strValue.Format("%ld", (long)M_color_left_team);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "LeftGoalie";
        strValue.Format("%ld", (long)M_color_left_goalie);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "RightTeam";
        strValue.Format("%ld", (long)M_color_right_team);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "RightGoalie";
        strValue.Format("%ld", (long)M_color_right_goalie);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "PlayerFont1";
        strValue.Format("%ld", (long)M_color_player_font1);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "PlayerFont2";
        strValue.Format("%ld", (long)M_color_player_font2);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "BocyDir";
        strValue.Format("%ld", (long)M_color_body_dir);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "ViewCone";
        strValue.Format("%ld", (long)M_color_view_cone);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "ViewArea";
        strValue.Format("%ld", (long)M_color_view_area);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "ControlArea";
        strValue.Format("%ld", (long)M_color_control_area);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "EffortTired";
        strValue.Format("%ld", (long)M_color_effort_tired);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "RecoveryTired";
        strValue.Format("%ld", (long)M_color_recovery_tired);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "KickEdge";
        strValue.Format("%ld", (long)M_color_kick_edge);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "KickFault";
        strValue.Format("%ld", (long)M_color_kick_fault);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "GoalieCatch";
        strValue.Format("%ld", (long)M_color_goalie_catch);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "GoalieCatchFault";
        strValue.Format("%ld", (long)M_color_goalie_catch_fault);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "Tackle";
        strValue.Format("%ld", (long)M_color_tackle);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "TackleFault";
        strValue.Format("%ld", (long)M_color_tackle_fault);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "BallCollide";
        strValue.Format("%ld", (long)M_color_ball_collide);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "PlayerCollide";
        strValue.Format("%ld", (long)M_color_player_collide);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "ClickPoint";
        strValue.Format("%ld", (long)M_color_click_point);
        pApp->WriteProfileString(strSection, strKey, strValue);

        strKey = "DragLine";
        strValue.Format("%ld", (long)M_color_drag_line);
        pApp->WriteProfileString(strSection, strKey, strValue);
    }

}

BOOL CSoccermonitorDoc::OnNewDocument()
{
    if ( ! CDocument::OnNewDocument() )
    {
        return FALSE;
    }
    
    SetTitle("Untitled");
    
    // get the soccermonitor view
    for ( POSITION pos = GetFirstViewPosition(); pos != NULL; )
    {
        CView* pView = GetNextView(pos);
        
        if ( pView->IsKindOf(RUNTIME_CLASS(CSoccermonitorView)) )
        {
            m_pView = (CSoccermonitorView*)pView;
        }
        else if ( pView->IsKindOf(RUNTIME_CLASS(TMessageView)) )
        {
            m_pMsgView = (TMessageView*)pView;
        }
        else if ( pView->IsKindOf(RUNTIME_CLASS(TCoachView)) )
        {
            M_coach_view_ptr = (TCoachView*)pView;
        }
    }
    
    // initialize the logplayer
    m_pLogPlayer->InitLog();
    M_last_pointto_unum = 0;
    M_pointto_x = 0;
    M_pointto_y = 0;
    M_pointto_start_time = -100;

    // stop an eventually running server on ultra
    
    M_connected = false;
    m_bTryingToConnect = FALSE;
    m_pInfo = NULL;
    
    m_bStarted = FALSE;
    m_bViewReferee = TRUE;

    M_monitor_move_player = false;
    M_monitor_discard_player = false;

    M_view_ball = true;
    M_view_players = true;
    M_view_numbers = true;
    M_view_player_type = false;
    //	m_bViewColor = FALSE;
    M_enlarged = true;
    M_view_control_area = false;

    M_view_visible_cone = true;
    M_view_measure = false;
    M_view_offside_line = false;
    M_view_voronoi_diagram = false;
    M_reverse_x = false;

    M_focus_type = FOCUS_AUTO;
    M_drag_zoom = false;

    M_zoomed = false;
    
    M_focus_point_x = M_focus_point_y = 0.0;

    m_iOldTime = -1;
    
    M_selected_player = 0;
    //M_player_auto_select = false;

    M_view_ball_detail = false;
    if ( M_ball_dlg_ptr
         && M_ball_dlg_ptr->IsWindowVisible() )
    {
        M_ball_dlg_ptr->ShowWindow(SW_HIDE);
    }


    M_view_player_detail = true;
    if ( M_status_dlg_ptr
         && M_status_dlg_ptr->IsWindowVisible() )
    {
        M_status_dlg_ptr->ShowWindow(SW_HIDE);
        M_status_dlg_ptr->reset();
    }

    if ( M_player_type_dlg_ptr
         && M_player_type_dlg_ptr->IsWindowVisible() )
    {
        M_player_type_dlg_ptr->ShowWindow(SW_HIDE);
        M_player_type_dlg_ptr->reset();
    }

    if ( M_player_type_list_dlg_ptr )
    {
        //M_player_type_list_dlg_ptr->ShowWindow(SW_HIDE);
        M_player_type_list_dlg_ptr->DestroyWindow();
        delete M_player_type_list_dlg_ptr;
        M_player_type_list_dlg_ptr = NULL;
    }

    if ( M_say_message_dlg_ptr )
    {
        M_say_message_dlg_ptr->DestroyWindow();
        delete M_say_message_dlg_ptr;
        M_say_message_dlg_ptr = NULL;
    }

    M_last_draw_cycle = 0;
    M_last_draw_pmode = 0;

    M_ball_trace_start_cycle = -1;
    M_player_trace_start_cycle = -1;

    M_segment_markin_cycle = -1;
    M_segment_markout_cycle = -1;
    return TRUE;
}

void CSoccermonitorDoc::DeleteContents() 
{
    // delete socket
    TRACE0("delete contents\n");
    DeleteSocket();
    
    CDocument::DeleteContents();
}

/////////////////////////////////////////////////////////////////////////////
// CSoccermonitorDoc serialization

void CSoccermonitorDoc::Serialize(CArchive& ar)
{
    m_pLogPlayer->Serialize(ar);
    SetModifiedFlag(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// CSoccermonitorDoc diagnostics

#ifdef _DEBUG
void CSoccermonitorDoc::AssertValid() const
{
    CDocument::AssertValid();
}

void CSoccermonitorDoc::Dump(CDumpContext& dc) const
{
    CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSoccermonitorDoc commands


void CSoccermonitorDoc::createGdiObject()
{
    if ( ! M_brush_field->CreateHatchBrush(HS_DIAGCROSS, M_color_field_dark) )
    {
        M_brush_field->CreateStockObject(WHITE_BRUSH);
    }
    if ( ! M_brush_goal_post->CreateSolidBrush(M_color_goalpost) )
    {
        M_brush_goal_post->CreateStockObject(WHITE_BRUSH);
    }
    if ( ! M_brush_ball->CreateSolidBrush(M_color_ball) )
    {
        M_brush_ball->CreateStockObject(GRAY_BRUSH);
    }

    if ( ! M_brush_body_dir->CreateSolidBrush(M_color_body_dir) )
    {
        M_brush_body_dir->CreateStockObject(BLACK_BRUSH);
    }
    if ( ! M_brush_player_eye->CreateSolidBrush(M_color_view_cone) )
	{
        M_brush_player_eye->CreateStockObject(WHITE_BRUSH);
	}
    if ( ! M_brush_left_player->CreateSolidBrush(M_color_left_team) )
    {
        M_brush_left_player->CreateStockObject(WHITE_BRUSH);
    }
    if ( ! M_brush_left_goalie->CreateSolidBrush(M_color_left_goalie) )
    {
        M_brush_left_goalie->CreateStockObject(WHITE_BRUSH);
    }
    if ( ! M_brush_right_player->CreateSolidBrush(M_color_right_team) )
    {
        M_brush_right_player->CreateStockObject(BLACK_BRUSH);
    }
    if ( ! M_brush_right_goalie->CreateSolidBrush(M_color_right_goalie) )
    {
        M_brush_right_goalie->CreateStockObject(WHITE_BRUSH);
    }
    if ( ! M_brush_ball_collide->CreateSolidBrush(M_color_ball_collide) )
	{
        M_brush_ball_collide->CreateStockObject(WHITE_BRUSH);
	}
    
    if ( ! M_brush_player_collide->CreateSolidBrush(M_color_player_collide) )
	{
        M_brush_player_collide->CreateStockObject(WHITE_BRUSH);
	}
    
        
    ////state brushs

    M_brush_kick_fault->CreateSolidBrush(M_color_kick_fault);
    M_brush_catch->CreateSolidBrush(M_color_goalie_catch);
    M_brush_catch_fault->CreateSolidBrush(M_color_goalie_catch_fault);
    M_brush_tackle->CreateSolidBrush(M_color_tackle);
    M_brush_tackle_fault->CreateSolidBrush(M_color_tackle_fault);
    
    // pens
    M_pen_click_point->CreatePen(PS_SOLID, 1, M_color_click_point);
    M_pen_drag_line->CreatePen(PS_SOLID, 1, M_color_drag_line);

    if ( ! M_pen_line->CreatePen(PS_SOLID, 2, M_color_lines) )
    {
        M_pen_line->CreateStockObject(WHITE_PEN);
    }
    if ( ! M_pen_goal_post->CreatePen(PS_SOLID, 1, M_color_goalpost) )
    {
        M_pen_goal_post->CreateStockObject(BLACK_PEN);
    }
    if ( ! M_pen_flag->CreatePen(PS_SOLID, 1, M_color_flag) )
    {
        M_pen_flag->CreateStockObject(WHITE_PEN);
    }
    if ( ! M_pen_offside_line->CreatePen(PS_SOLID, 1, M_color_offside_line) )
    {
        M_pen_offside_line->CreateStockObject(WHITE_PEN);
    }
    if ( ! M_pen_voronoi_diagram->CreatePen(PS_SOLID, 1, M_color_voronoi_diagram) )
    {
        M_pen_voronoi_diagram->CreateStockObject(WHITE_PEN);
    }

    if ( ! M_pen_player_edge->CreatePen(PS_SOLID, 1, M_color_player_edge) )
    {
        M_pen_player_edge->CreateStockObject(BLACK_PEN);
    }
    if ( ! M_pen_player_body_dir->CreatePen(PS_SOLID, 1, M_color_body_dir) )
    {
        M_pen_player_body_dir->CreateStockObject(BLACK_PEN);
    }

    if ( ! M_pen_left_player_edge->CreatePen(PS_SOLID, 1, M_color_left_team) )
    {
        M_pen_left_player_edge->CreateStockObject(BLACK_PEN);
    }
    if ( ! M_pen_right_player_edge->CreatePen(PS_SOLID, 1, M_color_right_team) )
    {
        M_pen_right_player_edge->CreateStockObject(BLACK_PEN);
    }

    if ( ! M_pen_player_rec_tired->CreatePen(PS_SOLID, 1, M_color_recovery_tired) )
	{
        M_pen_player_rec_tired->CreateStockObject(BLACK_PEN);
	}
    if ( ! M_pen_player_eff_tired->CreatePen(PS_SOLID, 1, M_color_effort_tired) )
	{
        M_pen_player_eff_tired->CreateStockObject(BLACK_PEN);
	}

    if ( ! M_pen_player_control_area->CreatePen(PS_SOLID, 1, M_color_control_area) )
    {
        M_pen_player_control_area->CreateStockObject(BLACK_PEN);
    }
    if ( ! M_pen_player_kick->CreatePen(PS_SOLID, 2, M_color_kick_edge) )
    {
        M_pen_player_kick->CreateStockObject(BLACK_PEN);
    }
    if ( ! M_pen_player_kick_fault->CreatePen(PS_SOLID, 2, M_color_kick_fault) )
    {
        M_pen_player_kick_fault->CreateStockObject(BLACK_PEN);
    }
    if ( ! M_pen_player_tackle->CreatePen(PS_SOLID, 2, M_color_tackle) )
    {
        M_pen_player_tackle->CreateStockObject(BLACK_PEN);
    }
    if ( ! M_pen_player_tackle_fault->CreatePen(PS_SOLID, 2, M_color_tackle_fault) )
    {
        M_pen_player_tackle_fault->CreateStockObject(BLACK_PEN);
    }
    if ( ! M_pen_player_catch->CreatePen(PS_SOLID, 2, M_color_goalie_catch) )
    {
        M_pen_player_catch->CreateStockObject(BLACK_PEN);
    }

    if ( ! M_pen_player_vcone->CreatePen(PS_SOLID, 1, M_color_view_cone) )
	{
        M_pen_player_vcone->CreateStockObject(BLACK_PEN);
	}
    if ( ! M_pen_player_varea->CreatePen(PS_SOLID, 1, M_color_view_area) )
	{
        M_pen_player_varea->CreateStockObject(BLACK_PEN);
	}
    if ( ! M_pen_ball->CreatePen(PS_SOLID, 1, M_color_ball) )
    {
        M_pen_ball->CreateStockObject(BLACK_PEN);
    }
}

void CSoccermonitorDoc::deleteGdiObject()
{
    // delete the gdi objects
    M_brush_field->DeleteObject();
    M_pen_line->DeleteObject();
    M_pen_goal_post->DeleteObject();
    M_brush_goal_post->DeleteObject();
    M_pen_flag->DeleteObject();
    M_pen_offside_line->DeleteObject();
    M_pen_voronoi_diagram->DeleteObject();

    M_pen_ball->DeleteObject();
    M_brush_ball->DeleteObject();

    M_pen_player_edge->DeleteObject();
    M_pen_left_player_edge->DeleteObject();
    M_pen_right_player_edge->DeleteObject();
    M_pen_player_body_dir->DeleteObject();
    M_brush_body_dir->DeleteObject();
    M_brush_player_eye->DeleteObject();
    M_brush_left_player->DeleteObject();
    M_brush_left_goalie->DeleteObject();
    M_brush_right_player->DeleteObject();
    M_brush_right_goalie->DeleteObject();

    M_pen_player_kick->DeleteObject();
    M_pen_player_kick_fault->DeleteObject();
    M_brush_kick_fault->DeleteObject();
    M_pen_player_catch->DeleteObject();
    M_brush_catch->DeleteObject();
    M_brush_catch_fault->DeleteObject();
    M_pen_player_tackle->DeleteObject();
    M_brush_tackle->DeleteObject();
    M_pen_player_tackle_fault->DeleteObject();
    M_brush_tackle_fault->DeleteObject();
    M_brush_ball_collide->DeleteObject();
    M_brush_player_collide->DeleteObject();

	M_pen_player_rec_tired->DeleteObject();
	M_pen_player_eff_tired->DeleteObject();

    M_pen_player_control_area->DeleteObject();
    M_pen_player_vcone->DeleteObject();
    M_pen_player_varea->DeleteObject();
    
    M_pen_click_point->DeleteObject();
    M_pen_drag_line->DeleteObject(); 

}



void CSoccermonitorDoc::DeleteSocket()
{
    // closes down the socket and deletes it
    if ( m_pSocket != NULL )
    {
        BYTE Buffer[5000];
        //		m_pSocket->ShutDown();
        
        int wieoft = 0;
        while(m_pSocket->Receive(Buffer, 5000) > 0)
            wieoft++;
        
#ifdef _DEBUG
        TRACE2("Delete socket: NoOfMsgRead %d, error %d\n", wieoft, GetLastError());
#endif
        delete m_pSocket;
        m_pSocket = NULL;
    }
}	

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::newInfo(showinfo_t* tInfo)
{
    showinfo_t2 showinfo2;
    // is it the first info
    if ( m_bTryingToConnect )
    {
        m_pView->stopConnectTimer();
        M_connected = true;
        m_bTryingToConnect = FALSE;
        m_bHadConnectionError = FALSE;
    }

    m_pLogPlayer->pos2ball(&showinfo2.ball, &(tInfo->pos[0]));
    for ( int i = 1; i < MAX_PLAYER * 2 + 1; i++ )
    {
        m_pLogPlayer->pos2player(&showinfo2.pos[i-1], &(tInfo->pos[i]));
    }
    showinfo2.team[0] = tInfo->team[0];
    showinfo2.team[1] = tInfo->team[1];
    showinfo2.pmode = tInfo->pmode;
    showinfo2.time = tInfo->time;

    // save the loginfo and draw the cycle
    m_pLogPlayer->addShowinfo(&showinfo2);
    m_pLogPlayer->setCurrentCycle(m_pLogPlayer->getMaxCycle() - 1);
    
    // check if game is running
    if ( m_iOldTime == m_pInfo->time )
    {
        SetStarted(FALSE);
    }
    else
    {
        SetStarted(TRUE);
    }
    
    m_iOldTime = m_pInfo->time;
    
    // set to unsaved
    SetModifiedFlag(TRUE);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::NewInfo(showinfo_t2* tInfo)
{
    // is it the first info
    if ( m_bTryingToConnect )
    {
        m_pView->stopConnectTimer();
        M_connected = true;
        m_bTryingToConnect = FALSE;
        m_bHadConnectionError = FALSE;
    }

    // save the loginfo and draw the cycle
    m_pLogPlayer->addShowinfo(tInfo);
    m_pLogPlayer->setCurrentCycle(m_pLogPlayer->getMaxCycle() - 1);
    
    // check if game is running
    if ( m_iOldTime == m_pInfo->time )
    {
        SetStarted(FALSE);
    }
    else
    {
        SetStarted(TRUE);
    }
    
    m_iOldTime = m_pInfo->time;
    
    // set to unsaved
    SetModifiedFlag(TRUE);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::NewMsg(msginfo_t* tInfo)
{
    // is it the first info
    if ( m_bTryingToConnect )
    {
        m_pView->stopConnectTimer();
        M_connected = true;
        m_bTryingToConnect = FALSE;
    }
    
    // a message has been received
    CString	message = tInfo->message;
    if (tInfo->board == MSG_BOARD) 
    {
        if ( ! message.Compare("(referee half_time)\n") ) 
        {
            // it is halftime
            SetStarted(FALSE);
        }
        else if ( ! message.Compare("(referee time_extended)\n") 
                 || ! message.Compare("(referee time_over)\n") )
        {
            // it is extended time
            SetStarted(FALSE);
        }
    }
    
    // save the loginfo and draw the cycle
    //m_pLogPlayer->addMsginfo(tInfo);
    
    // show the new info
    ShowString(m_pLogPlayer->getCurrentCycle(),
               tInfo->message, (BYTE) tInfo->board);
    
    // set to unsaved
    SetModifiedFlag(TRUE);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::newParam(player_params_t *pparam)
{
    m_pLogPlayer->setParam(pparam);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::newParam(player_type_t *ptinfo)
{
    m_pLogPlayer->setParam(ptinfo);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::newParam(server_params_t *sparam)
{
    m_pLogPlayer->setParam(sparam);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::ShowString(long tm, LPCTSTR msg, BYTE board)
{
    BOOL	bModified;
    
    if ( m_bViewReferee && board != MSG_BOARD )
    {
        return;
    }
    
    // do not care, whether content of message window has changed
    bModified = IsModified();
    if ( m_pMsgView != NULL )
    {
        m_pMsgView->ShowString(tm, msg, board);
    }
    SetModifiedFlag(bModified);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::RedrawDoc()
{
    CDC		dcMem;
    CBitmap	myBitmap;
    CRect	windowRect;
    int		sizeX, sizeY;
        
    // get the view to update it
    CClientDC dc(m_pView);
    
    // prepare the memory device context
    if ( ! dcMem.CreateCompatibleDC(&dc) )
    {
#ifdef _DEBUG
        afxDump << "Error Creating DC! \n";
#endif
        return;
    }
    
    // get Device Coordinates
    dc.GetWindow()->GetClientRect(&windowRect);
    windowRect.NormalizeRect();
    sizeX = windowRect.Width();
    if ( sizeX < 40 )
    {
        // window is too small
        dcMem.DeleteDC();
        return;
    }
    
    sizeY = windowRect.Height();

    m_iSizeX = sizeX;
    m_iSizeY = sizeY;

    int y_shift = 0;
    if ( ! M_zoomed )
    {
        M_field_scale = (double)sizeX / (PITCH_LENGTH + PITCH_MARGIN * (2.0 + y_shift));
    
        if ( (PITCH_WIDTH + PITCH_MARGIN * 2.0 + TOP_MARGIN) * M_field_scale > (double)sizeY )
        {
            M_field_scale = (double)sizeY / (PITCH_WIDTH + PITCH_MARGIN * (2.0 + y_shift) + TOP_MARGIN);
        }
        if ( M_field_scale < S_MIN_FIELD_SCALE )
        {
            M_field_scale = S_MIN_FIELD_SCALE;
        }
        y_shift = scale(0.3 * PITCH_MARGIN);
    }

    if ( m_pInfo )
    {
        if ( M_player_auto_select )
        {
            Vector2D bpos((double)m_pInfo->ball.x / SHOWINFO_SCALE2,
                          (double)m_pInfo->ball.y / SHOWINFO_SCALE2);
            if ( M_reverse_x )
            {
                bpos *= -1.0;
            }
            M_selected_player = FindPlayer(bpos, 200.0);
            selectPlayerType();
        }

        if ( M_focus_type == FOCUS_BALL )
        {
            M_focus_point_x = m_pInfo->ball.x / SHOWINFO_SCALE2;
            M_focus_point_y = m_pInfo->ball.y / SHOWINFO_SCALE2;
            if ( M_reverse_x )
            {
                M_focus_point_x *= -1.0;
                M_focus_point_y *= -1.0;
            }
        }
        else if ( M_focus_type == FOCUS_PLAYER
                  && M_selected_player > 0
                  && m_pInfo->pos[M_selected_player - 1].mode )
        {
            const player_t& player = m_pInfo->pos[M_selected_player - 1];
            M_focus_point_x = player.x / SHOWINFO_SCALE2;
            M_focus_point_y = player.y / SHOWINFO_SCALE2;
            if ( M_reverse_x )
            {
                M_focus_point_x *= -1.0;
                M_focus_point_y *= -1.0;
            }
        }
    }

    M_field_center_x = m_iSizeX/2 - scale(M_focus_point_x);
    M_field_center_y = m_iSizeY/2 + y_shift - scale(M_focus_point_y);

    
    // set the size of the bitmap, to be read by the drawing functions
    if ( ! myBitmap.CreateCompatibleBitmap(&dc, sizeX, sizeY) )
    {
#ifdef _DEBUG
        afxDump << "Error Creating Bitmap! \n";
#endif
        dcMem.DeleteDC();
        return;
    }
    
    myBitmap.SetBitmapDimension(sizeX, sizeY);
    ASSERT(myBitmap.m_hObject != NULL);
    CBitmap* pOldBitmap = dcMem.SelectObject(&myBitmap);
    
    // draw the things
    DrawSoccer(&dcMem);
    //draw the cursor pos
    Drawcurpos(&dcMem);
    // copy the memory bitmap into the window
    dc.BitBlt(0, 0, sizeX, sizeY, &dcMem, 0, 0, SRCCOPY);
    
    // remove the created bitmap
    dcMem.SelectObject(pOldBitmap);
    myBitmap.DeleteObject();
    dcMem.DeleteDC();
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::DrawSoccer(CDC* pDC)
{
    //COLORREF	oldTextColor;
    //COLORREF	oldBkColor;
    
    // draw field
    CBrush* oldBrush = pDC->SelectObject(M_brush_ball);
    CPen* oldPen = pDC->SelectObject(M_pen_line);
    DrawField(pDC);

    if ( m_pInfo != NULL )
    {
        //CString posString, temp;

        // set font
        const int BASE_FONT_SIZE = scale(FONT_SIZE_METER);
        int	nPointSize = 14 * BASE_FONT_SIZE;
        if ( nPointSize > S_MAX_FONT_SIZE ) nPointSize = S_MAX_FONT_SIZE;
        else if ( nPointSize < S_MIN_FONT_SIZE ) nPointSize = S_MIN_FONT_SIZE;
        //if ( ! M_font_team_name->CreatePointFont(nPointSize, _T("Times New Roman"), pDC) )
        if ( ! M_font_team_name->CreatePointFont(nPointSize, _T("MS UI Gothic"), pDC) )
        {
            M_font_team_name->CreateStockObject(SYSTEM_FONT);
        }

        nPointSize *= 2;
        if ( ! M_font_score->CreatePointFont(nPointSize, _T("MS UI Gothic"), pDC) ) // "System"
        {
            M_font_score->CreateStockObject(SYSTEM_FONT);
        }

        nPointSize = 10 * BASE_FONT_SIZE;
        if ( nPointSize > S_MAX_FONT_SIZE ) nPointSize = S_MAX_FONT_SIZE;
        else if ( nPointSize < S_MIN_FONT_SIZE ) nPointSize = S_MIN_FONT_SIZE;
        //if ( ! M_font_time->CreatePointFont(nPointSize, _T("Times New Roman"), pDC) )
        if ( ! M_font_time->CreatePointFont(nPointSize, _T("MS UI Gothic"), pDC) )
        {
            M_font_time->CreateStockObject(SYSTEM_FONT);
        }

        nPointSize = 7 * BASE_FONT_SIZE;
        if ( nPointSize > S_MAX_PLAYER_FONT_SIZE ) nPointSize = S_MAX_PLAYER_FONT_SIZE;
        else if ( nPointSize < S_MIN_PLAYER_FONT_SIZE ) nPointSize = S_MIN_PLAYER_FONT_SIZE;
        if ( ! M_font_player->CreatePointFont(nPointSize, _T("Times New Roman"), pDC) )
        {
            M_font_player->CreateStockObject(SYSTEM_FONT);
        }
        
        //oldTextColor = pDC->SetTextColor(M_color_goal);
        //oldBkColor = pDC->SetBkColor(M_color_left_team);

        /*
        if ( m_bViewPositions )
        {
            posString.Format("T%d ", m_pInfo->time);
        }
        */
        CFont* oldFont = pDC->SelectObject(M_font_player);

        ///////////////////////////////////////////
        // draw players
        if ( M_view_players )
        {
            DrawPlayers(pDC);
        }
        
        ///////////////////////////////////////////
        // draw ball
        if ( M_view_ball )
        {
            DrawBall(pDC);
        }

        ///////////////////////////////////////////
        // draw locus
        if ( M_ball_trace_start_cycle >= 0 )
        {
            m_pLogPlayer->drawBallLocus(pDC, M_ball_trace_start_cycle,
                                        M_field_center_x, M_field_center_y,
                                        M_reverse_x);
        }
        if ( M_player_trace_start_cycle >= 0
             && M_selected_player > 0 )
        {
            m_pLogPlayer->drawPlayerLocus(pDC, M_player_trace_start_cycle,
                                          M_selected_player,
                                          M_field_center_x, M_field_center_y,
                                          M_reverse_x);
        }

#ifdef DRAW_SOM
        pDC->MoveTo(M_field_center_x + scale(M_som.cells().back().x()),
                    M_field_center_y + scale(M_som.cells().back().y()));
        std::vector<SomCell>::const_iterator cell_end(M_som.cells().end());
        for ( std::vector<SomCell>::const_iterator it = M_som.cells().begin();
              it != cell_end;
              ++it )
        {
            int point_x = M_field_center_x + scale(it->x());
            int point_y = M_field_center_y + scale(it->y());
            pDC->Arc(point_x - 2, point_y - 2,
                     point_x + 2, point_y + 2,
                     0, 0, 0, 0);
            pDC->LineTo(point_x, point_y);
        }
        M_som.incTrainCount();
#endif

        //////////////////////////
        /*
        if ( m_bViewPositions && m_pMsgView )
        {
            m_pMsgView->ShowString(m_pInfo->time, posString, FALSE);
        }
        */        

        // draw team info, playmode and game cycle
        DrawGameInfo(pDC);

        // delete the fonts
        M_font_team_name->DeleteObject();
        M_font_score->DeleteObject();
        M_font_time->DeleteObject();
        M_font_player->DeleteObject();
        pDC->SelectObject(oldFont);
    }
    
    // select the old gdi objects
    //pDC->SetTextColor(oldTextColor);
    //pDC->SetBkColor(oldBkColor);
    pDC->SelectObject(oldBrush);
    pDC->SelectObject(oldPen);

    pDC->SetBkMode(OPAQUE);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::doDragZoom()
{
    if ( abs((int)M_drag_start_pos.x - (int)M_drag_end_pos.x) < 15
         || abs((int)M_drag_start_pos.y - (int)M_drag_end_pos.y) < 15 )
    {
        return;
    }
    
    double x1 = (double)((int)M_drag_start_pos.x - M_field_center_x) / M_field_scale;
    double y1 = (double)((int)M_drag_start_pos.y - M_field_center_y) / M_field_scale;
    double x2 = (double)((int)M_drag_end_pos.x - M_field_center_x) / M_field_scale;
    double y2 = (double)((int)M_drag_end_pos.y - M_field_center_y) / M_field_scale;
    
    M_zoomed = true;

    M_focus_point_x = (x1 + x2) / 2.0;
    M_focus_point_y = (y1 + y2) / 2.0;

    if ( M_focus_point_x > 57.5 ) M_focus_point_x = 57.5;
    if ( M_focus_point_x < -57.5 ) M_focus_point_x = -57.5;
    if ( M_focus_point_y > 39.0 ) M_focus_point_x = 39.0;
    if ( M_focus_point_y < -39.0 ) M_focus_point_x = -39.0;

    M_field_scale = (double)m_iSizeX / fabs(x1 - x2);
    if ( fabs(y1 - y2) * M_field_scale > (double)m_iSizeY )
    {
        M_field_scale = (double)m_iSizeY / fabs(y1 - y2);
    }

    if ( M_field_scale > S_MAX_FIELD_SCALE )
    {
        M_field_scale = S_MAX_FIELD_SCALE;
    }
    if ( M_field_scale < S_MIN_FIELD_SCALE )
    {
        M_field_scale = S_MIN_FIELD_SCALE;
    }

    OnDragZoom();
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::resetPlayerStateDialog()
{
    if ( M_status_dlg_ptr )
    {
        M_status_dlg_ptr->reset();
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::resetPlayerTypeDialog()
{
    if ( M_player_type_dlg_ptr )
    {
        M_player_type_dlg_ptr->reset();
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::selectPlayerType()
{
    if ( M_player_type_dlg_ptr && M_selected_player > 0 )
    {
        int type = (int)m_pInfo->pos[M_selected_player - 1].type;
        M_player_type_dlg_ptr->update(m_pLogPlayer->playerType(type));
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::selectPlayerType(const int id)
{
    getPlayerTypeDialog();
    if ( M_player_type_dlg_ptr )
    {
        if ( id < 0 || 7 < id )
        {
            return;
        }
        if ( ! M_player_type_dlg_ptr->IsWindowVisible() )
        {
            M_player_type_dlg_ptr->ShowWindow(SW_SHOW);
            m_pView->SetFocus();
        }
        M_player_type_dlg_ptr->update(m_pLogPlayer->playerType(id));
        //M_player_type_dlg_ptr->UpdateData(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::selectPlayer(const int idx)
{
    if ( 0 <= idx && idx < 23
        && M_selected_player != idx )
    {
        M_player_auto_select = false;
        CMainFrame *pFrame = (CMainFrame*)AfxGetApp()->m_pMainWnd;
        if ( pFrame )
        {
           pFrame->updateSelectPlayerComboBox(idx);
        }
        M_selected_player = idx;
        selectPlayerType();
        if ( ! m_pLogPlayer->isRunning() )
        {
            RedrawDoc();
        }
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::ConnectionTimeout()
{
    // if this message is a little bit late processed
    if ( M_connected )
    {
        return;
    }
    TRACE0("connection time out");
    // close the socket
    DeleteSocket();
    m_pInfo = NULL;
    m_bTryingToConnect = FALSE;
    m_bHadConnectionError = TRUE;
    AfxMessageBox("Could not connect to server !\nTimeout");
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::SetCycle(int pos)
{
    m_pLogPlayer->setCurrentCycle(pos);
}

void CSoccermonitorDoc::setGameCycle(const int cyc)
{
    m_pLogPlayer->setGameCycle(cyc);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnConnectTo() 
{
    // this is that the address is asked for
    m_bHadConnectionError = TRUE;
    OnConnect();
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnConnect() 
{
    CSetupDlg Dialog;
    
    if ( M_connected )
    {
        return;
    }
    
    // delete the current doc
    if ( IsModified() )
    {
        if ( ! SaveModified() )
        {
            return;
        }
    }
    
    OnNewDocument();
    
    // ask the user for the name of the team and the server
    Dialog.m_strServer = M_server_host;
    Dialog.m_nChannel = M_monitor_port;
    Dialog.m_nTimeout = m_pView->getConnectTimeout();
    Dialog.M_protocol_version = m_pLogPlayer->protocolVersion();
    
    // create the socket and connect it
    m_pSocket = new CAgentSocket(this);
    // user can repeat with a different address
    while ( TRUE )
    {
        // ask for different address
        if ( m_bHadConnectionError )
        {
            if ( Dialog.DoModal() != IDOK )
            {
                // the user aborted
                delete m_pSocket;
                m_pSocket = NULL;
                return;
            }	
            
            M_server_host = Dialog.m_strServer;
            M_monitor_port = Dialog.m_nChannel;
            m_pView->setConnectTimeout(Dialog.m_nTimeout);
            m_pLogPlayer->setProtocolVersion(Dialog.M_protocol_version);
        }
        
        if ( m_pSocket->ConnectSocket(M_server_host, M_monitor_port) )
        {
            // connect as monitor
            CString initcom;
            initcom.Format("(dispinit version %d)", m_pLogPlayer->protocolVersion());
            m_pSocket->SendMsg(initcom);
            m_bTryingToConnect = TRUE;
            m_pView->startConnectTimer();
            TRACE0("start connect timer\n");

            // init the log file
            m_pLogPlayer->InitLog();
            return;
        }
        
        m_bHadConnectionError = TRUE;
    }
}

void CSoccermonitorDoc::OnUpdateConnect(CCmdUI* pCmdUI) 
{
    if ( M_connected || m_bTryingToConnect )
    {
        pCmdUI->Enable(FALSE);
    }
    else
    {
        pCmdUI->Enable(TRUE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnDisconnect() 
{
    // if this message is a little bit late processed
    if ( ! M_connected )
    {
        return;
    }
    TRACE0("on disconnect\n");
    // close the socket
    DeleteSocket();
    if ( m_pMsgView != NULL )
    {
        m_pMsgView->ClearAll();
    }

    m_bTryingToConnect = FALSE;
    M_connected = false;
    m_bStarted = FALSE;
    m_pInfo = NULL;

    if ( m_pView != NULL )
    {
        m_pLogPlayer->rewind();
    }
    if ( M_coach_connected && M_coach_ptr != NULL )
    {
        delete M_coach_ptr;
    }
    if ( M_coach_view_ptr != NULL )
    {
        M_coach_view_ptr->ClearAll();
    }
    M_coach_connected = false;
}

void CSoccermonitorDoc::OnUpdateDisconnect(CCmdUI* pCmdUI) 
{
    if ( M_connected )
    {
        pCmdUI->Enable(TRUE);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnKickOff() 
{
    // send the kickoff comand
    m_pSocket->SendMsg(_T("(dispstart)"));
    SetStarted(TRUE);
}

void CSoccermonitorDoc::OnUpdateKickOff(CCmdUI* pCmdUI) 
{
    // disable kickoff button once pressed
    if ( m_bStarted || ! M_connected )
    {
        pCmdUI->Enable(FALSE);
    }
    else
    {
        pCmdUI->Enable(TRUE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewRefereeMsg() 
{
    m_bViewReferee = ! m_bViewReferee;
}

void CSoccermonitorDoc::OnUpdateViewRefereeMsg(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck(m_bViewReferee ? 1 : 0);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewNumbers() 
{
    M_view_numbers = ! M_view_numbers;
    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdateViewNumbers(CCmdUI* pCmdUI) 
{
    if ( M_view_numbers )
    {
        pCmdUI->SetCheck(1);
    }
    else
    {
        pCmdUI->SetCheck(0);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnChangeColor() 
{
    ColorSettingDialog cdlg(m_pView);

    cdlg.setScoreFont(M_color_score);

    cdlg.setFieldLight(M_color_field);
    cdlg.setFieldDark(M_color_field_dark);
    cdlg.setLines(M_color_lines);
    cdlg.setFlag(M_color_flag);
    cdlg.setGoal(M_color_goal);
    cdlg.setGoalPost(M_color_goalpost);
    cdlg.setOffsideLine(M_color_offside_line);
    cdlg.setVoronoiDiagram(M_color_voronoi_diagram);

    cdlg.setBall(M_color_ball);

    cdlg.setLeftTeam(M_color_left_team);
    cdlg.setLeftGoalie(M_color_left_goalie);
    cdlg.setRightTeam(M_color_right_team);
    cdlg.setRightGoalie(M_color_right_goalie);

    cdlg.setPlayerFont1(M_color_player_font1);
    cdlg.setPlayerFont2(M_color_player_font2);

    cdlg.setBodyDir(M_color_body_dir);
    cdlg.setViewCone(M_color_view_cone);
    cdlg.setViewArea(M_color_view_area);
    cdlg.setControlArea(M_color_control_area);

    cdlg.setKickFault(M_color_kick_fault);
    cdlg.setCatch(M_color_goalie_catch);
    cdlg.setCatchFault(M_color_goalie_catch_fault);
    cdlg.setTackle(M_color_tackle);
    cdlg.setTackleFault(M_color_tackle_fault);
    cdlg.setBallCollide(M_color_ball_collide);
    cdlg.setPlayerCollide(M_color_player_collide);

    cdlg.setPlayerEdge(M_color_player_edge);
    cdlg.setEffortDec(M_color_effort_tired);
    cdlg.setRecoveryDec(M_color_recovery_tired);

    cdlg.setKickEdge(M_color_kick_edge);

    if ( cdlg.DoModal() != IDOK )
    {
        return;
    }

    M_color_save = cdlg.M_save_to_ini ? true : false;

    M_color_score = cdlg.getScoreFont();

    M_color_field = cdlg.getFieldLight();
    M_color_field_dark = cdlg.getFieldDark();
    
    M_color_lines = cdlg.getLines();
    M_color_flag = cdlg.getFlag();
    M_color_goal = cdlg.getGoal();
    M_color_goalpost = cdlg.getGoalPost();

    M_color_offside_line = cdlg.getOffsideLine();
    M_color_voronoi_diagram = cdlg.getVoronoiDiagram();

    M_color_ball = cdlg.getBall();

    M_color_left_team = cdlg.getLeftTeam();
    M_color_left_goalie = cdlg.getLeftGoalie();
    M_color_right_team = cdlg.getRightTeam();
    M_color_right_goalie = cdlg.getRightGoalie();

    M_color_player_font1 = cdlg.getPlayerFont1();
    M_color_player_font2 = cdlg.getPlayerFont2();

    M_color_body_dir = cdlg.getBodyDir();
    M_color_view_cone = cdlg.getViewCone();
    M_color_view_area = cdlg.getViewArea();
    M_color_control_area = cdlg.getControlArea();

    M_color_kick_fault = cdlg.getKickFault();
    M_color_goalie_catch = cdlg.getCatch();
    M_color_goalie_catch_fault = cdlg.getCatchFault();
    M_color_tackle = cdlg.getTackle();
    M_color_tackle_fault = cdlg.getTackleFault();
    M_color_ball_collide = cdlg.getBallCollide();
    M_color_player_collide = cdlg.getPlayerCollide();

    M_color_player_edge = cdlg.getPlayerEdge();
    M_color_effort_tired = cdlg.getEffortDec();
    M_color_recovery_tired = cdlg.getRecoveryDec();

    M_color_kick_edge = cdlg.getKickEdge();

    deleteGdiObject();
    createGdiObject();

    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}


void CSoccermonitorDoc::OnUpdateChangeColor(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    if ( M_connected || m_pLogPlayer->isRunning() )
    {
        pCmdUI->Enable(FALSE);
    }
    else
    {
        pCmdUI->Enable(TRUE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnLogRewind() 
{
    m_pLogPlayer->stop();
    m_pLogPlayer->rewind();
}


void CSoccermonitorDoc::OnUpdateLogRewind(CCmdUI* pCmdUI) 
{
    if ( ! M_connected && m_pLogPlayer->hasData() )
    {
        pCmdUI->Enable(TRUE);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnLogGotoEnd() 
{
    m_pLogPlayer->stop();
    m_pLogPlayer->end();
}

void CSoccermonitorDoc::OnUpdateLogGotoEnd(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    if ( ! M_connected && m_pLogPlayer->hasData() )
    {
        pCmdUI->Enable(TRUE);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnLogStart() 
{
    m_pLogPlayer->stop();
    m_pLogPlayer->start();
}

void CSoccermonitorDoc::OnUpdateLogStart(CCmdUI* pCmdUI) 
{
    if ( ! M_connected && m_pLogPlayer->hasData() )
    {
        if ( m_pLogPlayer->isRunning() && m_pLogPlayer->isForward() )
        {
            pCmdUI->Enable(FALSE);
            pCmdUI->SetCheck(TRUE);
        }
        else
        {
            pCmdUI->Enable(TRUE);
            pCmdUI->SetCheck(FALSE);
        }
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnLogBackplay() 
{
    m_pLogPlayer->stop();
    m_pLogPlayer->start(false);
}

void CSoccermonitorDoc::OnUpdateLogBackplay(CCmdUI* pCmdUI) 
{
    if ( ! M_connected && m_pLogPlayer->hasData() )
    {
        if ( m_pLogPlayer->isRunning() && ! m_pLogPlayer->isForward() )
        {
            pCmdUI->Enable(FALSE);
            pCmdUI->SetCheck(TRUE);
        }
        else
        {
            pCmdUI->SetCheck(FALSE);
            pCmdUI->Enable(TRUE);
        }
    }
    else
        pCmdUI->Enable(FALSE);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnLogStop() 
{
    m_pLogPlayer->stop();
}

void CSoccermonitorDoc::OnUpdateLogStep(CCmdUI* pCmdUI) 
{
    if ( ! M_connected && m_pLogPlayer->hasData() )
    {
        pCmdUI->Enable(TRUE);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnLogAccelerate() 
{
    m_pLogPlayer->accelerate();
}

void CSoccermonitorDoc::OnUpdateLogAccelerate(CCmdUI* pCmdUI) 
{
    if ( ! M_connected && m_pLogPlayer->isRunning() )
        pCmdUI->Enable(TRUE);
    else
        pCmdUI->Enable(FALSE);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnLogDecelerate() 
{
    m_pLogPlayer->decelerate();
}

void CSoccermonitorDoc::OnUpdateLogDecelerate(CCmdUI* pCmdUI) 
{
    if ( ! M_connected && m_pLogPlayer->isRunning() )
        pCmdUI->Enable(TRUE);
    else
        pCmdUI->Enable(FALSE);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnLogStepBack() 
{
    m_pLogPlayer->stepBack();
}

void CSoccermonitorDoc::OnUpdateLogStepBack(CCmdUI* pCmdUI) 
{
    if ( ! M_connected && m_pLogPlayer->hasData() )
    {
        pCmdUI->Enable(TRUE);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnLogStep() 
{
    m_pLogPlayer->step();
}

void CSoccermonitorDoc::OnUpdateLogStop(CCmdUI* pCmdUI) 
{
    if ( ! M_connected && m_pLogPlayer->isRunning() )
        pCmdUI->Enable(TRUE);
    else
        pCmdUI->Enable(FALSE);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnLogGoto() 
{
    m_pLogPlayer->stop();
    m_pLogPlayer->jump();
    //m_pMsgView->ClearAll();
}

void CSoccermonitorDoc::OnUpdateLogGoto(CCmdUI* pCmdUI) 
{
    if ( ! M_connected && m_pLogPlayer->hasData() )
    {
        pCmdUI->Enable(TRUE);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnLogGotoNextScore() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	m_pLogPlayer->jumpToNextScore();
}

void CSoccermonitorDoc::OnUpdateLogGotoNextScore(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    if ( ! M_connected
         && m_pLogPlayer->hasData()
         && m_pLogPlayer->hasNextScore() )
    {
        pCmdUI->Enable(TRUE);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnLogGotoPassScene() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	
}

void CSoccermonitorDoc::OnUpdateLogGotoPassScene(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	pCmdUI->Enable(FALSE);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnLogGotoInterceptScene() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	
}

void CSoccermonitorDoc::OnUpdateLogGotoInterceptScene(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	pCmdUI->Enable(FALSE);
}


void CSoccermonitorDoc::OnUpdateFileOpen(CCmdUI* pCmdUI) 
{
    if ( ! M_connected )
        pCmdUI->Enable(TRUE);
    else
        pCmdUI->Enable(FALSE);
}

void CSoccermonitorDoc::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
    if ( ! M_connected && m_pLogPlayer->hasData() )
        pCmdUI->Enable(TRUE);
    else
        pCmdUI->Enable(FALSE);
}

void CSoccermonitorDoc::OnUpdateFileSaveAs(CCmdUI* pCmdUI) 
{
    if ( ! M_connected && m_pLogPlayer->hasData() )
        pCmdUI->Enable(TRUE);
    else
        pCmdUI->Enable(FALSE);
}









BOOL CSoccermonitorDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
    OnNewDocument();
    
    if ( ! CDocument::OnOpenDocument(lpszPathName) )
    {
        return FALSE;
    }
    else
    {
        return TRUE;
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnFoulLeft() 
{
    // called from the context menu
    CString	message;
    Vector2D coords = getFoulCoordinate();
    
    message.Format("(dispfoul %d %d 1)",
                   (int)(coords.x * SHOWINFO_SCALE),
                   (int)(coords.y * SHOWINFO_SCALE));
    m_pSocket->SendMsg(message);	
}

void CSoccermonitorDoc::OnUpdateFoulLeft(CCmdUI* pCmdUI) 
{
    // disable foul menu if not connected
    pCmdUI->Enable(M_connected ? TRUE : FALSE);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnFoulRight() 
{
    // called from the context menu
    CString	message;
    Vector2D coords = getFoulCoordinate();
    
    message.Format("(dispfoul %d %d -1)",
                   (int)(coords.x * SHOWINFO_SCALE),
                   (int)(coords.y * SHOWINFO_SCALE));
    m_pSocket->SendMsg(message);
}

void CSoccermonitorDoc::OnUpdateFoulRight(CCmdUI* pCmdUI) 
{
    // disable foul menu if not connected
    pCmdUI->Enable(M_connected ? TRUE : FALSE);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnFoulDropBall() 
{
    // called from the context menu
    CString	message;
    Vector2D coords = getFoulCoordinate();

    message.Format("(dispfoul %d %d 0)",
                   (int)(coords.x * SHOWINFO_SCALE),
                   (int)(coords.y * SHOWINFO_SCALE));
    m_pSocket->SendMsg(message);
}


void CSoccermonitorDoc::OnUpdateFoulDropBall(CCmdUI* pCmdUI) 
{
    // disable foul menu if not connected
    pCmdUI->Enable(M_connected ? TRUE : FALSE);
}

//////////////////////////////////////////////////////////////////
Vector2D
CSoccermonitorDoc::getFoulCoordinate()
{
    Vector2D coords = convertPoint(m_pView->getRefereeFoulPoint());

    // the multiplication with SHOWINFO_SCALE is necessary, because the 
    // dispfoul does not take field coordinates, but
    // divides through SHOWINFO_SCALE
    if ( coords.x < -PITCH_LENGTH / 2.0 )
    {
        coords.x = -PITCH_LENGTH / 2.0;
    }
    else if ( coords.x > PITCH_LENGTH / 2.0)
    {
        coords.x = PITCH_LENGTH / 2.0;
    }
    
    if ( coords.y < -PITCH_WIDTH / 2.0 )
    {
        coords.y = -PITCH_WIDTH / 2.0;
    }
    else if ( coords.y > PITCH_WIDTH / 2.0 )
    {
        coords.y = PITCH_WIDTH / 2.0;
    }
    
    if ( M_reverse_x )
    {
        coords.x *= -1.0;
        coords.y *= -1.0;
    }

    return coords;
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewEnlargePlayers() 
{
    M_enlarged = ! M_enlarged;
    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdateViewEnlargePlayers(CCmdUI* pCmdUI) 
{
    if ( M_enlarged )
    {
        pCmdUI->SetCheck(1);
    }
    else
    {
        pCmdUI->SetCheck(0);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewKickableMargin() 
{
    M_view_control_area = ! M_view_control_area;
    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdateViewKickableMargin(CCmdUI* pCmdUI) 
{
    if ( M_view_control_area )
    {
        pCmdUI->SetCheck(1);
    }
    else
    {
        pCmdUI->SetCheck(0);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::TestSocket()
{
    // for testing the socket, all messages are received
    if ( m_pSocket != NULL )
    {
        m_pSocket->ReceiveMsg();
    }
}

//////////////////////////////////////////////////////////////////
BOOL CSoccermonitorDoc::SaveModified() 
{
    // TODO: Add your specialized code here and/or call the base class
    SetModifiedFlag(FALSE);
    return CDocument::SaveModified();
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::DisplayMessage(LPCTSTR msg){
    
    if ( M_coach_view_ptr != NULL )
    {
        M_coach_view_ptr->DisplayMessage(msg);
    }
} 

//////////////////////////////////////////////////////////////////
Vector2D
CSoccermonitorDoc::convertPoint(const CPoint &point)
{
    return Vector2D((double)((int)point.x - M_field_center_x) / M_field_scale,
                    (double)((int)point.y - M_field_center_y) / M_field_scale);
} 

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::Drawcurpos(CDC* pdc)
{    
    if ( M_l_clicked )
    {
        if ( M_view_measure )
        {
            CString str;
            double x = (double)((int)M_drag_start_pos.x - M_field_center_x) / M_field_scale;
            double y = (double)((int)M_drag_start_pos.y - M_field_center_y) / M_field_scale;

            pdc->SelectObject(M_pen_click_point);
            int radius1 = 2;
            pdc->Arc(M_drag_start_pos.x - radius1, M_drag_start_pos.y - radius1,
                     M_drag_start_pos.x + radius1, M_drag_start_pos.y + radius1,
                     0, 0, 0, 0);

            str.Format("(%4.2f,%4.2f)", x, y);
            pdc->SetBkMode(TRANSPARENT);
            pdc->SetTextColor(COLOR_YELLOW);
            pdc->TextOut(M_drag_start_pos.x, M_drag_start_pos.y - 15,
                         str, str.GetLength());

            if ( M_drag_start_pos != M_drag_end_pos )
            {
                CPen* oldPen = pdc->SelectObject(M_pen_drag_line);
                pdc->MoveTo(M_drag_start_pos);
                pdc->LineTo(M_drag_end_pos);

                pdc->SelectObject(M_pen_click_point);
                int radius1 = 2;
                pdc->Arc(M_drag_end_pos.x - radius1, M_drag_end_pos.y - radius1,
                         M_drag_end_pos.x + radius1, M_drag_end_pos.y + radius1,
                         0, 0, 0, 0);

                pdc->SetBkMode(TRANSPARENT);
        
                double x2 = (double)((int)M_drag_end_pos.x - M_field_center_x) / M_field_scale;
                double y2 = (double)((int)M_drag_end_pos.y - M_field_center_y) / M_field_scale;

                double relx = x2 - x, rely = y2 - y;

                str.Format("(%.2f,%.2f)", x2, y2);
                pdc->SetTextColor(COLOR_YELLOW);
                pdc->TextOut(M_drag_end_pos.x, M_drag_end_pos.y - 15,
                             str, str.GetLength());
        
                str.Format("rel(%.2f %.2f) r%.2f th%.0f",
                           relx, rely,
                           sqrt(relx * relx + rely * rely),
                           atan2(rely, relx) * 180 / PI);
                pdc->SetTextColor(COLOR_WVIOLET);
                pdc->TextOut(M_drag_end_pos.x , M_drag_end_pos.y + 15,
                             str, str.GetLength());			

                pdc->SelectObject(oldPen);
            }
        }
        else if ( M_drag_zoom )
        {
            if ( M_drag_start_pos != M_drag_end_pos )
            {
                CPen* oldPen = pdc->SelectObject(M_pen_drag_line);
                pdc->MoveTo(M_drag_start_pos);
                pdc->LineTo((int)M_drag_start_pos.x, (int)M_drag_end_pos.y);
                pdc->LineTo((int)M_drag_end_pos.x, (int)M_drag_end_pos.y);
                pdc->LineTo((int)M_drag_end_pos.x, (int)M_drag_start_pos.y);
                pdc->LineTo(M_drag_start_pos);
                pdc->SelectObject(oldPen);
            }
        }
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::DrawField(CDC *pDC)
{
    // draw the lines
    pDC->SelectObject(M_pen_line);

    // fill background
    pDC->FillSolidRect(0, 0, m_iSizeX, m_iSizeY, M_color_field);//COLOR_PINK);

    // outline
    int left_x = M_field_center_x - scale(PITCH_LENGTH/2);
    int top_y = M_field_center_y - scale(PITCH_WIDTH/2);
    int right_x = M_field_center_x + scale(PITCH_LENGTH/2);
    int bottom_y = M_field_center_y + scale(PITCH_WIDTH/2);
    // draw pitch area
    if ( M_field_grass_type == GRASS_CHECKER )
    {
        //pDC->FillSolidRect(left_x, top_y, right_x - left_x, bottom_y - top_y,
        //                   M_color_field);//COLOR_FIELD);

        int inc = scale(10.0); // grid width
        int i, j;
        int flag = 0;
        for ( i = M_field_center_x; i > left_x; i -= inc )
        {
            int cnt = flag;
            int left = i - inc;
            //if ( left < left_x ) left = left_x;
            for ( j = M_field_center_y; j > top_y; j -= inc )
            {
                if ( cnt % 2 )
                {
                    int top = j - inc;
                    //if ( top < top_y ) top = top_y;
                    pDC->FillSolidRect(left, top, i - left, j - top, M_color_field_dark);
                }
                cnt++;
            }
            flag++;
        }
        flag = 1;
        for ( i = M_field_center_x;  i > left_x; i -= inc )
        {
            int cnt = flag;
            int left = i - inc;
            //if ( left < left_x ) left = left_x;
            for ( j = M_field_center_y; j < bottom_y; j += inc )
            {
                if ( cnt % 2 )
                {
                    int bottom = j + inc;
                    //if ( bottom > bottom_y ) bottom = bottom_y;
                    pDC->FillSolidRect(left, j, i - left, bottom - j, M_color_field_dark);
                }
                cnt++;
            }
            flag++;
        }
        flag = 0;
        for ( i = M_field_center_x;  i < right_x; i += inc )
        {
            int cnt = flag;
            int right = i + inc;
            //if ( right > right_x ) right = right_x;
            for ( j = M_field_center_y; j < bottom_y; j += inc )
            {
                if ( cnt % 2 )
                {
                    int bottom = j + inc;
                    //if ( bottom > bottom_y ) bottom = bottom_y;
                    pDC->FillSolidRect(i, j, right - i, bottom - j, M_color_field_dark);
                }
                cnt++;
            }
            flag++;
        }

        flag = 1;
        for ( i = M_field_center_x;  i < right_x; i += inc )
        {
            int cnt = flag;
            int right = i + inc;
            //if ( right > right_x ) right = right_x;
            for ( j = M_field_center_y; j > top_y; j -= inc )
            {
                if ( cnt % 2 )
                {
                    int top = j - inc;
                    //if ( top < top_y ) top = top_y;
                    pDC->FillSolidRect(i, top, right - i, j - top, M_color_field_dark);
                }
                cnt++;
            }
            flag++;
        }
    }
    else if ( M_field_grass_type == GRASS_LINES )
    {
        //pDC->FillSolidRect(left_x, top_y, right_x - left_x, bottom_y - top_y,
        //                   M_color_field);//COLOR_FIELD);

        int inc = scale(10.0); // grid width
        int i = M_field_center_x - inc/2;
        int cnt = 0;
        while ( i > left_x )
        {
            //if ( cnt % 2))
            if ( ! (cnt % 2) )
            {
                int left = i - inc;
                //if ( left < left_x ) left = left_x;
                pDC->FillSolidRect(left, top_y - inc/2, i - left, bottom_y - top_y + inc,
                                   M_color_field_dark);
            }
            i -= inc;
            cnt++;
        }
        i = M_field_center_x + inc/2;
        cnt = 0;
        while ( i < right_x )
        {
            if ( ! (cnt % 2) )
            {
                int right = i + inc;
                //if ( right > right_x ) right = right_x;
                pDC->FillSolidRect(i, top_y - inc/2, right - i, bottom_y - top_y + inc,
                                   M_color_field_dark);
            }
            i += inc;
            cnt++;
        }
    }
    else
    {

        //pDC->FillSolidRect(left_x, top_y, right_x - left_x, bottom_y - top_y,
        //                   M_color_field);//COLOR_FIELD);
        //pDC->SelectObject(M_brush_field);
        //pDC->Rectangle(left_x, top_y, right_x, bottom_y);
    }


    // draw field line
    pDC->MoveTo(left_x, top_y);
    pDC->LineTo(right_x, top_y);
    pDC->LineTo(right_x, bottom_y);
    pDC->LineTo(left_x, bottom_y);
    pDC->LineTo(left_x, top_y);

    // midline and circle
    if ( M_field_grass_type == GRASS_KEEPAWAY )
    {
        int ka_length = scale(m_pLogPlayer->serverParam().ka_length);
        int ka_width = scale(m_pLogPlayer->serverParam().ka_width);
        int ka_left = M_field_center_x - ka_length/2;
        int ka_top = M_field_center_y - ka_width/2;
        pDC->MoveTo(ka_left, ka_top);
        pDC->LineTo(ka_left, ka_top + ka_width);
        pDC->LineTo(ka_left + ka_length, ka_top + ka_width);
        pDC->LineTo(ka_left + ka_length, ka_top);
        pDC->LineTo(ka_left, ka_top);
    }
    else
    {
        int center_radius = scale(CENTER_CIRCLE_R);
        pDC->Arc(M_field_center_x - center_radius, M_field_center_y - center_radius,
                 M_field_center_x + center_radius, M_field_center_y + center_radius,
                 M_field_center_x, M_field_center_y - center_radius,
                 M_field_center_x, M_field_center_y - center_radius);
        pDC->MoveTo(M_field_center_x, top_y);
        pDC->LineTo(M_field_center_x, bottom_y);
    }

    // penalty area
    int pen_top_y = M_field_center_y - scale(PENALTY_AREA_WIDTH/2);
    int pen_bottom_y = M_field_center_y + scale(PENALTY_AREA_WIDTH/2);
    int pen_circle_top_y = M_field_center_y - scale(CIRCLE_ARC);
    int pen_circle_bottom_y = M_field_center_y + scale(CIRCLE_ARC);

    // left
    int pen_x = M_field_center_x - scale(PITCH_LENGTH/2 - PENALTY_AREA_LENGTH);
    // circle
    int pen_spot_x = M_field_center_x - scale(PITCH_LENGTH/2 - PENALTY_SPOT_DIST);
    int pen_radius = scale(PENALTY_CIRCLE_R);
    pDC->Arc(pen_spot_x - pen_radius, M_field_center_y - pen_radius,
             pen_spot_x + pen_radius, M_field_center_y + pen_radius,
             pen_x, pen_circle_bottom_y, pen_x, pen_circle_top_y);	
    // rectangle
    pDC->MoveTo(left_x, pen_top_y);
    pDC->LineTo(pen_x, pen_top_y);
    pDC->LineTo(pen_x, pen_bottom_y);
    pDC->LineTo(left_x, pen_bottom_y);
    // point
    pDC->MoveTo(pen_spot_x, M_field_center_y - 1);
    pDC->LineTo(pen_spot_x, M_field_center_y + 1);
    
    // right
    // pen circle
    pen_x = M_field_center_x + scale(PITCH_LENGTH/2 - PENALTY_AREA_LENGTH);
    pen_spot_x = M_field_center_x + scale(PITCH_LENGTH/2 - PENALTY_SPOT_DIST);
    pDC->Arc(pen_spot_x - pen_radius, M_field_center_y - pen_radius,
            pen_spot_x + pen_radius, M_field_center_y + pen_radius,
            pen_x, pen_circle_top_y, pen_x, pen_circle_bottom_y);
    // pen rectangle
    pDC->MoveTo(right_x, pen_top_y);
    pDC->LineTo(pen_x, pen_top_y);
    pDC->LineTo(pen_x, pen_bottom_y);
    pDC->LineTo(right_x, pen_bottom_y);
    // pen points
    pDC->MoveTo(pen_spot_x, M_field_center_y - 1);
    pDC->LineTo(pen_spot_x, M_field_center_y + 1);
    
    // goal area
    int goal_area_top_y = M_field_center_y - scale(GOAL_AREA_WIDTH/2);
    int goal_area_bottom_y = M_field_center_y + scale(GOAL_AREA_WIDTH/2);
    // left
    int goal_area_x = M_field_center_x - scale(PITCH_LENGTH/2 - GOAL_AREA_LENGTH);
    pDC->MoveTo(left_x, goal_area_top_y);
    pDC->LineTo(goal_area_x, goal_area_top_y);
    pDC->LineTo(goal_area_x, goal_area_bottom_y);
    pDC->LineTo(left_x, goal_area_bottom_y);
    // right
    goal_area_x = M_field_center_x + scale(PITCH_LENGTH/2 - GOAL_AREA_LENGTH);
    pDC->MoveTo(right_x, goal_area_top_y);
    pDC->LineTo(goal_area_x, goal_area_top_y);
    pDC->LineTo(goal_area_x, goal_area_bottom_y);
    pDC->LineTo(right_x, goal_area_bottom_y);
    
    // goals
    int gdepth = scale(GOAL_DEPTH);
    int goal_top_y = M_field_center_y - scale(m_pLogPlayer->serverParam().gwidth/2.0);
    int goal_bottom_y = M_field_center_y + scale(m_pLogPlayer->serverParam().gwidth/2.0);
    // left
    pDC->FillSolidRect(left_x - gdepth, goal_top_y,
                       gdepth, goal_bottom_y - goal_top_y,
                       M_color_goal);
    // right
    pDC->FillSolidRect(right_x, goal_top_y,
                       gdepth, goal_bottom_y - goal_top_y,
                       M_color_goal);

    // goal post
    int post_abs_x = scale(PITCH_LENGTH*0.5 - GOAL_POST_R);
    int post_abs_y = scale(GOAL_WIDTH*0.5 + GOAL_POST_R);
    int post_radius = scale(GOAL_POST_R);
    if ( post_radius < 2 )
    {
        post_radius = 2;
    }
    pDC->SelectObject(M_pen_goal_post);
    pDC->SelectObject(M_brush_goal_post);
    // left
    pDC->Ellipse(M_field_center_x - post_abs_x - post_radius,
                 M_field_center_y - post_abs_y - post_radius,
                 M_field_center_x - post_abs_x + post_radius,
                 M_field_center_y - post_abs_y + post_radius);
    pDC->Ellipse(M_field_center_x - post_abs_x - post_radius,
                 M_field_center_y + post_abs_y - post_radius,
                 M_field_center_x - post_abs_x + post_radius,
                 M_field_center_y + post_abs_y + post_radius);
    // right
    pDC->Ellipse(M_field_center_x + post_abs_x - post_radius,
                 M_field_center_y - post_abs_y - post_radius,
                 M_field_center_x + post_abs_x + post_radius,
                 M_field_center_y - post_abs_y + post_radius);
    pDC->Ellipse(M_field_center_x + post_abs_x - post_radius,
                 M_field_center_y + post_abs_y - post_radius,
                 M_field_center_x + post_abs_x + post_radius,
                 M_field_center_y + post_abs_y + post_radius);
/*
    CString str;
    str.Format("focus (%f %f)", M_focus_point_x, M_focus_point_y);
    pDC->SetBkMode(TRANSPARENT);
    pDC->SetTextColor(COLOR_WHITE);
    pDC->TextOut(40 , 40, str, str.GetLength());
*/
    if ( M_view_flags )
    {
        DrawFlags(pDC);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::DrawFlags(CDC *pDC)
{
    pDC->SelectObject(M_pen_flag);

    int flag_radius = scale(0.5);
    if ( flag_radius < 2 )
    {
        flag_radius = 2;
    }
    if ( flag_radius > 5 )
    {
        flag_radius = 5;
    }

    int x, y;
    int pitch_half_length = scale(PITCH_LENGTH / 2.0);
    int pitch_half_width = scale(PITCH_WIDTH / 2.0);
    int pitch_margin_x = scale(PITCH_LENGTH / 2.0 + 5.0);
    int pitch_margin_y = scale(PITCH_WIDTH / 2.0 + 5.0);
    int penalty_y = scale(PENALTY_AREA_WIDTH / 2.0);
    int penalty_x = scale(PITCH_LENGTH/2 - PENALTY_AREA_LENGTH);
    int goal_y = scale(GOAL_WIDTH / 2.0);
    int scale10 = scale(10.0), scale20 = scale(20.0),
        scale30 = scale(30.0), scale40 = scale(40.0),
        scale50 = scale(50.0);

    // goal left
    x = M_field_center_x - pitch_half_length;
    y = M_field_center_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // goal right
    x = M_field_center_x + pitch_half_length;
    y = M_field_center_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag c
    x = M_field_center_x;
    y = M_field_center_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag c t
    x = M_field_center_x;
    y = M_field_center_y - pitch_half_width;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag c b
    x = M_field_center_x;
    y = M_field_center_y + pitch_half_width;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag l t
    x = M_field_center_x - pitch_half_length;
    y = M_field_center_y - pitch_half_width;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag l b
    x = M_field_center_x - pitch_half_length;
    y = M_field_center_y + pitch_half_width;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag r t
    x = M_field_center_x + pitch_half_length;
    y = M_field_center_y - pitch_half_width;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag r b
    x = M_field_center_x + pitch_half_length;
    y = M_field_center_y + pitch_half_width;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag p l t
    x = M_field_center_x - penalty_x;
    y = M_field_center_y - penalty_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag p l c
    x = M_field_center_x - penalty_x;
    y = M_field_center_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag p l b
    x = M_field_center_x - penalty_x;
    y = M_field_center_y + penalty_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag p r t
    x = M_field_center_x + penalty_x;
    y = M_field_center_y - penalty_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag p r c
    x = M_field_center_x + penalty_x;
    y = M_field_center_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag p r b
    x = M_field_center_x + penalty_x;
    y = M_field_center_y + penalty_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);

    // flag g l t
    x = M_field_center_x - pitch_half_length;
    y = M_field_center_y - goal_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag g l b
    x = M_field_center_x - pitch_half_length;
    y = M_field_center_y + goal_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag g r t
    x = M_field_center_x + pitch_half_length;
    y = M_field_center_y - goal_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag g r b
    x = M_field_center_x + pitch_half_length;
    y = M_field_center_y + goal_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);

    // flag t ...

    y = M_field_center_y - pitch_margin_y;
    // flag t l 50
    x = M_field_center_x - scale50;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag t l 40
    x = M_field_center_x - scale40;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag t l 30
    x = M_field_center_x - scale30;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag t l 20
    x = M_field_center_x - scale20;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag t l 10
    x = M_field_center_x - scale10;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag t 0
    x = M_field_center_x;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag t r 10
    x = M_field_center_x + scale10;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag t r 20
    x = M_field_center_x + scale20;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag t r 30
    x = M_field_center_x + scale30;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag t r 40
    x = M_field_center_x + scale40;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag t r 50
    x = M_field_center_x + scale50;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);

    // flag b ...

    y = M_field_center_y + pitch_margin_y;
    // flag b l 50
    x = M_field_center_x - scale50;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag b l 40
    x = M_field_center_x - scale40;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag b l 30
    x = M_field_center_x - scale30;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag b l 20
    x = M_field_center_x - scale20;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag b l 10
    x = M_field_center_x - scale10;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag b 0
    x = M_field_center_x;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag b r 10
    x = M_field_center_x + scale10;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag b r 20
    x = M_field_center_x + scale20;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag b r 30
    x = M_field_center_x + scale30;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag b r 40
    x = M_field_center_x + scale40;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag b r 50
    x = M_field_center_x + scale50;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);

    // flag l ...

    x = M_field_center_x - pitch_margin_x;
    // flag l t 30
    y = M_field_center_y - scale30;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag l t 20
    y = M_field_center_y - scale20;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag l t 10
    y = M_field_center_y - scale10;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag l 0
    y = M_field_center_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag l b 10
    y = M_field_center_y + scale10;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag l b 20
    y = M_field_center_y + scale20;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag l b 30
    y = M_field_center_y + scale30;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);

    // flag r ...

    x = M_field_center_x + pitch_margin_x;
    // flag r t 30
    y = M_field_center_y - scale30;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag r t 20
    y = M_field_center_y - scale20;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag r t 10
    y = M_field_center_y - scale10;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag r 0
    y = M_field_center_y;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag r b 10
    y = M_field_center_y + scale10;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag r b 20
    y = M_field_center_y + scale20;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
    // flag r b 30
    y = M_field_center_y + scale30;
    pDC->Arc(x - flag_radius, y - flag_radius,
             x + flag_radius, y + flag_radius,
             0, 0, 0, 0);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::DrawGameInfo(CDC *pDC)
{
    static const char* PlayModeString[] = PLAYMODE_STRINGS;
    static int s_playmode_count = 0;
    CString	text;
    CRect rect;

    const int CENTER_X = m_iSizeX / 2;
    const int CENTER_Y = m_iSizeY / 2;
    bool scale_over = false;

    CFont *font_old = pDC->SelectObject(M_font_score);
    pDC->SetBkMode(OPAQUE);

    int x1 = CENTER_X - scale(PITCH_MARGIN + PITCH_LENGTH/2);
    int y1 = 0;
    int x2, y2;
    if ( x1 < 0 )
    {
        scale_over = true;
    }
    if ( ! scale_over )
    {
        x2 = CENTER_X + scale(PITCH_MARGIN + PITCH_LENGTH/2);
    }
    else
    {
        x1 = 0; 
        x2 = m_iSizeX;
    }

    y2 = scale(PITCH_MARGIN * 0.9);
    if ( 40 < y2 )
    {
        y2 = 40;
    }
    else if ( y2 < 20 )
    {
        y2 = 20;
    }

    const double DIVISION = 0.35;

    pDC->FillSolidRect(x1, y1,
                       x2 - x1, y2 - y1, // rectangle size
                       COLOR_WHITE);
    pDC->FillSolidRect(x1, y1,
                       (int)((x2-x1) * DIVISION), y2 - y1, // rectangle size
                       M_color_left_team);
    pDC->FillSolidRect(x1 + (int)((x2-x1) * (1.0 - DIVISION)), y1,
                       (int)((x2-x1) * DIVISION), y2 - y1, // rectangle size
                       M_color_right_team);
    
    // score left
    if ( ! scale_over )
    {
        x2 = CENTER_X - scale(PITCH_LENGTH/2);
    }
    else
    {
        x2 = (int)((double)m_iSizeX * 0.1);
        if ( x2 < 20 ) x2 = 20;
    }
    rect.SetRect(x1, y1, x2, y2);
    
    pDC->SetTextColor(M_color_score);
    pDC->SetBkColor(M_color_left_team);
    
    if ( m_pInfo->team[0].score < 0 )
    {
        m_pInfo->team[0].score = 0;
    }
    text.Format("%2d", m_pInfo->team[0].score);
    pDC->DrawText(text, rect, DT_SINGLELINE | DT_VCENTER | DT_LEFT);
    
    // score right
    if ( ! scale_over )
    {
        x1 = CENTER_X + scale(PITCH_LENGTH/2 - 1.0);
        x2 = CENTER_X + scale(PITCH_LENGTH/2 + PITCH_MARGIN - 1.0);
    }
    else
    {
        x1 = (int)((double)m_iSizeX * 0.9);
        x2 = m_iSizeX - 2;
        if ( x2 - x1 < 20 ) x1 = x2 - 20;
    }
    rect.SetRect(x1, y1, x2, y2);
    
    pDC->SetTextColor(M_color_score);
    pDC->SetBkColor(M_color_right_team);
    if ( m_pInfo->team[1].score < 0 )
    {
        m_pInfo->team[1].score = 0;
    }
    text.Format("%2d", m_pInfo->team[1].score);
    pDC->DrawText(text, rect, DT_SINGLELINE | DT_VCENTER | DT_RIGHT);
    
    // teamname left
    pDC->SelectObject(M_font_team_name);
    if ( ! scale_over )
    {
        x1 = CENTER_X - scale(PITCH_LENGTH/2 + PITCH_MARGIN);
        x2 = CENTER_X - scale(PITCH_LENGTH/2 * 0.3);
    }
    else
    {
        x1 = (int)((double)m_iSizeX * 0.1);
        x2 = (int)((double)m_iSizeX * 0.35);
    }
    rect.SetRect(x1, y1, x2, y2);
    pDC->SetTextColor(M_color_score);
    pDC->SetBkColor(M_color_left_team);
    
    if( m_pLogPlayer->getTeamNameLeft().IsEmpty() )//! (*m_pInfo->team[0].name) )
    {
        text = "Team_L";
    }
    else
    {
        text = m_pLogPlayer->getTeamNameLeft();//m_pInfo->team[0].name;		
    }
    pDC->DrawText(text, rect, DT_SINGLELINE | DT_VCENTER | DT_CENTER);
    // teamname right
    if ( ! scale_over )
    {
        x2 = CENTER_X + scale(PITCH_LENGTH/2 + PITCH_MARGIN);
        x1 = CENTER_X + scale(PITCH_LENGTH/2 * 0.3);
    }
    else
    {
        x1 = (int)((double)m_iSizeX * 0.65);
        x2 = (int)((double)m_iSizeX * 0.9);
    }
    rect.SetRect(x1, y1, x2, y2);
    pDC->SetTextColor(M_color_score);
    pDC->SetBkColor(M_color_right_team);
    if ( m_pLogPlayer->getTeamNameRight().IsEmpty() )//! (*m_pInfo->team[1].name) )
    {
        text = "Team_R";
    }
    else
    {
        text = m_pLogPlayer->getTeamNameRight();//m_pInfo->team[1].name;
    }
    pDC->DrawText(text, rect, DT_SINGLELINE | DT_VCENTER | DT_CENTER);
    
    // playmode + time
    if ( m_pInfo->time >= 0 )
    {
        text.Format("%s     %d", PlayModeString[m_pInfo->pmode - 1], m_pInfo->time);
    }
    else
    {
        text.Format("%s     0", PlayModeString[m_pInfo->pmode - 1]);
    }

    if ( ! scale_over )
    {
        x1 = CENTER_X - scale(PITCH_LENGTH/2 * 0.25);
        x2 = CENTER_X + scale(PITCH_LENGTH/2 * 0.25);
    }
    else
    {
        x1 = (int)((double)m_iSizeX * 0.35);
        x2 = (int)((double)m_iSizeX * 0.65);
    }
    rect.SetRect(x1, y1, x2, y2);
    
    if ( m_pInfo->pmode != M_last_playmode )
    {
        s_playmode_count = 1;
    }

    if ( s_playmode_count < 8 )
    {
        s_playmode_count++;
        M_last_playmode = m_pInfo->pmode;

        pDC->SetTextColor(COLOR_BLUE);
        pDC->SetBkColor(COLOR_YELLOW);
    }
    else
    {
        pDC->SetTextColor(COLOR_BLACK);
        pDC->SetBkColor(COLOR_WHITE);
    }
    
    // playmode & time
    pDC->SelectObject(M_font_time);
    pDC->DrawText(text, rect, DT_SINGLELINE | DT_VCENTER | DT_CENTER);

    pDC->SelectObject(font_old);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::DrawPlayers(CDC *pDC)
{
    CString text;

    const ServerParam &sparam = m_pLogPlayer->serverParam();
    const int VISIBLE_DIST = scale(sparam.visdist);
    const int CATCHABLE_DIST
        = scale(sqrt(pow(sparam.catch_area_l, 2)
                     + pow(sparam.catch_area_w / 2.0, 2)));
    pDC->SelectObject(M_font_player);
    for ( int i = 0; i < MAX_PLAYER * 2; ++i )
    {
        const player_t& player = m_pInfo->pos[i];
        int type_id = (int)(player.type);
        if ( type_id < 0 || type_id > 6 )
        {
            type_id = 0;
        }
        const PlayerType& player_type = m_pLogPlayer->playerType(type_id);

        DrawPlayerT draw_player(m_pInfo->pos[i]);
        //const double stamina = (double)player.stamina / SHOWINFO_SCALE2;
        // set radius
        const double kickable_area = player_type.player_size
                                   + player_type.kickable_margin
                                   + sparam.bsize;
        int radius_kick = scale(kickable_area);
        int radius_player = radius_kick;
        int text_radius = radius_kick;

        if ( M_enlarged )
        {    
            if ( radius_player < 7 ) radius_player = 7;
        }
        else
        {
            radius_player = scale(player_type.player_size);
            if ( radius_player < 2 ) radius_player = 2;
        }        
        if ( text_radius > 40 )
        {
            text_radius = 40;
        }

        bool selected = false;
        if ( i + 1 == M_selected_player )
        {
            selected = true; 
        }

        // M_som.update(draw_player.pos_.x, draw_player.pos_.y);

        /////////////////////
        // get screen point
        if ( M_reverse_x )
        {
            draw_player.reverse();
        }

        if ( selected && isMonitorMovePlayer() )
        {
            draw_player.pos_ = convertPoint(M_drag_end_pos);
        }

        const int screen_x = screenX(draw_player.pos_.x);
        const int screen_y = screenY(draw_player.pos_.y);

        const double body_dir_x = cos(draw_player.body_);
        const double body_dir_y = sin(draw_player.body_);


        /////////////////////
        // draw kickable circle
        if ( ! M_enlarged )
        {
            // draw the kickable margin of this player
            setKickableMarginColor(pDC, player, i);
            pDC->Arc(screen_x - radius_kick, screen_y - radius_kick,
                     screen_x + radius_kick, screen_y + radius_kick,
                     0, 0, 0, 0);

            // draw body dir 
            pDC->MoveTo(screen_x, screen_y);
            pDC->LineTo(screen_x + (int)((double)radius_kick * body_dir_x),
                        screen_y + (int)((double)radius_kick * body_dir_y));
        }
        /////////////////////
        // draw body
        setPlayerColor(pDC, player, i);
        pDC->Ellipse(screen_x - radius_player, screen_y - radius_player,
                     screen_x + radius_player, screen_y + radius_player);
        if ( M_view_body_shadow )
        {
            double rate = draw_player.stamina_ / sparam.stamina_max;
            int rcol
                = 255 - (int)((double)(255 - (M_color_body_dir & 0x000000ff)) * rate);
            int gcol
                = 255 - (int)((double)(255 - ((M_color_body_dir & 0x0000ff00) >> 8)) * rate);
            int bcol
                = 255 - (int)((double)(255 - ((M_color_body_dir & 0x00ff0000) >> 16)) * rate);
            CBrush tmpBrush(RGB(rcol, gcol, bcol));
            pDC->SelectObject(&tmpBrush);
            pDC->SelectObject(M_pen_player_body_dir);
            
            int radius_shadow = (int)((double)radius_player * 0.9);
            int dirx1 = screen_x + (int)(10.0 * cos(draw_player.body_ - PI * 0.5));
            int diry1 = screen_y + (int)(10.0 * sin(draw_player.body_ - PI * 0.5));
            int dirx2 = screen_x + (int)(10.0 * cos(draw_player.body_ + PI * 0.5));
            int diry2 = screen_y + (int)(10.0 * sin(draw_player.body_ + PI * 0.5));
            pDC->Pie(screen_x - radius_shadow, screen_y - radius_shadow,
                     screen_x + radius_shadow, screen_y + radius_shadow,
                     dirx1, diry1, dirx2, diry2);
            tmpBrush.DeleteObject();
        }
        else
        {
            // draw body dir arrow
            pDC->SelectObject(M_brush_body_dir);
            pDC->SelectObject(M_pen_player_body_dir);
            int body_radius_x = (int)((double)radius_player * body_dir_x);
            int body_radius_y = (int)((double)radius_player * body_dir_y);

            CPoint pts[4];        
            pts[0].x = screen_x + body_radius_x;
            pts[0].y = screen_y + body_radius_y;
            pts[1].x = (long)(screen_x - (0.5 * body_radius_x + 0.2 * body_radius_y));
            pts[1].y = (long)(screen_y - (0.5 * body_radius_y - 0.2 * body_radius_x));
            pts[2].x = (long)(screen_x - (0.5 * body_radius_x - 0.2 * body_radius_y));
            pts[2].y = (long)(screen_y - (0.5 * body_radius_y + 0.2 * body_radius_x));
            pDC->Polygon(pts, 3);
        }
         
        ///////////////	
        // goalie catchable area, tackle area & tackle probability

        if ( M_view_control_area )
        {
            pDC->SelectObject(M_pen_player_control_area);

            // goalie
            if ( player.mode & GOALIE )
            {
                pDC->Arc(screen_x - CATCHABLE_DIST, screen_y - CATCHABLE_DIST,
                         screen_x + CATCHABLE_DIST, screen_y + CATCHABLE_DIST,
                         0, 0, 0, 0);
            }

            if ( m_pLogPlayer->protocolVersion() >= 2 )
            {
                Vector2D ball_pos((double)m_pInfo->ball.x / SHOWINFO_SCALE2,
                                  (double)m_pInfo->ball.y / SHOWINFO_SCALE2);
                Vector2D ball_next = ball_pos;
                ball_next.x += (double)m_pInfo->ball.deltax / SHOWINFO_SCALE2;
                ball_next.y += (double)m_pInfo->ball.deltay / SHOWINFO_SCALE2;
                if ( M_reverse_x )
                {
                    ball_pos *= -1.0;
                    ball_next *= -1.0;
                }
                Vector2D player_to_ball = ball_pos - draw_player.pos_;
                player_to_ball.rotate(AngleDeg::rad2deg(-draw_player.body_));

                double dist_ball = player_to_ball.r();
                
                // kick
                if ( selected && dist_ball <= kickable_area )
                {
                    double real_ball_dist = dist_ball - player_type.player_size - sparam.bsize;
                    double eff_kpower = sparam.maxp * sparam.kprate
                                        * (1.0 - 0.25 * player_to_ball.th().abs() / 180.0
                                           - 0.25 * real_ball_dist / player_type.kickable_margin);
                    int ibnx = screenX(ball_next.x);
                    int ibny = screenY(ball_next.y);
                    if ( eff_kpower > sparam.baccel_max )
                    {
                        eff_kpower = sparam.baccel_max;
                    }
                    int kick_eff_radius = scale(eff_kpower);
                    pDC->MoveTo(screenX(ball_pos.x), screenY(ball_pos.y));
                    pDC->LineTo(ibnx, ibny);
                    pDC->Arc(ibnx - kick_eff_radius, ibny - kick_eff_radius,
                             ibnx + kick_eff_radius, ibny + kick_eff_radius,
                             0, 0, 0, 0);
                    pDC->SetBkMode(TRANSPARENT);
                    pDC->SetTextColor(M_color_player_font1);
                    text.Format("kick_eff %.3f", eff_kpower);
                    pDC->TextOut(screen_x + text_radius,
                                 screen_y + (int)(0.4 * text_radius),
                                 text);
                }
                
                // tackle
                
                double tackle_dist = ( player_to_ball.x > 0.0
                                       ? sparam.M_tackle_dist : sparam.M_tackle_back_dist );
                double prob = ( pow( player_to_ball.absX() / tackle_dist, 
                                     sparam.M_tackle_exponent ) 
                                + pow( player_to_ball.absY() / sparam.M_tackle_width, 
                                       sparam.M_tackle_exponent ) );
                if ( prob < 1.0 || selected )
                {
                    double tackle_forward_x = sparam.M_tackle_dist * body_dir_x;
                    double tackle_forward_y = sparam.M_tackle_dist * body_dir_y;
                    double tackle_back_x = sparam.M_tackle_back_dist * -body_dir_x;
                    double tackle_back_y = sparam.M_tackle_back_dist * -body_dir_y;
                    double tackle_right_x = sparam.M_tackle_width * cos(draw_player.body_ + PI / 2.0);
                    double tackle_right_y = sparam.M_tackle_width * sin(draw_player.body_ + PI / 2.0);

                    CPoint pts[4];
                    pts[0].x = screenX(draw_player.pos_.x + tackle_forward_x + tackle_right_x);
                    pts[0].y = screenY(draw_player.pos_.y + tackle_forward_y + tackle_right_y);
                    pts[1].x = screenX(draw_player.pos_.x + tackle_forward_x - tackle_right_x);
                    pts[1].y = screenY(draw_player.pos_.y + tackle_forward_y - tackle_right_y);
 
                    pts[2].x = screenX(draw_player.pos_.x + tackle_back_x - tackle_right_x);
                    pts[2].y = screenY(draw_player.pos_.y + tackle_back_y - tackle_right_y);
                    pts[3].x = screenX(draw_player.pos_.x + tackle_back_x + tackle_right_x);
                    pts[3].y = screenY(draw_player.pos_.y + tackle_back_y + tackle_right_y);
                    
                    pDC->MoveTo(pts[3]);
                    pDC->LineTo(pts[0]);
                    pDC->Polyline(pts, 4);
                    
                    if ( prob < 1.0 )
                    {
                        pDC->SetBkMode(TRANSPARENT);
                        pDC->SetTextColor(M_color_player_font1);
                        text.Format("tprob %.3f", 1.0 - prob);
                        pDC->TextOut(screen_x + text_radius, screen_y + (int)(1.5 * text_radius), text);
                    }
                    
                }
            }
        }

        // draw view angle

        if ( M_view_visible_cone )
        {
            double view_width_half = ((double)player.view_width / SHOWINFO_SCALE2) * 0.5;
            double langle = draw_player.face_ - view_width_half;
            double rangle = draw_player.face_ + view_width_half;
            int view_lx, view_ly, view_rx, view_ry;
            if ( selected )
            {
                const int UNUM_VISIBLE_DIST = scale(20.0);
                const int TEAM_VISIBLE_DIST = scale(40.0);
                const int ONLY_VISIBLE_DIST = scale(60.0);

                view_lx = screen_x + (int)((double)ONLY_VISIBLE_DIST * cos(langle));
                view_ly = screen_y + (int)((double)ONLY_VISIBLE_DIST * sin(langle));
                view_rx = screen_x + (int)((double)ONLY_VISIBLE_DIST * cos(rangle));
                view_ry = screen_y + (int)((double)ONLY_VISIBLE_DIST * sin(rangle));
                pDC->SelectObject(M_pen_player_varea);
                pDC->Arc(screen_x - VISIBLE_DIST, screen_y - VISIBLE_DIST,
                         screen_x + VISIBLE_DIST, screen_y + VISIBLE_DIST,
                         0, 0, 0, 0);
                pDC->Arc(screen_x - UNUM_VISIBLE_DIST, screen_y - UNUM_VISIBLE_DIST,
                         screen_x + UNUM_VISIBLE_DIST, screen_y + UNUM_VISIBLE_DIST,
                         view_rx, view_ry,
                         view_lx, view_ly);
                pDC->Arc(screen_x - TEAM_VISIBLE_DIST, screen_y - TEAM_VISIBLE_DIST,
                         screen_x + TEAM_VISIBLE_DIST, screen_y + TEAM_VISIBLE_DIST,
                         view_rx, view_ry,
                         view_lx, view_ly);
                pDC->Arc(screen_x - ONLY_VISIBLE_DIST, screen_y - ONLY_VISIBLE_DIST,
                         screen_x + ONLY_VISIBLE_DIST, screen_y + ONLY_VISIBLE_DIST,
                         view_rx, view_ry,
                         view_lx, view_ly);
                pDC->MoveTo(view_lx, view_ly);
                pDC->LineTo(screen_x, screen_y);
                pDC->LineTo(view_rx, view_ry);
            }
            else
            {
                if ( M_view_eyes )
                {
                    pDC->SelectObject(M_brush_player_eye);
                    pDC->SelectObject(M_pen_player_vcone);
                    int eye_radius = radius_player / 5 + 1;
                    if ( eye_radius < 2 ) eye_radius = 2;
                    // draw player's left eye
                    view_lx = screen_x + (int)((double)radius_player * cos(langle));
                    view_ly = screen_y + (int)((double)radius_player * sin(langle));
                    pDC->Ellipse(view_lx - eye_radius, view_ly - eye_radius,
                                 view_lx + eye_radius, view_ly + eye_radius);
                    // draw player's right eye
                    view_rx = screen_x + (int)((double)radius_player * cos(rangle));
                    view_ry = screen_y + (int)((double)radius_player * sin(rangle));
                    pDC->Ellipse(view_rx - eye_radius, view_ry - eye_radius,
                                 view_rx + eye_radius, view_ry + eye_radius);
                    int eye_dist = (int)((double)radius_player * 1.1);
                    if ( eye_dist < 1 ) eye_dist = 1;
                    pDC->Arc(screen_x - eye_dist, screen_y - eye_dist,
                             screen_x + eye_dist, screen_y + eye_dist,
                             view_rx, view_ry, view_lx, view_ly);
                }
                else
                {
                    pDC->SelectObject(M_pen_player_vcone);
                    view_lx = screen_x + (int)((double)VISIBLE_DIST * cos(langle));
                    view_ly = screen_y + (int)((double)VISIBLE_DIST * sin(langle));
                    view_rx = screen_x + (int)((double)VISIBLE_DIST * cos(rangle));
                    view_ry = screen_y + (int)((double)VISIBLE_DIST * sin(rangle));
                    pDC->Arc(screen_x - VISIBLE_DIST, screen_y - VISIBLE_DIST,
                             screen_x + VISIBLE_DIST, screen_y + VISIBLE_DIST,
                             view_rx, view_ry,
                             view_lx, view_ly);
                    pDC->MoveTo(view_lx, view_ly);
                    pDC->LineTo(screen_x, screen_y);
                    pDC->LineTo(view_rx, view_ry);
                }
            }
        }
        

        // uniform number

        if ( M_view_numbers )
        {
            pDC->SetBkMode(TRANSPARENT);
            pDC->SetTextColor(M_color_player_font1);
            int unum = ( i < 11 ? i + 1 : i - 11 + 1 );
            text.Format("%d", unum);
            //pDC->SetBkMode(OPAQUE);
            pDC->TextOut(screen_x + text_radius, screen_y - (int)(1.2 * text_radius), text);
        }
        

        // player type

        if ( M_view_player_type )
        {
            pDC->SetBkMode(TRANSPARENT);
            text.Format("t%d", type_id);
            pDC->SetTextColor(M_color_player_font2);
            pDC->TextOut(screen_x + text_radius, screen_y, text);
        }

        if ( M_view_player_detail )
        {
            pDC->SetBkMode(TRANSPARENT);

            if ( selected )
            {
                const int unum = M_selected_player;
                const list<RCLSay>& say_list = m_pLogPlayer->getRCLSay((int)m_pInfo->time);
                list<RCLSay>::const_iterator say_end(say_list.end());
                for ( list<RCLSay>::const_iterator sayit = say_list.begin();
                      sayit != say_end;
                      ++sayit )
                {
                    if ( sayit->unum == i + 1 )
                    {
                        pDC->SetBkMode(TRANSPARENT);
                        pDC->SetTextColor(M_color_player_font1);
                        text.Format("say [%s]", sayit->message);
                        pDC->TextOut(screen_x + text_radius, screen_y + S_MAX_PLAYER_FONT_SIZE/10,
                                     text);
                        break;
                    }
                }

                const list<RCLAttentionto>& att_list = m_pLogPlayer->getRCLAttentionto((int)m_pInfo->time);
                list<RCLAttentionto>::const_iterator att_end(att_list.end());
                for ( list<RCLAttentionto>::const_iterator attit = att_list.begin();
                      attit != att_end;
                      ++attit )
                {
                    if ( attit->unum == i + 1 )
                    {
                        pDC->SetBkMode(TRANSPARENT);
                        pDC->SetTextColor(M_color_player_font1);
                        text.Format("attention %s %d", attit->target_name, attit->target_num);
                        pDC->TextOut(screen_x + text_radius, screen_y + S_MAX_PLAYER_FONT_SIZE/5,
                                     text);
                        break;
                    }
                }

                const list<RCLPointto>& pt_list = m_pLogPlayer->getRCLPointto((int)m_pInfo->time);
                list<RCLPointto>::const_iterator pt_end(pt_list.end());
                for ( list<RCLPointto>::const_iterator ptit = pt_list.begin();
                      ptit != pt_end;
                      ++ptit )
                {
                    if ( ptit->unum == i + 1 )
                    {
                        M_last_pointto_unum = ptit->unum; //dataunum;
                        M_pointto_start_time = (int)m_pInfo->time;
                        M_pointto_x = screen_x + scale(ptit->dist * cos(draw_player.body_ + ptit->dir / 180.0 * PI));
                        M_pointto_y = screen_y + scale(ptit->dist * sin(draw_player.body_ + ptit->dir / 180.0 * PI));
                        break;
                    }
                }

                if ( M_last_pointto_unum == i + 1
                     && (int)m_pInfo->time - M_pointto_start_time > 0
                     && (int)m_pInfo->time - M_pointto_start_time < m_pLogPlayer->serverParam().point_to_duration )
                {
                    pDC->SelectObject(M_pen_line);
                    pDC->MoveTo(screen_x, screen_y);
                    pDC->LineTo(M_pointto_x, M_pointto_y);
                    pDC->SetBkMode(TRANSPARENT);
                    pDC->SetTextColor(M_color_player_font1);
                    text.Format("point");
                    pDC->TextOut(M_pointto_x + 1,
                                 M_pointto_y + 1,
                                 text);
                }

                if ( M_status_dlg_ptr && M_status_dlg_ptr->IsWindowVisible() )
                {
                    M_status_dlg_ptr->setData(i, player, m_pInfo->ball, M_reverse_x);
                }

                pDC->SetTextColor(M_color_player_font1);
                text.Format("%d(e%.3f r%.3f)",
                            (int)draw_player.stamina_,
                            draw_player.effort_, //(double)player.effort / SHOWINFO_SCALE2,
                            draw_player.recovery_);//(double)player.recovery / SHOWINFO_SCALE2);

                // ݑxɂ銵ړʒu̕`
                pDC->SelectObject(M_pen_player_edge);
                Vector2D player_next = draw_player.pos_ + draw_player.vel_;
                int next_x = screenX(player_next.x);
                int next_y = screenY(player_next.y);
                pDC->MoveTo(screen_x, screen_y);
                pDC->LineTo(next_x, next_y);
                pDC->Arc(next_x - radius_player, next_y - radius_player,
                         next_x + radius_player, next_y + radius_player,
                         0, 0, 0, 0);
            }
            else
            {
                pDC->SetTextColor(M_color_player_font2);
                text.Format("%d", (int)draw_player.stamina_);            
            }
            pDC->TextOut(screen_x - (int)(2.0 * text_radius),
                         screen_y - (int)(2.25 * text_radius),
                         text);

            // draw tired state circle
			//if ( (double)player.effort / SHOWINFO_SCALE2 != player_type.effort_max )
            if ( draw_player.effort_ != player_type.effort_max )
            {
                pDC->SelectObject(M_pen_player_eff_tired);
                int r1 = (int)(1.2 * radius_player);
                pDC->Arc(screen_x - r1, screen_y - r1, screen_x + r1, screen_y + r1,
                         0, 0, 0, 0);
            }
			//else if ( (double)player.recovery / SHOWINFO_SCALE2 < 1.0 )
            else if ( draw_player.recovery_ < 1.0 )
            {
                pDC->SelectObject(M_pen_player_rec_tired);
                int r1 = (int)(1.2 * radius_player);
                pDC->Arc(screen_x - r1, screen_y - r1, screen_x + r1, screen_y + r1,
                         0, 0, 0, 0);
			}

        }
    }

    // offside line
    if ( M_view_offside_line )
    {
        drawOffsideLine(pDC);
    }

    // voronoi diagram
    if ( M_view_voronoi_diagram )
    {
        drawVoronoiDiagram(pDC);
    }

    if ( M_say_message_dlg_ptr
         && M_say_message_dlg_ptr->IsWindowVisible() 
         && ( M_last_draw_cycle < m_pInfo->time
              || ( M_last_draw_cycle == m_pInfo->time 
                   && M_last_draw_pmode != m_pInfo->pmode ) ) )
    {
        CString say_messages("");
        if ( M_say_message_dlg_ptr->M_print_coach_say )
        {
            const list<RCLSay>& coach_say
                    = m_pLogPlayer->getRCLCoachSay((int)m_pInfo->time);
            list<RCLSay>::const_iterator coach_say_end(coach_say.end());
            for ( list<RCLSay>::const_iterator csayit = coach_say.begin();
                  csayit != coach_say_end;
                  ++csayit )
            {
                text.Format("-----\r\n%d %s coach\r\n [%s]\r\n",
                            (int)m_pInfo->time,
                            csayit->unum < 12 ? "left" : "right",
                            csayit->message);
                say_messages += text;
            }
        }
        if ( M_say_message_dlg_ptr->M_print_player_say )
        {
            const list<RCLSay>& say_list
                    = m_pLogPlayer->getRCLSay((int)m_pInfo->time);
            if ( ! say_list.empty() )
            {
               text.Format("----- %d players' say\r\n", (int)m_pInfo->time);
                say_messages += text;
            }
            list<RCLSay>::const_iterator psay_end(say_list.end());
            for ( list<RCLSay>::const_iterator psayit = say_list.begin();
                  psayit != psay_end;
                  ++psayit )
            {
                text.Format(" %c %2d [%s]\r\n",
                            psayit->unum < 12 ? 'l' : 'r',
                            psayit->unum < 12 ? psayit->unum : psayit->unum - 11,
                            psayit->message);
                say_messages += text;
            }
        }
        int len = M_say_message_dlg_ptr->M_ctrl_coach_message.GetWindowTextLength();
        if ( len > 8192 * 4 - 128 )
        {
            // erase
            M_say_message_dlg_ptr->M_ctrl_coach_message.SetSel(0, 8192);
            M_say_message_dlg_ptr->M_ctrl_coach_message.ReplaceSel("");
            len = M_say_message_dlg_ptr->M_ctrl_coach_message.GetWindowTextLength();
        }
        M_say_message_dlg_ptr->M_ctrl_coach_message.SetSel(len, len);
        M_say_message_dlg_ptr->M_ctrl_coach_message.ReplaceSel(say_messages);
    }

    M_last_draw_cycle = m_pInfo->time;
    M_last_draw_pmode = m_pInfo->pmode;
}


//////////////////////////////////////////////////////////////////
void
CSoccermonitorDoc::drawOffsideLine(CDC *pDC)
{
    int i;

    // calc left side offside line
    double left_first = 0.0, left_second = 0.0;
    for ( i = 0; i < MAX_PLAYER; ++i )
    {
        if ( m_pInfo->pos[i].mode == 0 ) continue;
        double player_x = (double)(m_pInfo->pos[i].x) / SHOWINFO_SCALE2;
        if ( player_x < left_second )
        {
            left_second = player_x;
            if ( left_second < left_first )
            {
                double tmp = left_first;
                left_first = left_second;
                left_second = tmp;
            }
        }
    }
    
    // calc right side offside line
    double right_first = 0.0, right_second = 0.0;
    for ( i = MAX_PLAYER; i < MAX_PLAYER * 2; ++i )
    {
        if ( m_pInfo->pos[i].mode == 0 ) continue;
        double player_x = (double)(m_pInfo->pos[i].x) / SHOWINFO_SCALE2;
        if ( player_x > right_second )
        {
            right_second = player_x;
            if ( right_second > right_first )
            {
                double tmp = right_first;
                right_first = right_second;
                right_second = tmp;
            }
        }
    }
    
    // check ball pos
    double ball_x = (double)m_pInfo->ball.x / SHOWINFO_SCALE2;
    if ( ball_x < left_second )
    {
        left_second = ball_x;
    }
    if ( ball_x > right_second )
    {
        right_second = ball_x;
    }
    
    if ( M_reverse_x )
    {
        left_second *= -1.0;
        right_second *= -1.0;
    }
    
    pDC->SelectObject(M_pen_offside_line);
    int topy = screenY(-PITCH_WIDTH/2);
    int bottomy = screenY(PITCH_WIDTH/2);
    
    // left
    int offx = screenX(left_second);
    pDC->MoveTo(offx, topy);
    pDC->LineTo(offx, bottomy);
    // right
    offx = screenX(right_second);
    pDC->MoveTo(offx, topy);
    pDC->LineTo(offx, bottomy);
}

//////////////////////////////////////////////////////////////////

void
CSoccermonitorDoc::drawVoronoiDiagram(CDC *pDC)
{
    static const double max_x_abs = PITCH_LENGTH * 0.5;
    static const double max_y_abs = PITCH_WIDTH * 0.5;

    int i, j, k, l;
    vector<Vector2D> players_pos;
    players_pos.reserve(MAX_PLAYER * 2);
    //------------------------------------------------------
    // register players's pos
    for ( i = 0; i < MAX_PLAYER * 2; ++i )
    {
        if ( m_pInfo->pos[i].mode == 0 ) continue;
        players_pos.push_back(Vector2D((double)m_pInfo->pos[i].x / SHOWINFO_SCALE2,
                                       (double)m_pInfo->pos[i].y / SHOWINFO_SCALE2));
    }
    // reverse
    if ( M_reverse_x )
    {
        const vector<Vector2D>::iterator pos_end = players_pos.end();
        for ( vector<Vector2D>::iterator it = players_pos.begin();
              it != pos_end;
              ++it )
        {
            *it *= -1.0;
        }
    }
    //------------------------------------------------------
    const int MAX_POINT = players_pos.size();    
    if ( MAX_POINT <= 2 )
    {
        return;
    }

    //------------------------------------------------------
    pDC->SelectObject(M_pen_voronoi_diagram);
    //------------------------------------------------------
    vector<Vector2D> segment_points;
    for ( i = 0; i < MAX_POINT - 1; ++i )
    {
        for ( j = i + 1; j < MAX_POINT; ++j )
        {
            // make candidate line
            const Line2D first_perpend
                = getCenterPerpendicular(players_pos[i], players_pos[j]);
            Vector2D left_edge, right_edge;
            getEdgePoint(first_perpend, &left_edge, &right_edge);
            segment_points.clear();
            segment_points.push_back(left_edge);
            segment_points.push_back(right_edge);

            // to make the segment, check all other points
            // register segment points
            for ( k = 0; k < MAX_POINT; ++k )
            {
                if ( k == i || k == j )
                {
                    continue;
                }

                Line2D k_perpend = getCenterPerpendicular(players_pos[i],
                                                          players_pos[k]);
                Vector2D perpend_intersect;
                if ( ! first_perpend.intersection(k_perpend, perpend_intersect) )
                {
                    continue; // intersection does not exist
                }
                if ( perpend_intersect.absX() > max_x_abs
                     || perpend_intersect.absY() > max_y_abs )
                {
                    continue; // intersection is out of pitch
                }
                segment_points.push_back(perpend_intersect);
            }
            // sort segment points
            if ( fabs(first_perpend.B()) < 0.001 )
            {
                sort(segment_points.begin(), segment_points.end(), Vector2DYCmp());
            }
            else
            {
                sort(segment_points.begin(), segment_points.end(), Vector2DXCmp());
            }

            const vector<Vector2D>::iterator seg_end = segment_points.end() - 1;
            for ( vector<Vector2D>::iterator it = segment_points.begin();
                  it != seg_end;
                  ++it )
            {
                vector<Vector2D>::iterator it_next = it + 1;
                Vector2D segment_center = *it + *it_next;
                segment_center *= 0.5;
                bool is_draw_segment = true;
                const double dist2_to_first = segment_center.dist2(players_pos[i]);
                for ( l = 0; l < MAX_POINT; ++l )
                {
                    if ( l == i || l == j )
                    {
                        continue;
                    }
                    if ( segment_center.dist2(players_pos[l]) < dist2_to_first )
                    {
                       is_draw_segment = false;
                       break;
                    }
                }
                if ( is_draw_segment )
                {
                    pDC->MoveTo(screenX(it->x), screenY(it->y));
                    pDC->LineTo(screenX(it_next->x), screenY(it_next->y));
                }
            }
        }
    }
}


Line2D
CSoccermonitorDoc::getCenterPerpendicular(const Vector2D &first_point,
                                          const Vector2D &second_point)
{
    Line2D line(first_point, second_point);
    Vector2D center = first_point + second_point;
    center *= 0.5;
    return line.perpendicular(center);
}

void
CSoccermonitorDoc::getEdgePoint(const Line2D &line,
                                Vector2D *left_edge,
                                Vector2D *right_edge)
{
    static const double max_x = PITCH_LENGTH * 0.5;
    static const double min_x = -max_x;
    static const double max_y = PITCH_WIDTH * 0.5;
    static const double min_y = -max_y;

    if ( fabs(line.B()) < 0.001 )
    {
        left_edge->assign(-line.C() / line.A(), min_y);
        right_edge->assign(-line.C() / line.A(), max_y);
        return;
    }

    double left_limit_y = line.getY(min_x);
    if ( min_y <= left_limit_y && left_limit_y <= max_y ) // tB[hɎ܂
    {
        left_edge->assign(min_x, left_limit_y);
    }
    else
    {
       if ( -line.A() / line.B() > 0.0 )
       {
           left_edge->assign(line.getX(min_y), min_y);
       }
       else
       {
           left_edge->assign(line.getX(max_y), max_y);
       }
    }

    double right_limit_y = line.getY(max_x);
    if ( min_y <= right_limit_y && right_limit_y <= max_y ) // tB[hɎ܂
    {
        right_edge->assign(max_x, right_limit_y);
    }
    else
    {
        if ( -line.A() / line.B() > 0.0 )
        {
            right_edge->assign(line.getX(max_y), max_y);
        }
        else
        {
            right_edge->assign(line.getX(min_y), min_y);
        }
    }
}

//////////////////////////////////////////////////////////////////
void
CSoccermonitorDoc::setPlayerColor(CDC *pDC,
                                  const player_t& player,
                                  const int player_idx)
{
    // set pen & brush depended on player's state

    // edge color
    pDC->SelectObject(M_pen_player_edge);

    if ( player.mode == 0 )
    {
        pDC->SelectObject(M_brush_body_dir);
        return;
    }


    // set base color
    if ( player_idx < 11 )
    {
        // left side brush
        if ( player.mode & GOALIE )
        {
            pDC->SelectObject(M_brush_left_goalie);
        }
        else
        {	
            pDC->SelectObject(M_brush_left_player);
        }
    }
    else
    {
        // right side
        if ( player.mode & GOALIE )
        {
            pDC->SelectObject(M_brush_right_goalie);
        }
        else
        {
            pDC->SelectObject(M_brush_right_player);
        }
    }

    // special state color
    if ( player.mode & KICK )
    {
        pDC->SelectObject(M_pen_player_kick);
    }
    if ( player.mode & KICK_FAULT )
    {
        pDC->SelectObject(M_pen_player_kick_fault);
        pDC->SelectObject(M_brush_kick_fault);
    }
    if ( player.mode & CATCH2 )
    {
        pDC->SelectObject(M_pen_player_catch);
        pDC->SelectObject(M_brush_catch);
    }
    if ( player.mode & CATCH_FAULT )
    {
        pDC->SelectObject(M_pen_player_catch);
        pDC->SelectObject(M_brush_catch_fault);
    }
    if ( player.mode & TACKLE )
    {
        pDC->SelectObject(M_pen_player_tackle);
        pDC->SelectObject(M_brush_tackle);
    }
    if ( player.mode & TACKLE_FAULT )
    {
        pDC->SelectObject(M_pen_player_tackle);
        pDC->SelectObject(M_brush_tackle_fault);
    }
    if ( player.mode & BALL_COLLIDE
        || player.mode & BALL_TO_PLAYER
        || player.mode & PLAYER_TO_BALL )
    {
        pDC->SelectObject(M_brush_ball_collide);
    }
    if ( player.mode & PLAYER_COLLIDE )
    {
        pDC->SelectObject(M_brush_player_collide);
    }
}

//////////////////////////////////////////////////////////////////
void
CSoccermonitorDoc::setKickableMarginColor(CDC *pDC,
                                          const player_t& player,
                                          const int player_idx)
{
    // this is used for not enlarged player's kickable area
    if ( player_idx < 11 )
    {
        pDC->SelectObject(M_pen_left_player_edge);
    }
    else
    {
        pDC->SelectObject(M_pen_right_player_edge);
    }

    if ( player.mode & KICK )
    {
        pDC->SelectObject(M_pen_player_kick);
    }
    if ( player.mode & KICK_FAULT )
    {
        pDC->SelectObject(M_pen_player_kick_fault);
    }
    if ( player.mode & TACKLE )
    {
        pDC->SelectObject(M_pen_player_tackle);
    }
    if ( player.mode & TACKLE_FAULT )
    {
        pDC->SelectObject(M_pen_player_tackle_fault);
    }
    if ( player.mode & CATCH2 || player.mode & CATCH_FAULT )
    {
        pDC->SelectObject(M_pen_player_catch);
    }   
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::DrawBall(CDC *pDC)
{
    const ball_t* ball = &m_pInfo->ball;

    int radius_ball;    
    if ( M_enlarged )
    {
        radius_ball = scale(m_pLogPlayer->serverParam().bsize * 4);
        if ( radius_ball < 3 ) radius_ball = 3;
    }
    else
    {
        radius_ball = scale(m_pLogPlayer->serverParam().bsize);
        if ( radius_ball < 1 ) radius_ball = 1;
    }
    
    // the coordinates of the object
    double bx = (double)ball->x / SHOWINFO_SCALE2,
           by = (double)ball->y / SHOWINFO_SCALE2;
    if ( M_reverse_x )
    {
        bx *= -1.0; by *= -1.0;
    }

    int screen_x = M_field_center_x + scale(bx);
    int screen_y = M_field_center_y + scale(by);

    // set color

    // edge
    pDC->SelectObject(M_pen_ball);

    switch ( m_pInfo->pmode - 1 ) {
    //case PM_BEFORE_KICK_OFF:
    //case PM_TIME_OVER:
    //case PM_PLAY_ON:
    case PM_KICK_OFF_L:
    case PM_KICK_IN_L:
    case PM_FREE_KICK_L:
    case PM_CORNER_KICK_L:
    case PM_GOAL_KICK_L:
    case PM_OFFSIDE_R:
    case PM_PENALTY_KICK_L:
    case PM_FOUL_CHARGE_R:
    case PM_FOUL_PUSH_R:
    case PM_FOUL_MULTIPLE_ATTACK_R:
    case PM_FOUL_BALL_OUT_R:
    case PM_BACK_PASS_R:
    case PM_FREE_KICK_FAULT_R:
    case PM_CATCH_FAULT_R:
    case PM_INDIRECT_FREE_KICK_L:
    case PM_PENALTY_SETUP_L:
    case PM_PENALTY_READY_L:
        //pDC->SelectObject(M_pen_left_player_edge);
        pDC->SelectObject(M_brush_left_player);
        break;
    case PM_KICK_OFF_R:
    case PM_KICK_IN_R:
    case PM_FREE_KICK_R:
    case PM_CORNER_KICK_R:
    case PM_GOAL_KICK_R:
    case PM_OFFSIDE_L:
    case PM_PENALTY_KICK_R:
    case PM_FOUL_CHARGE_L:
    case PM_FOUL_PUSH_L:
    case PM_FOUL_MULTIPLE_ATTACK_L:
    case PM_FOUL_BALL_OUT_L:
    case PM_BACK_PASS_L:
    case PM_FREE_KICK_FAULT_L:
    case PM_CATCH_FAULT_L:
    case PM_INDIRECT_FREE_KICK_R:
    case PM_PENALTY_SETUP_R:
    case PM_PENALTY_READY_R:
        //pDC->SelectObject(M_pen_right_player_edge);
        pDC->SelectObject(M_brush_right_player);
        break;
    //case PM_GOAL_L:
    //case PM_GOAL_R:
    //case PM_DROP_BALL:
    //case PM_FIRST_HALF_OVER:
    //case PM_PAUSE:
    //case PM_HUMAN_JUDGE:
    //case PM_PENALTY_TAKEN_L:
    //case PM_PENALTY_TAKEN_R:
    //case PM_PENALTY_MISS_L:
    //case PM_PENALTY_MISS_R:
    //case PM_PENALTY_SCORE_L:
    //case PM_PENALTY_SCORE_R:
    //case PM_MAX:
    default:
        pDC->SelectObject(M_brush_ball);
        break;
    }


    // draw
    pDC->Ellipse(screen_x - radius_ball, screen_y - radius_ball,
                 screen_x + radius_ball, screen_y + radius_ball);

    if ( ! M_enlarged )
    {
        int kickable = scale(m_pLogPlayer->serverParam().kmargin
                             + m_pLogPlayer->serverParam().bsize);
        pDC->Arc(screen_x - kickable, screen_y - kickable,
                 screen_x + kickable, screen_y + kickable,
                 0, 0, 0, 0);
    }

    if ( M_view_ball_detail )
    {
        CString str;
        const ServerParam& sparam = m_pLogPlayer->serverParam();
        double ballvx = m_pInfo->ball.deltax / SHOWINFO_SCALE2;
        double ballvy = m_pInfo->ball.deltay / SHOWINFO_SCALE2;
        if ( M_reverse_x )
        {
            ballvx *= -1.0; ballvy *= -1.0;
        }

        const int draw_cyc = ( M_ball_dlg_ptr ? M_ball_dlg_ptr->M_future_cyc : 1 );
        double vtmpx = ballvx;
        double vtmpy = ballvy;
        int nx = screen_x;
        int ny = screen_y;
        int r = (int)(radius_ball * 0.7);
        if ( r < 1 ) r = 1;
        else if ( r > 5 ) r = 5;
        int i;
        for ( i = 0; i < draw_cyc; i++ )
        {
            int scaledx = scale(vtmpx);
            int scaledy = scale(vtmpy);
            if ( abs(scaledx) < 5 && abs(scaledy) < 5 )
            {
                break;
            }
            nx += scaledx;
            ny += scaledy;
            pDC->Arc(nx - r, ny - r, nx + r, ny + r,
                     0, 0, 0, 0);
            vtmpx *= sparam.bdecay;
            vtmpy *= sparam.bdecay;
        }
        pDC->MoveTo(screen_x, screen_y);
        pDC->LineTo(nx, ny);

        if ( M_ball_dlg_ptr )
        {
            M_ball_dlg_ptr->M_pos.Format("%.2f,  %.2f", bx, by);
            M_ball_dlg_ptr->M_vel.Format("%.2f,  %.2f", ballvx, ballvy);
            M_ball_dlg_ptr->M_vel_r.Format("%.2f", sqrt(ballvx * ballvx + ballvy * ballvy));
            M_ball_dlg_ptr->M_vel_th.Format("%.1f", atan2(ballvy, ballvx) * 180.0 / PI);
            const int cur = m_pLogPlayer->getCurrentCycle();
            const myshowinfo_t2 *prev_show = m_pLogPlayer->getShow(cur - 1);
            if ( prev_show )
            {
                double lastvx = ballvx / sparam.bdecay;
                double lastvy = ballvy / sparam.bdecay;
                double prevvx = (double)(long)ntohl((long)prev_show->ball.deltax) / SHOWINFO_SCALE2;
                double prevvy = (double)(long)ntohl((long)prev_show->ball.deltay) / SHOWINFO_SCALE2;
                if ( M_reverse_x )
                {
                    prevvx *= -1.0; prevvy *= -1.0;
                }
                double accx = lastvx - prevvx;
                double accy = lastvy - prevvy;

                // it is also necessary to consider about wind effect.

                M_ball_dlg_ptr->M_last_vel.Format("%.2f,  %.2f", lastvx, lastvy);
                M_ball_dlg_ptr->M_last_vel_r.Format("%.2f", sqrt(lastvx * lastvx + lastvy * lastvy));
                M_ball_dlg_ptr->M_last_vel_th.Format("%.1f", atan2(lastvy, lastvx) * 180.0 / PI);
                M_ball_dlg_ptr->M_acc.Format("%.2f,  %.2f", accx, accy);
                M_ball_dlg_ptr->M_acc_r.Format("%.2f", sqrt(accx * accx + accy * accy));
                M_ball_dlg_ptr->M_acc_th.Format("%.1f", atan2(accy, accx) * 180.0 / PI);
            }
            else
            {
                M_ball_dlg_ptr->M_last_vel.Empty();
                M_ball_dlg_ptr->M_last_vel_r.Empty();
                M_ball_dlg_ptr->M_last_vel_th.Empty();
                M_ball_dlg_ptr->M_acc.Empty();
                M_ball_dlg_ptr->M_acc_r.Empty();
                M_ball_dlg_ptr->M_acc_th.Empty();
            }
            M_ball_dlg_ptr->UpdateData(FALSE);
        }
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnRefreshMonitor() 
{
    // TODO: Add your command handler code here
    RedrawDoc();
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnMonitorMovePlayer() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
#ifdef USE_MOUSE_RELEASE_FUNC
    if ( ! M_monitor_move_player )
    {
        releaseMouseLeft();
        M_selected_player = 0;
        M_player_auto_select = false;
        M_monitor_move_player = true;
    }
    else
    {
        M_monitor_move_player = false;
    }

#else
    M_monitor_move_player = ! M_monitor_move_player;
    if ( M_monitor_move_player )
    {
        M_selected_player = 0;
        M_focus_type = FOCUS_AUTO;
        M_player_auto_select = false;
        M_view_measure = false;
        M_drag_zoom = false;
        M_monitor_discard_player = false;
    }
#endif
}

void CSoccermonitorDoc::OnUpdateMonitorMovePlayer(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here	
    pCmdUI->SetCheck(M_monitor_move_player ? 1 : 0);
}

void CSoccermonitorDoc::doMovePlayer(const CPoint& point)
{
    if ( M_selected_player > 0 )
    {
        int side = 1;
        int unum = M_selected_player;
        double angle = 0.0;
        if ( unum > 11 )
        {
            side = -1;
            unum -= 11;
            angle = 180.0;
        }
        Vector2D target = convertPoint(point);
        doMovePlayer(side, unum,
                     (int)(target.x * SHOWINFO_SCALE),
                     (int)(target.y * SHOWINFO_SCALE),
                     angle);
        M_selected_player = 0;
    }
}

void CSoccermonitorDoc::doMovePlayer(int side, int unum,
                                     int x, int y,
                                     const double& angle)
{
    if ( M_connected )
    {
        CString	message;
        message.Format("(dispplayer %d %d %d %d %d)",
                       side, unum, x, y, (int)(angle));
        m_pSocket->SendMsg(message);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnMonitorDiscardPlayer() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
#ifdef USE_MOUSE_RELEASE_FUNC
    if ( ! M_monitor_discard_player )
    {
        releaseMouseLeft();
        M_monitor_discard_player = true;
    }
    else
    {
        M_monitor_discard_player = false;
    }
#else
    M_monitor_discard_player = ! M_monitor_discard_player;
    if ( M_monitor_discard_player )
    {
        M_selected_player = 0;
        M_focus_type = FOCUS_AUTO;
        M_player_auto_select = false;
        M_view_measure = false;
        M_drag_zoom = false;
        M_monitor_move_player = false;
    }
#endif
}

void CSoccermonitorDoc::OnUpdateMonitorDiscardPlayer(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    if ( M_connected )
    {
        pCmdUI->Enable(TRUE);
    	pCmdUI->SetCheck(M_monitor_discard_player ? 1 : 0);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

void CSoccermonitorDoc::doDiscardPlayer(const int idx)
{
    //TRACE1("discard %d\n", idx);
    if ( M_connected )
    {
        CString msg;
        msg.Format("(dispdiscard %d %d)",
                   idx < 12 ? 1 : -1,
                   idx < 12 ? idx : idx - 11);
        m_pSocket->SendMsg(msg);
        TRACE1("%s\n", msg);
    }
}

//////////////////////////////////////////////////////////////////
int CSoccermonitorDoc::FindPlayer(const Vector2D &pt, double thr)
{
    if ( m_pInfo == NULL )
    {
        return 0;
    }

    double minerror2 = thr * thr;
    int player = 0;
    double tmpdis2, tmpx, tmpy;
    Vector2D coord = pt;
    if ( M_reverse_x )
    {
        coord *=-1.0;
    }

    for ( int i = 1; i <= 2*MAX_PLAYER; i++ )
    {
        if ( ! m_pInfo->pos[i-1].mode )
        {
            continue;
        }
        tmpx = coord.x - (double)m_pInfo->pos[i-1].x / SHOWINFO_SCALE2;
        tmpy = coord.y - (double)m_pInfo->pos[i-1].y / SHOWINFO_SCALE2;
        tmpdis2 = tmpx * tmpx + tmpy * tmpy;
        if ( tmpdis2 < minerror2 )
        {
            minerror2 = tmpdis2;
            player = i;
        }
    }
    return player;
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnCoachConnect() 
{
    // TODO: Add your command handler code here
    if( ! M_connected ) 
    {
        return;
    }
    
    M_coach_ptr = new TCoachAgent(this);
    if( M_coach_ptr->Connect() )
    {
        M_coach_connected = true;
    }
    else
    {
        delete M_coach_ptr;
    }
}

void CSoccermonitorDoc::OnUpdateCoachConnect(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
    if( M_connected && ! M_coach_connected )
    {
        pCmdUI->Enable(TRUE);
    }
    else
    {
        pCmdUI->Enable(FALSE);	
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnCoachDisconnect() 
{
    // TODO: Add your command handler code here
    if ( ! M_coach_connected ) 
    {
        return;
    }
    
    M_coach_ptr->DisconnectAgent();
    M_coach_connected = false;
    delete M_coach_ptr;
    M_coach_ptr = NULL;
}

void CSoccermonitorDoc::OnUpdateCoachDisconnect(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
    if( M_coach_connected )
    {
        pCmdUI->Enable(TRUE);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnCoachLook() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	if ( M_coach_connected && coach() )
    {
        coach()->doLook();
    }
}

void CSoccermonitorDoc::OnUpdateCoachLook(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
    
    if ( M_coach_connected )
    {
        pCmdUI->Enable(TRUE);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnTrainerStopGame() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	if ( M_coach_connected && coach() )
    {
        coach()->doChangeMode(PM_TIME_OVER);
    }
}

void CSoccermonitorDoc::OnUpdateTrainerStopGame(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(M_coach_connected ? TRUE : FALSE);    
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnTrainerPauseGame() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    if ( M_coach_connected && coach() )
    {
    	coach()->doChangeMode(PM_BEFORE_KICK_OFF);
    }
}

void CSoccermonitorDoc::OnUpdateTrainerPauseGame(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(M_coach_connected ? TRUE : FALSE);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnCoachEar() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    if ( M_coach_connected && coach() )
    {
    	coach()->doEar();
    }
}

void CSoccermonitorDoc::OnUpdateCoachEar(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
    if ( M_coach_connected && coach() )
    {
        pCmdUI->Enable(TRUE);
        pCmdUI->SetCheck(coach()->isEarOn() ? 1 : 0);
    }
    else
    {
        pCmdUI->Enable(FALSE);	
        pCmdUI->SetCheck(0);
    }	
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnCoachEye() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    if ( M_coach_connected && coach() )
    {
        coach()->doEye();
    }
}

void CSoccermonitorDoc::OnUpdateCoachEye(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
    if ( M_coach_connected && coach() )
    {
        pCmdUI->Enable(TRUE);
        pCmdUI->SetCheck(coach()->isEyeOn() ? 1 : 0);
    }
    else
    {
        pCmdUI->Enable(FALSE);	
        pCmdUI->SetCheck(0);
    }	
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnTrainerMoveBall() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    if ( M_coach_connected && coach() )
    {
    	Vector2D pt = convertPoint(m_pView->getRefereeFoulPoint());
	    coach()->doMoveBall(pt.x, pt.y);
    }
}

void CSoccermonitorDoc::OnUpdateTrainerMoveBall(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    pCmdUI->Enable(M_coach_connected ? TRUE : FALSE);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnPlayModeCommand(UINT nID)
{
    if ( ! M_coach_connected || ! coach() )
    {
        return;
    }

    switch ( nID ) {
    case IDC_PM_BEFORE_KICK_OFF:
        coach()->doChangeMode(PM_BEFORE_KICK_OFF);
        break;
    case IDC_PM_TIME_OVER:
        coach()->doChangeMode(PM_TIME_OVER);
        break;
    case IDC_PM_PLAY_ON:
        coach()->doChangeMode(PM_PLAY_ON);
        break;
    case IDC_PM_KICK_OFF_LEFT:
        coach()->doChangeMode(PM_KICK_OFF_L);
        break;
    case IDC_PM_KICK_OFF_RIGHT:
        coach()->doChangeMode(PM_KICK_OFF_R);
        break;
    case IDC_PM_KICK_IN_LEFT:
        coach()->doChangeMode(PM_KICK_IN_L); 
        break;
    case IDC_PM_KICK_IN_RIGHT:
        coach()->doChangeMode(PM_KICK_IN_R); 
        break;
    case IDC_PM_FREE_KICK_LEFT:
        coach()->doChangeMode(PM_FREE_KICK_L);
        break;
    case IDC_PM_FREE_KICK_RIGHT:
        coach()->doChangeMode(PM_FREE_KICK_R);
        break;
    case IDC_PM_CORNER_KICK_LEFT:
        coach()->doChangeMode(PM_CORNER_KICK_L);
        break;
    case IDC_PM_CORNER_KICK_RIGHT:
        coach()->doChangeMode(PM_CORNER_KICK_R);
        break;
    case IDC_PM_GOAL_KICK_LEFT:
        coach()->doChangeMode(PM_GOAL_KICK_L);
        break;
    case IDC_PM_GOAL_KICK_RIGHT:
        coach()->doChangeMode(PM_GOAL_KICK_R);
        break;
    case IDC_PM_GOAL_LEFT:
        coach()->doChangeMode(PM_GOAL_L);
        break;
    case IDC_PM_GOAL_RIGHT:
        coach()->doChangeMode(PM_GOAL_R);
        break;
    case IDC_PM_DROP_BALL:
        coach()->doChangeMode(PM_DROP_BALL);
        break;
    default:
        TRACE0("unknown playmode id");
        break;
    }
}

void CSoccermonitorDoc::OnUpdatePlayModeCommand(CCmdUI* pCmdUI)
{
    pCmdUI->Enable(M_coach_connected ? TRUE : FALSE);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnUpdateCoachStart(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
    if ( M_coach_connected && coach() )
    {
        pCmdUI->Enable(TRUE);
        pCmdUI->SetCheck(coach()->isRunning() ? 1 : 0);
    }
    else
    {
        pCmdUI->Enable(FALSE);	
        pCmdUI->SetCheck(0);
    }	
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewVisibleCone() 
{
    // TODO: Add your command handler code here
    M_view_visible_cone = ! M_view_visible_cone;	
    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdateViewVisibleCone(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
    if ( m_pLogPlayer->protocolVersion() >= 2 )
    {
        pCmdUI->Enable(TRUE);
        if ( M_view_visible_cone )
        {
            pCmdUI->SetCheck(TRUE);
        }
        else
        {
            pCmdUI->SetCheck(FALSE);
        }
    }
    else
    {
        M_view_visible_cone = false;
        pCmdUI->Enable(FALSE);
        pCmdUI->SetCheck(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::getBallDialog()
{
    if ( M_ball_dlg_ptr == NULL )
    {
        CMainFrame *pFrame = (CMainFrame*)AfxGetApp()->m_pMainWnd;
        if ( pFrame )
        {
            M_ball_dlg_ptr = new BallStatusDialog(pFrame);
            if ( M_ball_dlg_ptr )
            {
                M_ball_dlg_ptr->Create(IDD_BALL_DIALOG, pFrame);
                CRect rect, size;
                m_pView->GetWindowRect(&rect);
                M_ball_dlg_ptr->GetWindowRect(&size);
                M_ball_dlg_ptr->MoveWindow(rect.left + rect.Width() / 2 - size.Width() / 2,
                                           rect.top + 5,
                                           size.Width(),
                                           size.Height());   
            }
        }
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::getStatusDialog()
{
    if ( M_status_dlg_ptr == NULL )
    {
        CMainFrame *pFrame = (CMainFrame*)AfxGetApp()->m_pMainWnd;
        if ( pFrame )
        {
            M_status_dlg_ptr = new PlayerStatusDialog(pFrame);
            if ( M_status_dlg_ptr )
            {
                M_status_dlg_ptr->Create(IDD_STATUS_DLG, pFrame);
                CRect rect, size;
                m_pView->GetWindowRect(&rect);
                M_status_dlg_ptr->GetWindowRect(&size);
                M_status_dlg_ptr->MoveWindow(rect.left + 5, rect.top + 5,
                                             size.Width(), size.Height());
            }
        }
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::getPlayerTypeDialog()
{
    if ( M_player_type_dlg_ptr == NULL )
    {
        CMainFrame *pFrame = (CMainFrame*)AfxGetApp()->m_pMainWnd;
        if ( pFrame )
        {
            M_player_type_dlg_ptr = new PlayerTypeDialog(pFrame);
            if ( M_player_type_dlg_ptr )
            {
                M_player_type_dlg_ptr->Create(IDD_PLAYER_TYPE_DIALOG, pFrame);
                CRect rect, size;
                m_pView->GetWindowRect(&rect);
                M_player_type_dlg_ptr->GetWindowRect(&size);
                M_player_type_dlg_ptr->MoveWindow(rect.right - size.Width() - 5,
                                                  rect.top + 5,
                                                  size.Width(),
                                                  size.Height());
            }
        }
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::getPlayerTypeListDialog()
{
    if ( M_player_type_list_dlg_ptr == NULL )
    {
        CMainFrame *pFrame = (CMainFrame*)AfxGetApp()->m_pMainWnd;
        if ( pFrame )
        {
            M_player_type_list_dlg_ptr = new PlayerTypeListDialog(pFrame);        
            if ( M_player_type_list_dlg_ptr )
            {
                M_player_type_list_dlg_ptr->Create(IDD_PLAYER_TYPE_LIST, pFrame);
                HICON icon = ::LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_PLAYER_TYPE_LIST));
                M_player_type_list_dlg_ptr->SetIcon(icon, FALSE);
                for ( int i = 0; i < m_pLogPlayer->numPlayerTypes(); i++ )
                {
                    M_player_type_list_dlg_ptr->setData(i, m_pLogPlayer->playerType(i));
                }
            }
        }
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::getCoachMessageDialog()
{
    if ( M_say_message_dlg_ptr == NULL )
    {
        CMainFrame *pFrame = (CMainFrame*)AfxGetApp()->m_pMainWnd;
        if ( pFrame )
        {
            M_say_message_dlg_ptr = new CoachMessageDialog(pFrame);
            if ( M_say_message_dlg_ptr )
            {
                M_say_message_dlg_ptr->Create(IDD_COACH_DIALOG, pFrame);
                M_say_message_dlg_ptr->M_ctrl_coach_message.SetLimitText(8192 * 4);
            }
        }
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewPlayerDetail()
{
	M_view_player_detail = ! M_view_player_detail;

    getStatusDialog();
    if ( ! M_view_player_detail && M_status_dlg_ptr
         && M_status_dlg_ptr->IsWindowVisible() )
    {
        M_status_dlg_ptr->ShowWindow(SW_HIDE);
    }
 
    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdateViewPlayerDetail(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
    if ( m_pLogPlayer->protocolVersion() >= 2 )
    {
        pCmdUI->Enable(TRUE);
        pCmdUI->SetCheck(M_view_player_detail ? 1 : 0);
    }
    else
    {
        M_view_player_detail = false;
        pCmdUI->Enable(FALSE);	
        pCmdUI->SetCheck(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewStatusDialog() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    if ( m_pLogPlayer->protocolVersion() >= 2 )
    {
        getStatusDialog();
        if ( M_status_dlg_ptr )
        {
            if ( M_status_dlg_ptr->IsWindowVisible() )
            {
                M_status_dlg_ptr->ShowWindow(SW_HIDE);
            }
            else
            {
                if ( M_selected_player > 0 && m_pInfo )
                {
                    M_status_dlg_ptr->setData(M_selected_player,
                                              m_pInfo->pos[M_selected_player - 1],
                                              m_pInfo->ball,
                                              M_reverse_x);
                }
                else
                {
                    M_status_dlg_ptr->reset();
                }
                M_status_dlg_ptr->ShowWindow(SW_SHOW);
                m_pView->SetFocus();
            }
        }
        else
        {
            AfxMessageBox("Cannot create status dialog!");
        }
    }
}

void CSoccermonitorDoc::OnUpdateViewStatusDialog(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	if ( m_pLogPlayer->protocolVersion() >= 2
         && M_view_player_detail )
    {
        pCmdUI->Enable(TRUE);
        if ( M_status_dlg_ptr && M_status_dlg_ptr->IsWindowVisible() )
        {
            pCmdUI->SetCheck(TRUE);
        }
        else
        {
            pCmdUI->SetCheck(FALSE);
        }
    }
    else
    {
            pCmdUI->Enable(FALSE);
    }

}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewBallDetail() 
{
    // TODO: Add your command handler code here
    if ( m_pLogPlayer->protocolVersion() >= 2 )
    {
        M_view_ball_detail = ! M_view_ball_detail;
        getBallDialog();
        if ( M_ball_dlg_ptr )
        {
            if ( M_ball_dlg_ptr->IsWindowVisible() )
            {
                M_ball_dlg_ptr->ShowWindow(SW_HIDE);
            }
            else
            {
                M_ball_dlg_ptr->ShowWindow(SW_SHOW);
                m_pView->SetFocus();
            }
        }
        else
        {
            AfxMessageBox("Cannot create ball dialog!");
        }

        if ( ! m_pLogPlayer->isRunning() )
        {
            RedrawDoc();
        }
    }
}

void CSoccermonitorDoc::OnUpdateBallVel(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
    if ( m_pLogPlayer->protocolVersion() >= 2 )
    {
        pCmdUI->Enable(TRUE);
        if ( M_view_ball_detail
            && M_ball_dlg_ptr
            && M_ball_dlg_ptr->IsWindowVisible() )
        {
            pCmdUI->SetCheck(1);
        }
        else
        {
            M_view_ball_detail = false;
            pCmdUI->SetCheck(0);
        }
    }
    else
    {
        M_view_ball_detail = false;
        pCmdUI->Enable(FALSE);	
        pCmdUI->SetCheck(0);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewPlayerTypeDialog() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    if ( m_pLogPlayer->protocolVersion() >= 2 )
    {
    	getPlayerTypeDialog();
        if ( M_player_type_dlg_ptr )
        {
            if ( M_player_type_dlg_ptr->IsWindowVisible() )
            {
                M_player_type_dlg_ptr->ShowWindow(SW_HIDE);
            }
            else
            {
                selectPlayerType();
                M_player_type_dlg_ptr->ShowWindow(SW_SHOW);
                m_pView->SetFocus();
                
            }
        }
        else
        {
            AfxMessageBox("Cannot create player type dialog!");
        }
    }
}

void CSoccermonitorDoc::OnUpdateViewPlayerTypeDialog(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    if ( m_pLogPlayer->protocolVersion() >= 2 )
    {
        pCmdUI->Enable(TRUE);
        if ( M_player_type_dlg_ptr
             && M_player_type_dlg_ptr->IsWindowVisible() )
        {
            pCmdUI->SetCheck(TRUE);
        }
        else
        {
            pCmdUI->SetCheck(FALSE);
        }
    }
    else
    {
        pCmdUI->Enable(FALSE);	
        pCmdUI->SetCheck(FALSE);
    }	
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewMeasure() 
{
    // TODO: Add your command handler code here
#ifdef USE_MOUSE_RELEASE_FUNC
    if ( ! M_view_measure )
    {
        FocusType current_focus_type = M_focus_type;
        releaseMouseLeft();
        if ( current_focus_type == FOCUS_POINT )
        {
            M_focus_type = FOCUS_AUTO;
        }
        M_view_measure = true;
    }
    else
    {
        M_view_measure = false;
    }

#else
    M_view_measure = ! M_view_measure;
    if ( M_view_measure )
    {
        if ( M_focus_type == FOCUS_POINT )
        {
            M_focus_type = FOCUS_AUTO;
        }
        M_drag_zoom = false;
        M_monitor_move_player = false;
        M_monitor_discard_player = false;
    }
#endif

    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdateViewMeasure(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here
    
    if ( M_view_measure )
    {
        pCmdUI->SetCheck(1);
    }
    else
    {
        pCmdUI->SetCheck(0);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnReverseX() 
{
    // TODO: Add your command handler code here
    M_reverse_x = ! M_reverse_x;
    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }    
}

void CSoccermonitorDoc::OnUpdateReverseX(CCmdUI* pCmdUI) 
{
    // TODO: Add your command update UI handler code here		
    if ( M_reverse_x )
    {
        pCmdUI->SetCheck(1);
    }
    else
    {
        pCmdUI->SetCheck(0);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnSegmentMarkIn()
{
    // TODO: Add your command handler code here
    if ( M_segment_markin_cycle < 0 )
    {
        M_segment_markin_cycle = m_pLogPlayer->getCurrentCycle();
        M_segment_markout_cycle = -1;
    }
    else
    {
        M_segment_markin_cycle = -1;
    }
}

void CSoccermonitorDoc::OnUpdateSegmentMarkIn(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    if ( ! M_connected
         && m_pLogPlayer->hasData() )
    {
        pCmdUI->Enable(TRUE);
        if ( M_segment_markin_cycle >= 0 )
        {
            pCmdUI->SetCheck(1);
        }
        else
        {
            pCmdUI->SetCheck(0);
        }
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnSegmentMarkOut()
{
    // TODO: Add your command handler code here
    M_segment_markout_cycle = m_pLogPlayer->getCurrentCycle();


    CFileDialog getfile(FALSE);

    char title[512];
    strcpy(title, m_pLogPlayer->gameTitle().SpanExcluding(".") + "-segment");
    getfile.m_ofn.lpstrFile = title;
    getfile.m_ofn.lpstrFilter = "RoboCup Game Log(*.rcg)\0*.rcg\0\0";
    getfile.m_ofn.lpstrDefExt = "rcg";
    if ( getfile.DoModal() != IDOK )
    {
        M_segment_markout_cycle = -1;
        return;
    }

    if ( M_segment_markin_cycle >= M_segment_markout_cycle )
    {
        m_pView->MessageBox("Segment start > end", "Error", 
                            MB_ICONERROR | MB_OK);
        M_segment_markin_cycle = M_segment_markout_cycle = -1;
        return;

    }

    BeginWaitCursor(); // vJ[\\܂B
    bool result = m_pLogPlayer->saveSegmentLog(getfile.GetPathName(),
                                               M_segment_markin_cycle,
                                               M_segment_markout_cycle);
    EndWaitCursor(); // vJ[\܂B

    if ( ! result )
    {
        m_pView->MessageBox("Failed to save segment", "Error", 
                            MB_ICONERROR | MB_OK);
    }
    else
    {
        m_pView->MessageBox("Saved successfully!", "", MB_OK);
    }

    M_segment_markin_cycle = M_segment_markout_cycle = -1;

}

void CSoccermonitorDoc::OnUpdateSegmentMarkOut(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    if ( M_segment_markin_cycle >= 0
         && M_segment_markin_cycle < m_pLogPlayer->getCurrentCycle() )
    {
        pCmdUI->Enable(TRUE);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }

}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewPlayerType() 
{
    M_view_player_type = ! M_view_player_type;

    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdateViewPlayerType(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    if ( m_pLogPlayer->protocolVersion() >= 2 )
    {
        pCmdUI->Enable(TRUE);
    	if ( M_view_player_type )
        {
            pCmdUI->SetCheck(1);
        }
        else
        {
            pCmdUI->SetCheck(0);
        }
    }
    else
    {
        pCmdUI->Enable(FALSE);	
        pCmdUI->SetCheck(0);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnChangeFocusType(UINT nID)
{
    FocusType t = (FocusType)(int)(nID - ID_FOCUS_BALL);
    if ( M_focus_type != t )
    {
        if ( t == FOCUS_POINT )
        {
#ifdef USE_MOUSE_RELEASE_FUNC
            releaseMouseLeft();
#else
            M_view_measure = false;
            M_drag_zoom = false;
            M_monitor_move_player = false;
            M_monitor_discard_player = false;
#endif
        }
        M_drag_zoom = false;
        M_focus_type = t;

        if ( ! m_pLogPlayer->isRunning() )
        {
            RedrawDoc();
        }
    }
    else
    {
        M_focus_type = FOCUS_AUTO;
    }
}

void CSoccermonitorDoc::OnUpdateChangeFocusType(CCmdUI *pCmdUI)
{
    pCmdUI->SetCheck((ID_FOCUS_BALL + M_focus_type) == pCmdUI->m_nID ? 1 : 0);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnUnzoom() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ

    M_zoomed = false;
    
    M_focus_type = FOCUS_AUTO;    
    M_focus_point_x = M_focus_point_y = 0.0;

    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnDragZoom() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ

#ifdef USE_MOUSE_RELEASE_FUNC
    if ( ! M_drag_zoom )
    {
        releaseMouseLeft();
        M_drag_zoom = true;
    }
    else
    {
        M_drag_zoom = false;
    }
#else
    M_drag_zoom = ! M_drag_zoom;
    if ( M_drag_zoom )
    {
        M_view_measure = false;
        M_focus_type = FOCUS_AUTO;
        M_monitor_move_player = false;
        M_monitor_discard_player = false;
    }
#endif
}

void CSoccermonitorDoc::OnUpdateDragZoom(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	if ( M_drag_zoom )
    {
        pCmdUI->SetCheck(1);
    }
    else
    {
        pCmdUI->SetCheck(0);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnZoomIn() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ

    zoom(false);
    /*
    M_zoomed = true;

	M_field_scale *= 1.2;
    if ( M_field_scale > S_MAX_FIELD_SCALE )
    {
        M_field_scale = S_MAX_FIELD_SCALE;
    }
    */
    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnZoomOut() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ

    zoom(true);
    /*
	M_zoomed = true;

	M_field_scale /= 1.2;
    if ( M_field_scale < S_MIN_FIELD_SCALE )
    {
        M_field_scale = S_MIN_FIELD_SCALE;
    }
    */
    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnChangeFieldGrassType(UINT nID)
{
    FieldGrassType t = (FieldGrassType)(int)(nID - ID_GRASS_MONO);
    if ( M_field_grass_type != t )
    {
        M_field_grass_type = t;
        if ( ! m_pLogPlayer->isRunning() )
        {
            RedrawDoc();
        }
    }
}

void CSoccermonitorDoc::OnUpdateChangeFieldGrassType(CCmdUI *pCmdUI)
{
    pCmdUI->SetCheck((ID_GRASS_MONO + M_field_grass_type) == pCmdUI->m_nID ? 1 : 0);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewBodyShadow() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    M_view_body_shadow = ! M_view_body_shadow;
    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdateViewBodyShadow(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    pCmdUI->SetCheck(M_view_body_shadow ? 1 : 0);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewEyes() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	M_view_eyes = ! M_view_eyes;
    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdateViewEyes(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    pCmdUI->SetCheck(M_view_eyes ? 1 : 0);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewFlags() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	M_view_flags = ! M_view_flags;
    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdateViewFlags(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    pCmdUI->SetCheck(M_view_flags ? 1 : 0);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewOffsideLine() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    M_view_offside_line = ! M_view_offside_line;
    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdateViewOffsideLine(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    pCmdUI->SetCheck(M_view_offside_line ? 1 : 0);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewPlayerTypeList() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    if ( m_pLogPlayer->protocolVersion() >= 2 )
    {
        getPlayerTypeListDialog();
        if ( M_player_type_list_dlg_ptr )
        {
            if ( M_player_type_list_dlg_ptr->IsWindowVisible() )
            {
                M_player_type_list_dlg_ptr->ShowWindow(SW_HIDE);
            }
            else
            {
                M_player_type_list_dlg_ptr->ShowWindow(SW_SHOW);
                m_pView->SetFocus();
            }
        }
        else
        {
            AfxMessageBox("Cannot create player type list dialog!");
        }
    }
}

void CSoccermonitorDoc::OnUpdateViewPlayerTypeList(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	if ( m_pLogPlayer->numPlayerTypes() == 7 )
    {
        pCmdUI->Enable(TRUE);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewBallLocus() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    if ( M_ball_trace_start_cycle < 0
         && m_pLogPlayer->hasData() )
    {
        M_ball_trace_start_cycle = m_pLogPlayer->getCurrentCycle();
    }
    else
    {
        M_ball_trace_start_cycle = -1;
    }
}

void CSoccermonitorDoc::OnUpdateViewBallLocus(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    if ( m_pLogPlayer->hasData() )
    {
        pCmdUI->Enable(TRUE);
        pCmdUI->SetCheck(M_ball_trace_start_cycle >= 0 ? 1 : 0);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewPlayerLocus() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    if ( M_player_trace_start_cycle < 0 && m_pLogPlayer->hasData() )
    {
        M_player_trace_start_cycle = m_pLogPlayer->getCurrentCycle();
    }
    else
    {
        M_player_trace_start_cycle = -1;
    }	
}

void CSoccermonitorDoc::OnUpdateViewPlayerLocus(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    if ( m_pLogPlayer->hasData() )
    {
        pCmdUI->Enable(TRUE);
        pCmdUI->SetCheck(M_player_trace_start_cycle >= 0 ? 1 : 0);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }	
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnHidePlayer() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    M_view_players = ! M_view_players;
    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdateHidePlayer(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    pCmdUI->SetCheck(M_view_players ? 0 : 1);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnHideBall() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    M_view_ball = ! M_view_ball;
    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdateHideBall(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    if ( ! M_view_ball )
    {
        pCmdUI->SetCheck(1);
    }
    else
    {
        pCmdUI->SetCheck(0);
    }	
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnSaveLogToText() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    SaveLog sDialog;
    sDialog.M_logplayer = m_pLogPlayer;
    sDialog.M_log_count_current = m_pLogPlayer->getCurrentCycle();
    sDialog.M_log_count_max = m_pLogPlayer->getMaxCycle();
    sDialog.M_protocol_version = m_pLogPlayer->protocolVersion();

    sDialog.DoModal();
}

void CSoccermonitorDoc::OnUpdateSaveLogToText(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    if ( ! M_connected
         && m_pLogPlayer->hasData()
         && ! m_pLogPlayer->isRunning() )
    {
        pCmdUI->Enable(TRUE);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnOpenRclFile() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	CFileDialog dlg(TRUE, // t@CJ[h
                    "rcl", // ftHggq
                    NULL, // ftHgt@C
		            OFN_ENABLESIZING | OFN_HIDEREADONLY
                    | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST,
	                "RoboCup Record Log(*.rcl;*.rcl.gz)|*.rcl;*.rcl.gz|All(*.*)|*.*||");

	if ( dlg.DoModal() != IDOK )
    {
        return;
    }
    CGZFile gzfile(dlg.GetPathName());
    if ( gzfile.Good() )
    {
        BYTE header[2];
        gzfile.Read(header, 2);
        if ( header[0] == '0' && header[1] == '\t' )
        {
            gzfile.Rewind();
            m_pLogPlayer->loadRCL(gzfile);
            //m_pView->MessageBox("successfully loaded");
            RedrawDoc();
        }
        else
        {
            AfxMessageBox("rcl file format error!");
        }
    }
}

void CSoccermonitorDoc::OnUpdateOpenRclFile(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    if ( ! M_connected
         && m_pLogPlayer->hasData()
         && ! m_pLogPlayer->isRunning() )
    {
        pCmdUI->Enable(TRUE);
    }
    else
    {
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewSayMessage() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    getCoachMessageDialog();
    if ( M_say_message_dlg_ptr )
    {
        if ( M_say_message_dlg_ptr->IsWindowVisible() )
        {
            M_say_message_dlg_ptr->ShowWindow(SW_HIDE);
        }
        else
        {
            M_say_message_dlg_ptr->ShowWindow(SW_SHOW);
            m_pView->SetFocus();
            M_last_draw_cycle--;
            if ( ! m_pLogPlayer->isRunning() )
            {
                RedrawDoc();
            }
        }
    }
}

void CSoccermonitorDoc::OnUpdateViewSayMessage(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    if ( m_pLogPlayer->hasRCLData() )
    {
        pCmdUI->Enable(TRUE);
        if ( M_say_message_dlg_ptr
             && M_say_message_dlg_ptr->IsWindowVisible() )
        {
            pCmdUI->SetCheck(TRUE);
        }
        else
        {
            pCmdUI->SetCheck(FALSE);
        }
    }
    else
    {
        pCmdUI->SetCheck(FALSE);
        pCmdUI->Enable(FALSE);
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnSelectPlayer(UINT nID) 
{
    int pnum = nID - ID_UNSELECT;
    selectPlayer(pnum);
}

void CSoccermonitorDoc::OnUpdateSelectPlayer(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck(M_selected_player + ID_UNSELECT == pCmdUI->m_nID ? 1 : 0);
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnPlayerAutoSelect() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	M_player_auto_select = ! M_player_auto_select;

    if ( M_player_auto_select )
    {
        M_monitor_move_player = false;
        M_monitor_discard_player = false;
    }

    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdatePlayerAutoSelect(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    pCmdUI->SetCheck(M_player_auto_select ? 1 : 0);
}


//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::zoom(bool out)
{
    M_zoomed = true;
    if ( out )
    {
        M_field_scale /= 1.2;
        if ( M_field_scale < S_MIN_FIELD_SCALE )
        {
            M_field_scale = S_MIN_FIELD_SCALE;
        }
    }
    else
    {
         M_field_scale *= 1.2;
         if ( M_field_scale > S_MAX_FIELD_SCALE )
         {
             M_field_scale = S_MAX_FIELD_SCALE;
         }
    }
}

//////////////////////////////////////////////////////////////////
void CSoccermonitorDoc::OnViewVoronoiDiagram() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	M_view_voronoi_diagram = ! M_view_voronoi_diagram;

    if ( ! m_pLogPlayer->isRunning() )
    {
        RedrawDoc();
    }
}

void CSoccermonitorDoc::OnUpdateViewVoronoiDiagram(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	pCmdUI->SetCheck(M_view_voronoi_diagram ? 1 : 0);
}
