// Soccermonitor.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "Soccermonitor.h"

#include "MainFrm.h"
#include "SoccermonitorDoc.h"
#include "SoccermonitorView.h"

#pragma comment(lib, "version.lib")


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSoccermonitorApp

BEGIN_MESSAGE_MAP(CSoccermonitorApp, CWinApp)
	//{{AFX_MSG_MAP(CSoccermonitorApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSoccermonitorApp construction

CSoccermonitorApp::CSoccermonitorApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CSoccermonitorApp object

CSoccermonitorApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CSoccermonitorApp initialization
char  szInstance[] = {"SoccerWindowInstance"};
//  ̃AvP[VŗL̕

BOOL CSoccermonitorApp::InitInstance()
{
	if ( ! AfxSocketInit() )
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}


    //  OpenMutex ł́AdN邱Ƃ̂ŁAȂNGCg
    //  m_hMutexCFooAppNXHANDLE^oϐƂēo^Ă
    m_hMutex = CreateMutex( FALSE, 0, szInstance );

    if ( ::GetLastError() == ERROR_ALREADY_EXISTS )
    {
        // ɋNĂ
        CloseHandle( m_hMutex );
        return FALSE;
    }


	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// You should modify this string to be something appropriate
	// such as the name of your company or organization.
#if 0
	SetRegistryKey(_T("SoccerWindow"));
#else
    // INI t@Cgꍇ́Aȉ̏s
    free((void *)m_pszProfileName);
    m_pszProfileName = GetIniFileName();
    // Őݒ肵 INI t@Ĉ̓fXgN^ free 
#endif

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CSoccermonitorDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CSoccermonitorView));
	AddDocTemplate(pDocTemplate);


    //  R}hCĂ΂OɃEChȆ傫Zbg
    m_nCmdShow = SW_MAXIMIZE; // CWndNX̃pubNϐ

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if ( ! ProcessShellCommand(cmdInfo) )
    {
		return FALSE;
    }

	// The one and only window has been initialized, so show and update it.
	//m_pMainWnd->SetWindowPos(GetMainWnd(),20,20,200,200,SWP_SHOWWINDOW);
    // ł͍ő剻̗lqĂ܂
    // m_pMainWnd->ShowWindow(SW_SHOWMAXIMIZED);
    m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();

	return TRUE;
}




// =============================================
 // AvP[VCWinApp::GetIniFileName
 // Tv  : AvP[ṼpX INI t@C
 //       : tpXō쐬
 //   : none
 // ߂l: TCHAR *      = INIt@C
 //       :                GetIniFileName()mۂ̃|C^Ԃ
 // =============================================
TCHAR* CSoccermonitorApp::GetIniFileName(void)
{
    TCHAR   drive[_MAX_DRIVE];
    TCHAR   dir[_MAX_DIR];
    TCHAR   fname[_MAX_FNAME];
    TCHAR   buff[_MAX_PATH];

    // ȃAṽpX擾
    GetModuleFileName(m_hInstance, buff, _MAX_PATH);

    WIN32_FIND_DATA wfd;
    HANDLE  h = ::FindFirstFile(buff, &wfd);
    if ( h != NULL )
    {
        _tsplitpath(buff, drive, dir, NULL, NULL);
        _tmakepath(buff, drive, dir, wfd.cFileName, NULL);
        ::FindClose(h);
    }

    _tsplitpath(buff, drive, dir, fname, NULL);
    _tmakepath(buff, drive, dir, fname, _T("ini"));

    return(_tcsdup(buff));
}








/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CSoccermonitorApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CSoccermonitorApp commands

int CSoccermonitorApp::ExitInstance() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	ReleaseMutex(m_hMutex);
    CloseHandle(m_hMutex);

	return CWinApp::ExitInstance();
}

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	

    TCHAR path[MAX_PATH];
    DWORD handle;
    ::GetModuleFileName(AfxGetInstanceHandle(), path, sizeof(path));
    DWORD size = ::GetFileVersionInfoSize(path, &handle);
    CByteArray buf;
    buf.SetSize(size);
    ::GetFileVersionInfo(path, handle, buf.GetSize(), buf.GetData());
    LPVOID item;
    UINT itemsize;
    ::VerQueryValue(buf.GetData(), _T("\\VarFileInfo\\Translation"), &item, &itemsize);
    CString verstr;
    verstr.Format("\\StringFileInfo\\%04X%04X\\",
                  LOWORD(*((LPDWORD)item)),
                  HIWORD(*((LPDWORD)item)));
    ::VerQueryValue(buf.GetData(),
                    (LPTSTR)(LPCTSTR)(verstr + _T("FileDescription")),
                    &item,
                    &itemsize);
    CString name = (LPTSTR)item;
    ::VerQueryValue(buf.GetData(),
                    (LPTSTR)(LPCTSTR)(verstr + _T("FileVersion")),
                    &item,
                    &itemsize);
    CString version = (LPTSTR)item;
    ::VerQueryValue(buf.GetData(),
                    (LPTSTR)(LPCTSTR)(verstr + _T("LegalCopyright")),
                    &item,
                    &itemsize);
    CString copy = (LPTSTR)item;

    SetDlgItemText(IDC_VERSION, name + " Version " + version);
    SetDlgItemText(IDC_COPYRIGHT, copy);


	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CSoccermonitorApp::OnFileOpen() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	CFileDialog dlg(TRUE, // t@CJ[h
                    "rcg", // ftHggq
                    NULL, // ftHgt@C
		            OFN_ENABLESIZING | OFN_HIDEREADONLY
                    | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST,
	                "RoboCup Game Log(*.rcg;*.rcg.gz)|*.rcg;*.rcg.gz|All(*.*)|*.*||");

	if ( dlg.DoModal() != IDOK )
    {
        return;
    }

	CWinApp::OpenDocumentFile(dlg.GetPathName());
}
