// PlayerTypeListDialog.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "soccermonitor.h"
#include "PlayerTypeListDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define WS_EX_LAYERED	0x80000
#define LWA_COLORKEY	1
#define LWA_ALPHA		2
typedef BOOL (WINAPI *SLWA)(HWND, COLORREF, BYTE, DWORD);

/////////////////////////////////////////////////////////////////////////////
// PlayerTypeListDialog _CAO


PlayerTypeListDialog::PlayerTypeListDialog(CWnd* pParent /*=NULL*/)
	: CDialog(PlayerTypeListDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(PlayerTypeListDialog)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT

    M_initialized = false;
}


void PlayerTypeListDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(PlayerTypeListDialog)
	DDX_Control(pDX, IDC_LIST_PLAYER_TYPE, M_player_type_list);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(PlayerTypeListDialog, CDialog)
	//{{AFX_MSG_MAP(PlayerTypeListDialog)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// PlayerTypeListDialog bZ[W nh

void PlayerTypeListDialog::setData(const int idx, const PlayerType &player_type)
{
    CString text;
//    int idx = player_type.id;
    text.Format("%d", player_type.id);
    M_player_type_list.InsertItem(idx, text); // header
    //M_player_type_list.SetItemText(idx, 0, text);

    text.Format("%.4f", player_type.player_speed_max);
    M_player_type_list.SetItemText(idx, 1, text);

    double max_accel = 100.0 * player_type.dash_power_rate * player_type.effort_max;
    double real_speed_max = max_accel / (1.0 - player_type.player_decay);
    if ( real_speed_max > player_type.player_speed_max )
    {
        real_speed_max = player_type.player_speed_max;
    }
    text.Format("%.4f", real_speed_max);
    M_player_type_list.SetItemText(idx, 2, text);

    text.Format("%.3f", player_type.stamina_inc_max);
    M_player_type_list.SetItemText(idx, 3, text);
    text.Format("%.4f", player_type.player_decay);
    M_player_type_list.SetItemText(idx, 4, text);
    text.Format("%.4f", player_type.inertia_moment);
    M_player_type_list.SetItemText(idx, 5, text);
    text.Format("%.5f", player_type.dash_power_rate);
    M_player_type_list.SetItemText(idx, 6, text);
    text.Format("%.4f", player_type.player_size);
    M_player_type_list.SetItemText(idx, 7, text);
    text.Format("%.4f", player_type.kickable_margin);
    M_player_type_list.SetItemText(idx, 8, text);
    text.Format("%.4f", player_type.kick_rand);
    M_player_type_list.SetItemText(idx, 9, text);
    text.Format("%5.2f", player_type.extra_stamina);
    M_player_type_list.SetItemText(idx, 10, text);
    text.Format("%.4f", player_type.effort_max);
    M_player_type_list.SetItemText(idx, 11, text);
    text.Format("%.4f", player_type.effort_min);
    M_player_type_list.SetItemText(idx, 12, text);

    UpdateData(FALSE);
}

void PlayerTypeListDialog::reset()
{
    M_player_type_list.DeleteAllItems();
    UpdateData(FALSE);
}

BOOL PlayerTypeListDialog::OnInitDialog() 
{
    SetWindowStyleLayered();

	CDialog::OnInitDialog();

	const int width = 60;
	// TODO: ̈ʒuɏ̕⑫ǉĂ
    M_player_type_list.InsertColumn(0, _T("id"), LVCFMT_CENTER, 25, 0);
    M_player_type_list.InsertColumn(1, _T("speed_max"), LVCFMT_CENTER, width, 1);
    M_player_type_list.InsertColumn(2, _T("real_speed_max"), LVCFMT_CENTER, width, 1);
    M_player_type_list.InsertColumn(3, _T("stamina_inc_max"), LVCFMT_CENTER, width, 2);
    M_player_type_list.InsertColumn(4, _T("decay"), LVCFMT_CENTER, width, 3);
    M_player_type_list.InsertColumn(5, _T("inertia_moment"), LVCFMT_CENTER, width, 4);
    M_player_type_list.InsertColumn(6, _T("dash_power_rate"), LVCFMT_CENTER, width, 5);
    M_player_type_list.InsertColumn(7, _T("size"), LVCFMT_CENTER, width, 6);
    M_player_type_list.InsertColumn(8, _T("kickable_margin"), LVCFMT_CENTER, width, 7);
    M_player_type_list.InsertColumn(9, _T("kick_rand"), LVCFMT_CENTER, width, 8);
    M_player_type_list.InsertColumn(10, _T("extra_stamina"), LVCFMT_CENTER, width, 9);
    M_player_type_list.InsertColumn(11, _T("effort_max"), LVCFMT_CENTER, width, 10);
    M_player_type_list.InsertColumn(12, _T("effort_min"), LVCFMT_CENTER, width, 11);

    M_initialized = true;

    SetLayeredWindowAttributes(0, 200, LWA_ALPHA);
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}


void PlayerTypeListDialog::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	if ( M_initialized )
    {
        M_player_type_list.MoveWindow(0, 0, cx, cy);
    }
}








BOOL PlayerTypeListDialog::SetWindowStyleLayered()
{
	BOOL ret = FALSE;
	HMODULE hModule = LoadLibrary("user32.dll");
	if ( hModule ) {
		SLWA slwa = (SLWA)GetProcAddress(hModule, "SetLayeredWindowAttributes");
		if ( slwa ) {
			SetWindowLong(GetSafeHwnd(), GWL_EXSTYLE,
				GetWindowLong(GetSafeHwnd(), GWL_EXSTYLE) | WS_EX_LAYERED
				);
			ret = TRUE;
		}
		FreeLibrary(hModule);
	}
	return ret;
}


BOOL PlayerTypeListDialog::WindowStyleLayered()
{
	return ((GetWindowLong(GetSafeHwnd(), GWL_EXSTYLE) & WS_EX_LAYERED) != 0) ? TRUE : FALSE;
}


BOOL PlayerTypeListDialog::SetLayeredWindowAttributes(COLORREF crKey, BYTE bAlpha, DWORD dwFlags)
{
	BOOL ret = FALSE;
	HMODULE hModule = LoadLibrary("user32.dll");
	if ( hModule ) {
		SLWA slwa = (SLWA)GetProcAddress(hModule, "SetLayeredWindowAttributes");
		if ( slwa ) {
			ret = slwa(GetSafeHwnd(), crKey, bAlpha, dwFlags);
		}
		FreeLibrary(hModule);
	}
	return ret;
}
