// MainFrm.cpp : implementation of the CMainFrame class
//

#include <afxpriv.h>        // for CMiniDockFrameWnd

#include "stdafx.h"
#include "Soccermonitor.h"
#include "SoccermonitorDoc.h"
#include "SoccermonitorView.h"
#include "TLogPlayer.h"
#include "TMessageView.h"
#include "TCoachView.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// p
#define WS_EX_LAYERED	0x80000
#define LWA_COLORKEY	1
#define LWA_ALPHA		2
typedef BOOL (WINAPI *SLWA)(HWND, COLORREF, BYTE, DWORD);


/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_TIMER()
	ON_WM_CLOSE()
	ON_COMMAND(ID_VIEW_MONITOR_BAR, OnViewMonitorBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_MONITOR_BAR, OnUpdateViewMonitorBar)
	ON_COMMAND(ID_VIEW_LOGPLAY_BAR, OnViewLogplayBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_LOGPLAY_BAR, OnUpdateViewLogplayBar)
	ON_COMMAND(ID_VIEW_DETAIL_BAR, OnViewDetailBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_DETAIL_BAR, OnUpdateViewDetailBar)
	ON_COMMAND(ID_VIEW_ZOOM_BAR, OnViewZoomBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ZOOM_BAR, OnUpdateViewZoomBar)
	ON_COMMAND(ID_VIEW_COACH_BAR, OnViewCoachBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_COACH_BAR, OnUpdateViewCoachBar)
	ON_COMMAND(ID_VIEW_SAVE_BAR, OnViewSaveBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SAVE_BAR, OnUpdateViewSaveBar)
	ON_COMMAND(ID_VIEW_ANALYSIS_BAR, OnViewAnalysisBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ANALYSIS_BAR, OnUpdateViewAnalysisBar)
	//}}AFX_MSG_MAP
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_VERSION, OnUpdateVersion)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_GAME, OnUpdateGame)
    ON_CBN_SELCHANGE(ID_UNSELECT, OnSelSelectPlayer)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
    IDS_MOUSE_COORD,
	//ID_INDICATOR_VERSION,
	//ID_INDICATOR_GAME,
	//ID_INDICATOR_CAPS,
	//ID_INDICATOR_NUM,
	//ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    //SetWindowStyleLayered(GetSafeHwnd());

	if ( CFrameWnd::OnCreate(lpCreateStruct) == -1 )
    {
		return -1;
    }
	
    DWORD bar_style = WS_CHILD | WS_VISIBLE
                      | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC | CBRS_GRIPPER;
    if ( ! m_wndToolBar.CreateEx(this, TBSTYLE_FLAT,
                                 bar_style | CBRS_TOP, CRect(0,0,0,0), IDW_MAIN_BAR)
        || ! m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

    // R[hn܂
    if ( ! m_wndLogPlayBar.CreateEx(this, TBSTYLE_FLAT,
                                    bar_style | CBRS_TOP, CRect(0,0,0,0), IDW_LOGPLAY_BAR)
         || ! m_wndLogPlayBar.LoadToolBar(IDR_LOGPLAY_TOOLBAR) )
    {
        TRACE0("Failed to create logplayer tool bar\n");
        return -1;
    }
    
    if ( ! m_wndDetailBar.CreateEx(this, TBSTYLE_FLAT,
                                   bar_style | CBRS_BOTTOM, CRect(0,0,0,0), IDW_DETAIL_BAR)
         || ! m_wndDetailBar.LoadToolBar(IDR_DETAIL_TOOLBAR) )
    {
        TRACE0("Failed to create detail tool bar\n");
        return -1;
    }
    // vC[ZNg̃R{{bNX쐬Jn
    {
        int width = 140;
        int height = 300;
        int select_id = m_wndDetailBar.CommandToIndex(ID_UNSELECT) + 1;
        m_wndDetailBar.SetButtonInfo(select_id, ID_UNSELECT, TBBS_SEPARATOR, width);
        CRect combo_rect;
        m_wndDetailBar.GetItemRect(select_id, &combo_rect);
        combo_rect.bottom = combo_rect.top + height;
        m_ctlSelectPlayer.Create(WS_CHILD | WS_VISIBLE | WS_VSCROLL | CBS_DROPDOWNLIST,
                                 combo_rect, &m_wndDetailBar, ID_UNSELECT);
        CString str_style;
        if ( str_style.LoadString(IDS_UNSELECT_PLAYER) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_LEFT_1) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_LEFT_2) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_LEFT_3) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_LEFT_4) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_LEFT_5) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_LEFT_6) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_LEFT_7) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_LEFT_8) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_LEFT_9) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_LEFT_10) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_LEFT_11) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_RIGHT_1) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_RIGHT_2) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_RIGHT_3) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_RIGHT_4) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_RIGHT_5) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_RIGHT_6) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_RIGHT_7) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_RIGHT_8) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_RIGHT_9) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_RIGHT_10) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
        if ( str_style.LoadString(ID_SELECT_PLAYER_RIGHT_11) ) m_ctlSelectPlayer.AddString((LPCTSTR)str_style);
    }
    // R{{bNX쐬I

    if ( ! m_wndZoomBar.CreateEx(this, TBSTYLE_FLAT,
                                 bar_style | CBRS_BOTTOM, CRect(0,0,0,0), IDW_ZOOM_BAR)
         || ! m_wndZoomBar.LoadToolBar(IDR_ZOOM_TOOLBAR) )
    {
        TRACE0("Failed to create zoom tool bar\n");
        return -1;
    }

    if ( ! m_wndCoachBar.CreateEx(this, TBSTYLE_FLAT,
                                  bar_style | CBRS_RIGHT, CRect(0,0,0,0), IDW_COACH_BAR)
         || ! m_wndCoachBar.LoadToolBar(IDR_COACH_TOOLBAR) )
    {
        TRACE0("Failed to create coach tool bar\n");
        return -1;
    }

    if ( ! m_wndSaveBar.CreateEx(this, TBSTYLE_FLAT,
                                 bar_style | CBRS_TOP, CRect(0,0,0,0), IDW_SAVE_BAR)
         || ! m_wndSaveBar.LoadToolBar(IDR_SAVE_TOOLBAR) )
    {
        TRACE0("Failed to create save tool bar\n");
        return -1;
    }

    if ( ! m_wndAnalysisBar.CreateEx(this, TBSTYLE_FLAT,
                                     bar_style | CBRS_TOP, CRect(0,0,0,0), IDW_ANALYSIS_BAR)
         || ! m_wndAnalysisBar.LoadToolBar(IDR_ANALYSIS_TOOLBAR) )
    {
        TRACE0("Failed to create analysis tool bar\n");
        return -1;
    }
    // R[hI

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		                              sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Remove this if you don't want tool tips or a resizeable toolbar
	//m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle()
    //               );

    // Xe[^Xo[̉
    //ShowControlBar( &m_wndStatusBar, TRUE, FALSE );

    // Cӂ̕ӂւ̃hbLŐ
    EnableDocking(CBRS_ALIGN_ANY);


	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
    m_wndToolBar.SetWindowText(_T("SoccerMonitor"));
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);//CBRS_ALIGN_TOP | CBRS_ALIGN_BOTTOM);

    // R[hn܂
    m_wndLogPlayBar.SetWindowText(_T("LogPlayer"));
    m_wndLogPlayBar.EnableDocking(CBRS_ALIGN_ANY);//(CBRS_ALIGN_TOP | CBRS_ALIGN_BOTTOM);
    m_wndDetailBar.SetWindowText(_T("Detail"));
    m_wndDetailBar.EnableDocking(CBRS_ALIGN_ANY);//(CBRS_ALIGN_TOP | CBRS_ALIGN_BOTTOM);
    m_wndZoomBar.SetWindowText(_T("Zoom"));
    m_wndZoomBar.EnableDocking(CBRS_ALIGN_ANY);//(CBRS_ALIGN_TOP | CBRS_ALIGN_BOTTOM);
    m_wndCoachBar.SetWindowText(_T("Trainer"));
    m_wndCoachBar.EnableDocking(CBRS_ALIGN_ANY);//(CBRS_ALIGN_TOP | CBRS_ALIGN_BOTTOM);
    m_wndSaveBar.SetWindowText(_T("Save"));
    m_wndSaveBar.EnableDocking(CBRS_ALIGN_ANY);//(CBRS_ALIGN_TOP | CBRS_ALIGN_BOTTOM);
    m_wndAnalysisBar.SetWindowText(_T("Analysis"));
    m_wndAnalysisBar.EnableDocking(CBRS_ALIGN_ANY);//(CBRS_ALIGN_TOP | CBRS_ALIGN_BOTTOM);
    // R[hI

	DockControlBar(&m_wndToolBar);
    // R[hn܂
	DockControlBar(&m_wndToolBar, AFX_IDW_DOCKBAR_TOP);
	DockControlBarLeftOf(&m_wndLogPlayBar, &m_wndToolBar);
	DockControlBarLeftOf(&m_wndSaveBar, &m_wndLogPlayBar);

	DockControlBar(&m_wndDetailBar, AFX_IDW_DOCKBAR_BOTTOM);
	DockControlBarLeftOf(&m_wndAnalysisBar, &m_wndDetailBar);
	DockControlBarLeftOf(&m_wndZoomBar, &m_wndAnalysisBar);
   	DockControlBarLeftOf(&m_wndCoachBar, &m_wndZoomBar);
    //DockControlBar(&m_wndCoachBar, AFX_IDW_DOCKBAR_RIGHT);

    // hide
    ShowControlBar(&m_wndCoachBar, FALSE, FALSE);
    //ShowControlBar(&m_wndSaveBar, FALSE, FALSE);
    // R[hI


    // _CAO o[
    /*
    if ( ! m_wndBallDialogBar.Create(this, IDD_BALL_DIALOGBAR,
                                     CBRS_RIGHT | CBRS_TOOLTIPS | CBRS_FLYBY,
                                     IDW_BALL_DLG_BAR) )
    {
        return -1;		// 쐬Ɏs
    }
    */
    /*
    if ( ! m_wndStatusDialogBar.Create(this, IDD_STATUS_DIALOGBAR,
                                       CBRS_RIGHT | CBRS_TOOLTIPS | CBRS_FLYBY,
                                       IDW_STATUS_DLG_BAR) )
    {
        return -1;		// 쐬Ɏs
    }
    */
    /*
    if ( ! m_wndPlayerTypeDialogBar.Create(this, IDD_PLAYER_TYPE_DIALOGBAR,
                                           CBRS_RIGHT | CBRS_TOOLTIPS | CBRS_FLYBY,
                                           IDW_PLAYER_TYPE_DLG_BAR) )
    {
        return -1;		// 쐬Ɏs
    }
    */
    //m_wndBallDialogBar.EnableDocking(CBRS_ALIGN_LEFT | CBRS_ALIGN_RIGHT);
    //m_wndBallDialogBar.SetWindowText(_T("Ball Status"));
    //m_wndStatusDialogBar.EnableDocking(CBRS_ALIGN_LEFT | CBRS_ALIGN_RIGHT);
    //m_wndStatusDialogBar.SetWindowText(_T("Player Status"));
    //m_wndPlayerTypeDialogBar.EnableDocking(CBRS_ALIGN_LEFT | CBRS_ALIGN_RIGHT);
    //m_wndPlayerTypeDialogBar.SetWindowText(_T("Player Type"));

    //DockControlBar(&m_wndBallDialogBar, AFX_IDW_DOCKBAR_RIGHT);
    //DockControlBar(&m_wndStatusDialogBar, AFX_IDW_DOCKBAR_RIGHT);
    //DockControlBar(&m_wndPlayerTypeDialogBar, AFX_IDW_DOCKBAR_RIGHT);

    // Öʒu̕
    LoadBarState(theApp.m_pszProfileName);

    // _CAOo[͏ɔ
    //ShowControlBar( &m_wndBallDialogBar, FALSE, FALSE );
    //ShowControlBar( &m_wndStatusDialogBar, FALSE, FALSE );
    //ShowControlBar( &m_wndPlayerTypeDialogBar, FALSE, FALSE );


    M_view_tool_bar = m_wndToolBar.IsWindowVisible() ? true : false;
    M_view_logplay_bar = m_wndLogPlayBar.IsWindowVisible() ? true : false;
    M_view_detail_bar = m_wndDetailBar.IsWindowVisible() ? true : false;
    M_view_zoom_bar = m_wndZoomBar.IsWindowVisible() ? true : false;
    M_view_coach_bar = m_wndCoachBar.IsWindowVisible() ? true : false;
    M_view_save_bar = m_wndSaveBar.IsWindowVisible() ? true : false;
    M_view_analysis_bar = m_wndAnalysisBar.IsWindowVisible() ? true : false;


    //M_view_ball_dialog_bar
    //    = m_wndBallDialogBar.IsWindowVisible() ? true : false;
    //M_view_status_dialog_bar
    //    = m_wndStatusDialogBar.IsWindowVisible() ? true : false;
    //M_view_player_type_dialog_bar
    //    = m_wndPlayerTypeDialogBar.IsWindowVisible() ? true : false;

    // hide menu
    SetMenu(NULL);

    //SetLayeredWindowAttributes(GetSafeHwnd(), 0/**/, 192, LWA_ALPHA);
    return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	cs.style = WS_OVERLAPPED | WS_SYSMENU | WS_BORDER
               | WS_MINIMIZEBOX | WS_MAXIMIZEBOX
               | WS_MAXIMIZE|WS_THICKFRAME;
	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG






BOOL CMainFrame::SetWindowStyleLayered(HWND hwnd)
{
	BOOL ret = FALSE;
	HMODULE hModule = LoadLibrary("user32.dll");
	if ( hModule ) {
		SLWA slwa = (SLWA)GetProcAddress(hModule, "SetLayeredWindowAttributes");
		if ( slwa ) {
            SetWindowLong(hwnd, GWL_EXSTYLE,
				GetWindowLong(hwnd, GWL_EXSTYLE) | WS_EX_LAYERED
				);
			ret = TRUE;
		}
		FreeLibrary(hModule);
    }
	return ret;
}

BOOL CMainFrame::WindowStyleLayered(HWND hwnd)
{
	return ((GetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_LAYERED) != 0) ? TRUE : FALSE;
}

BOOL CMainFrame::SetLayeredWindowAttributes(HWND hwnd, COLORREF crKey, BYTE bAlpha, DWORD dwFlags)
{
	BOOL ret = FALSE;
	HMODULE hModule = LoadLibrary("user32.dll");
	if ( hModule ) {
		SLWA slwa = (SLWA)GetProcAddress(hModule, "SetLayeredWindowAttributes");
		if ( slwa ) {
			ret = slwa(hwnd, crKey, bAlpha, dwFlags);
		}
		FreeLibrary(hModule);
	}
	return ret;
}












/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
BOOL CMainFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
#if 1
	return CFrameWnd::OnCreateClient(lpcs, pContext);
#else
	if ( ! m_wndSplitter.CreateStatic(this, 2, 1) )
    {
		return FALSE;
    }
	if ( ! m_wndSplitter2.CreateStatic(&m_wndSplitter, 1, 2,
                                       WS_CHILD | WS_VISIBLE | WS_BORDER,
                                       m_wndSplitter.IdFromRowCol(1, 0)) )
    {
		return FALSE;
    }

    CRect rect;
    CSize size;
	GetClientRect(&rect);
	size = rect.Size();
	
    int sviewrate = 3, mviewrate = 1;

	size.cy *= sviewrate;
    size.cy /= sviewrate + mviewrate;
	// view for the field
	if ( ! m_wndSplitter.CreateView(0, 0, RUNTIME_CLASS(CSoccermonitorView),
                                    size, pContext) )
    {
		return FALSE;
    }
	
	// Message
    size.cy /= sviewrate;
    size.cy *= mviewrate;
	size.cx /= 2;
	if ( ! m_wndSplitter2.CreateView(0, 0, RUNTIME_CLASS(TMessageView),
                                     size, pContext) )
    {
		return FALSE;
    }
	if ( ! m_wndSplitter2.CreateView(0, 1, RUNTIME_CLASS(TCoachView),
                                     size, pContext) )
    {
		return FALSE;
    }
	
	SetActiveView((CView*)m_wndSplitter.GetPane(0, 0));
	return TRUE;
#endif
}


void CMainFrame::DockControlBarLeftOf(CToolBar* Bar, CToolBar* LeftOf)
{
	CRect rect;
	DWORD dw;
	UINT n;

	// MFC ɂׂẴhbLOc[ o[̐@𒲐
	// GetWindowRect ͐ݒ肵܂B
	RecalcLayout();
	LeftOf->GetWindowRect(&rect);
	rect.OffsetRect(1, 0);
	dw = LeftOf->GetBarStyle();
	n = 0;
	n = (dw & CBRS_ALIGN_TOP) ? AFX_IDW_DOCKBAR_TOP : n;
	n = (dw & CBRS_ALIGN_BOTTOM && n == 0) ? AFX_IDW_DOCKBAR_BOTTOM : n;
	n = (dw & CBRS_ALIGN_LEFT && n == 0) ? AFX_IDW_DOCKBAR_LEFT : n;
	n = (dw & CBRS_ALIGN_RIGHT && n == 0) ? AFX_IDW_DOCKBAR_RIGHT : n;

	// ftHg̃p[^ rect łƂꍇADockControlBar ͕ʁX̃C
	// Ɋec[ o[hbLO܂B`̌vZɂāAc[ o[
	// ʒuɃhbOăhbLÔۂɃV~[gĂ܂B
	DockControlBar(Bar, n, &rect);
}



void CMainFrame::OnUpdateVersion(CCmdUI *pCmdUI)
{
	pCmdUI->SetText("");
}

void CMainFrame::OnUpdateGame(CCmdUI *pCmdUI)
{
	pCmdUI->SetText("");
}

void CMainFrame::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	CFrameWnd::OnTimer(nIDEvent);
}

void CMainFrame::OnClose() 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ

    
    SaveBarState(theApp.m_pszProfileName);

	CFrameWnd::OnClose();
}

void CMainFrame::OnViewMonitorBar() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    M_view_tool_bar = ! M_view_tool_bar;
    ShowControlBar(&m_wndToolBar, M_view_tool_bar, FALSE);
    RecalcLayout();
}

void CMainFrame::OnUpdateViewMonitorBar(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    M_view_tool_bar = m_wndToolBar.IsWindowVisible() ? true : false;
    pCmdUI->SetCheck(M_view_tool_bar ? 1 : 0);
}

void CMainFrame::OnViewLogplayBar() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    M_view_logplay_bar = ! M_view_logplay_bar;
    ShowControlBar(&m_wndLogPlayBar, M_view_logplay_bar, FALSE);
    RecalcLayout();
}

void CMainFrame::OnUpdateViewLogplayBar(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    M_view_logplay_bar = m_wndLogPlayBar.IsWindowVisible() ? true : false;
    pCmdUI->SetCheck(M_view_logplay_bar ? 1 : 0);
}

void CMainFrame::OnViewDetailBar() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    M_view_detail_bar = ! M_view_detail_bar;
    ShowControlBar(&m_wndDetailBar, M_view_detail_bar, FALSE);
    RecalcLayout();
}

void CMainFrame::OnUpdateViewDetailBar(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    M_view_detail_bar = m_wndDetailBar.IsWindowVisible() ? true : false;
    pCmdUI->SetCheck(M_view_detail_bar ? 1 : 0);
}

void CMainFrame::OnViewZoomBar() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    M_view_zoom_bar = ! M_view_zoom_bar;
    ShowControlBar(&m_wndZoomBar, M_view_zoom_bar, FALSE);
    RecalcLayout();
}

void CMainFrame::OnUpdateViewZoomBar(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    M_view_zoom_bar = m_wndZoomBar.IsWindowVisible() ? true : false;
    pCmdUI->SetCheck(M_view_zoom_bar ? 1 : 0);
}

void CMainFrame::OnViewCoachBar() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    M_view_coach_bar = ! M_view_coach_bar;
    ShowControlBar(&m_wndCoachBar, M_view_coach_bar, FALSE);
    RecalcLayout();
}

void CMainFrame::OnUpdateViewCoachBar(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    M_view_coach_bar = m_wndCoachBar.IsWindowVisible() ? true : false;
    pCmdUI->SetCheck(M_view_coach_bar ? 1 : 0);
}

void CMainFrame::OnViewSaveBar() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    M_view_save_bar = ! M_view_save_bar;
    ShowControlBar(&m_wndSaveBar, M_view_save_bar, FALSE);
    RecalcLayout();
}

void CMainFrame::OnUpdateViewSaveBar(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    M_view_save_bar = m_wndSaveBar.IsWindowVisible() ? true : false;
    pCmdUI->SetCheck(M_view_save_bar ? 1 : 0);
}

void CMainFrame::OnViewAnalysisBar() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
    M_view_analysis_bar = ! M_view_analysis_bar;
    ShowControlBar(&m_wndAnalysisBar, M_view_analysis_bar, FALSE);
    RecalcLayout();
}

void CMainFrame::OnUpdateViewAnalysisBar(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
    M_view_analysis_bar = m_wndAnalysisBar.IsWindowVisible() ? true : false;
    pCmdUI->SetCheck(M_view_analysis_bar ? 1 : 0);	
}

void CMainFrame::OnSelSelectPlayer()
{
    int idx = m_ctlSelectPlayer.GetCurSel();
    if ( idx == CB_ERR )
    {
        return;
    }

    CSoccermonitorDoc* pDoc = (CSoccermonitorDoc*)GetActiveDocument();
    if ( pDoc )
    {
        pDoc->selectPlayer(idx);
    }
}

void CMainFrame::updateSelectPlayerComboBox(const int idx)
{
    m_ctlSelectPlayer.SetCurSel(idx);
}
