// oachMessageDialog.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "soccermonitor.h"
#include "CoachMessageDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define WS_EX_LAYERED	0x80000
#define LWA_COLORKEY	1
#define LWA_ALPHA		2
typedef BOOL (WINAPI *SLWA)(HWND, COLORREF, BYTE, DWORD);


/////////////////////////////////////////////////////////////////////////////
// CoachMessageDialog _CAO


CoachMessageDialog::CoachMessageDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CoachMessageDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CoachMessageDialog)
	M_print_player_say = TRUE;
	M_print_coach_say = TRUE;
	//}}AFX_DATA_INIT

    M_initialized = false;
}


void CoachMessageDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CoachMessageDialog)
	DDX_Control(pDX, IDC_COACH_MESSAGE, M_ctrl_coach_message);
	DDX_Check(pDX, IDC_CHECK_PLAYER_SAY, M_print_player_say);
	DDX_Check(pDX, IDC_CHECK_COACH_SAY, M_print_coach_say);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CoachMessageDialog, CDialog)
	//{{AFX_MSG_MAP(CoachMessageDialog)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_CHECK_PLAYER_SAY, OnCheckPlayerSay)
	ON_BN_CLICKED(IDC_CHECK_COACH_SAY, OnCheckCoachSay)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CoachMessageDialog bZ[W nh

BOOL CoachMessageDialog::OnInitDialog() 
{
    SetWindowStyleLayered();

	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	
    M_initialized = true;

    SetLayeredWindowAttributes(0, 200, LWA_ALPHA);
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CoachMessageDialog::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	if ( M_initialized )
    {
        M_ctrl_coach_message.MoveWindow(0, 28, cx, cy - 28);
    }
}






BOOL CoachMessageDialog::SetWindowStyleLayered()
{
	BOOL ret = FALSE;
	HMODULE hModule = LoadLibrary("user32.dll");
	if ( hModule ) {
		SLWA slwa = (SLWA)GetProcAddress(hModule, "SetLayeredWindowAttributes");
		if ( slwa ) {
			SetWindowLong(GetSafeHwnd(), GWL_EXSTYLE,
				GetWindowLong(GetSafeHwnd(), GWL_EXSTYLE) | WS_EX_LAYERED
				);
			ret = TRUE;
		}
		FreeLibrary(hModule);
	}
	return ret;
}


BOOL CoachMessageDialog::WindowStyleLayered()
{
	return ((GetWindowLong(GetSafeHwnd(), GWL_EXSTYLE) & WS_EX_LAYERED) != 0) ? TRUE : FALSE;
}


BOOL CoachMessageDialog::SetLayeredWindowAttributes(COLORREF crKey, BYTE bAlpha, DWORD dwFlags)
{
	BOOL ret = FALSE;
	HMODULE hModule = LoadLibrary("user32.dll");
	if ( hModule ) {
		SLWA slwa = (SLWA)GetProcAddress(hModule, "SetLayeredWindowAttributes");
		if ( slwa ) {
			ret = slwa(GetSafeHwnd(), crKey, bAlpha, dwFlags);
		}
		FreeLibrary(hModule);
	}
	return ret;
}


void CoachMessageDialog::OnCheckPlayerSay() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	M_print_player_say = ! M_print_player_say;
    UpdateData(TRUE);	
}

void CoachMessageDialog::OnCheckCoachSay() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	M_print_coach_say = ! M_print_coach_say;
    UpdateData(TRUE);
}
