// BallStatusDialog.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "soccermonitor.h"
#include "BallStatusDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



#define WS_EX_LAYERED	0x80000
#define LWA_COLORKEY	1
#define LWA_ALPHA		2
typedef BOOL (WINAPI *SLWA)(HWND, COLORREF, BYTE, DWORD);



/////////////////////////////////////////////////////////////////////////////
// BallStatusDialog _CAO


BallStatusDialog::BallStatusDialog(CWnd* pParent /*=NULL*/)
	: CDialog(BallStatusDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(BallStatusDialog)
	M_pos = _T("");
	M_vel = _T("");
	M_vel_r = _T("");
	M_vel_th = _T("");
	M_acc = _T("");
	M_acc_r = _T("");
	M_acc_th = _T("");
	M_last_vel = _T("");
	M_last_vel_r = _T("");
	M_last_vel_th = _T("");
	M_future_cyc = 1;
	//}}AFX_DATA_INIT
}


void BallStatusDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(BallStatusDialog)
	DDX_Text(pDX, IDC_BALL_POS, M_pos);
	DDV_MaxChars(pDX, M_pos, 16);
	DDX_Text(pDX, IDC_BALL_VEL, M_vel);
	DDV_MaxChars(pDX, M_vel, 16);
	DDX_Text(pDX, IDC_BALL_VEL_R, M_vel_r);
	DDV_MaxChars(pDX, M_vel_r, 8);
	DDX_Text(pDX, IDC_BALL_VEL_TH, M_vel_th);
	DDV_MaxChars(pDX, M_vel_th, 8);
	DDX_Text(pDX, IDC_BALL_ACCEL, M_acc);
	DDV_MaxChars(pDX, M_acc, 16);
	DDX_Text(pDX, IDC_BALL_ACCEL_R, M_acc_r);
	DDV_MaxChars(pDX, M_acc_r, 8);
	DDX_Text(pDX, IDC_BALL_ACCEL_TH, M_acc_th);
	DDV_MaxChars(pDX, M_acc_th, 8);
	DDX_Text(pDX, IDC_BALL_LAST_VEL, M_last_vel);
	DDV_MaxChars(pDX, M_last_vel, 16);
	DDX_Text(pDX, IDC_BALL_LAST_VEL_R, M_last_vel_r);
	DDV_MaxChars(pDX, M_last_vel_r, 6);
	DDX_Text(pDX, IDC_BALL_LAST_VEL_TH, M_last_vel_th);
	DDV_MaxChars(pDX, M_last_vel_th, 6);
	DDX_Text(pDX, IDC_BALL_FUTURE_CYC, M_future_cyc);
	DDV_MinMaxInt(pDX, M_future_cyc, 0, 200);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(BallStatusDialog, CDialog)
	//{{AFX_MSG_MAP(BallStatusDialog)
	ON_EN_CHANGE(IDC_BALL_FUTURE_CYC, OnChangeBallFutureCyc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// BallStatusDialog bZ[W nh



BOOL BallStatusDialog::SetWindowStyleLayered()
{
	BOOL ret = FALSE;
	HMODULE hModule = LoadLibrary("user32.dll");
	if ( hModule ) {
		SLWA slwa = (SLWA)GetProcAddress(hModule, "SetLayeredWindowAttributes");
		if ( slwa ) {
			SetWindowLong(GetSafeHwnd(), GWL_EXSTYLE,
				GetWindowLong(GetSafeHwnd(), GWL_EXSTYLE) | WS_EX_LAYERED
				);
			ret = TRUE;
		}
		FreeLibrary(hModule);
	}
	return ret;
}


BOOL BallStatusDialog::WindowStyleLayered()
{
	return ((GetWindowLong(GetSafeHwnd(), GWL_EXSTYLE) & WS_EX_LAYERED) != 0) ? TRUE : FALSE;
}


BOOL BallStatusDialog::SetLayeredWindowAttributes(COLORREF crKey, BYTE bAlpha, DWORD dwFlags)
{
	BOOL ret = FALSE;
	HMODULE hModule = LoadLibrary("user32.dll");
	if ( hModule ) {
		SLWA slwa = (SLWA)GetProcAddress(hModule, "SetLayeredWindowAttributes");
		if ( slwa ) {
			ret = slwa(GetSafeHwnd(), crKey, bAlpha, dwFlags);
		}
		FreeLibrary(hModule);
	}
	return ret;
}



BOOL BallStatusDialog::OnInitDialog()
{
    SetWindowStyleLayered();

	CDialog::OnInitDialog();


    SetLayeredWindowAttributes(0, 160, LWA_ALPHA);
	return TRUE;
}

void BallStatusDialog::OnChangeBallFutureCyc() 
{
	// TODO: ꂪ RICHEDIT Rg[̏ꍇARg[́A lParam }XN
	// ł̘_a ENM_CHANGE tOt CRichEditCrtl().SetEventMask()
	// bZ[WRg[֑邽߂ CDialog::OnInitDialog() ֐I[o[
	// ChȂ肱̒ʒm𑗂܂B
	
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData(TRUE);
}
