package org.util.xml.renderer.html;

import org.util.xml.parse.policy.*;
import org.util.xml.parse.*;
import org.util.xml.element.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import java.awt.font.*;
import java.awt.image.*;
import java.net.*;

public class HTMLImage extends HTMLObject {

	BufferedImage image_;

	public HTMLImage(TagElement tag) {
		String url_text = tag.getAttributeValue("src");
		URI uri = tag.getDocumentBase().resolve(url_text);
//		alert("img :"+url_text);
		try{
			image_ = javax.imageio.ImageIO.read(uri.toURL());
			setPreferredSize(image_.getWidth(), image_.getHeight());
			setPreferredLocation(0,0);
		}catch(Exception e){
			image_ = new BufferedImage(100, 100, BufferedImage.TYPE_INT_ARGB);
			Graphics g = image_.getGraphics();
			g.drawLine(0,99,99,0);
			g.drawLine(0,0,99,99);
			e.printStackTrace();
		}
	}

	public void paint(Graphics g) {
		debug("draw start");
		debug(preferred_width_+"");
		g.drawImage(image_, (int)x_, (int)y_, null);
		debug("draw end");
	}
	
	public Element allowElement(Element element) {
		if(element.isTagElement()) {
			TagElement tag = (TagElement)element;
			if(tag.getKey().equals("img")) {
				write(new HTMLImage(tag));
			} else {
				System.out.println("tag["+tag+"]");
			}
		} else {
			TextElement text_element = (TextElement)element;
//			System.out.println("text["+element+"]");
			html_text = text_element.getValue();
		}
		return element;
	}

}
