/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.parse;

import org.util.xml.element.Attribute;
import org.util.xml.parse.ElementParser;
import java.io.IOException;

/**
 *
 * @author masaru
 */
public class AttributeParser extends ParseElement {

    private NameParser name_parser_;
    private EqParser eq_parser_;
    private AttValueParser attvalue_parser_;
    private SpaceParser space_parser_;
    private Attribute attribute_;
    
    public AttributeParser() {
        name_parser_ = new NameParser();
        eq_parser_ = new EqParser();
        attvalue_parser_ = new AttValueParser();
        space_parser_ = new SpaceParser();
    }
    public boolean match(char c) {
        return name_parser_.allow(c);
    }

    public int parse(int next, ElementParser parser) throws XMLParseException, IOException {
        String name = null, value = null;
        
        if(next==-1) throw new XMLParseException("end of line");
        next = name_parser_.parse((char)next, parser);
        name = name_parser_.getReturnValue();

        if(next==-1) throw new XMLParseException("end of line");
        
//        next = eq_parser_.parse((char)next, parser);

//        System.out.print("<"+name+":"+(char)next);
        if(space_parser_.match((char)next))
            next = space_parser_.parse(next, parser);

        if(next==-1) throw new XMLParseException("end of line");
        
        if(next=='=') {
            next = parser.getChar();
            if(space_parser_.match((char)next))
                next = space_parser_.parse(next, parser);
            if(next==-1) throw new XMLParseException("end of line");
            next = attvalue_parser_.parse(next, parser);
            value = attvalue_parser_.getReturnValue();
            attribute_ = new Attribute(name, value);
        } else {
            attribute_ = new Attribute(name, "");
            attribute_.setNoValue(true);
        }
            
//        System.out.println((char)next+">");

        
        return next;
    }
    public Attribute getAttribute() {
        return attribute_;
    }
}
