package org.util.resource;

import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import java.awt.image.*;
import javax.imageio.*;

import org.util.env.LaunchInformation;

public class ResourceManager {

    private static BufferedImage error_image_;
    private static ResourceManager rm_;

    public static Image getImage(String path, int w, int h) {
	URL url = findResource(path);
	if(url!=null) {
	    Image image = null;
	    try{
		image = javax.imageio.ImageIO.read(url);
		if(image.getWidth(null)!=w || image.getHeight(null)!=h) {
		    int hints = Image.SCALE_FAST;
		    image = image.getScaledInstance(w, h, hints);
		}
	    }catch(Exception exc){}
	    if(image!=null)
		return image;
	}
	return getErrorImage(w, h);
    }

    public static Image getImage(String path) {
	URL url = findResource(path);
	if(url!=null) {
	    Image image = null;
	    try{
		image = javax.imageio.ImageIO.read(url);
	    }catch(Exception exc){}
	    if(image!=null)
		return image;
	}
	return getErrorImage(50, 50);
    }

    public static URL findResource(String path) {

	File file = new File(path);
	URL url = null;
	if(file.exists()) {
	    try{
		url = file.toURI().toURL();
	    }catch(Exception exc) {}
	    if(url!=null)
		return url;
	}
	
	try{
	    url = LaunchInformation.createJarURL(path);
	}catch(Exception exc) {}

	if(url==null) System.err.println("cannot find resource: "+url);

	return url;
	//return ClassLoader.getSystemResource(path);
    }

    public static Image getErrorImage(int w, int h) {
	if(error_image_ == null) {
	    error_image_ = new BufferedImage(w, h, BufferedImage.TYPE_INT_ARGB);
	    Graphics2D g = (Graphics2D)error_image_.getGraphics();
	    g.setColor(Color.red);
	    g.drawRect(0,0,w-1,h-1);
	    g.drawLine(1,1,20,20);
	    g.drawLine(1,20,20,1);
	}
	return error_image_;
    }
    
}
