package libsvm.wrapper;

import libsvm.svm_parameter;

/**
 * SVMの種類
 *
 * @author hirai
 */
public enum SvmType {

	/**
	 * C-SVMクラス分類器
	 */
	C_SVC(svm_parameter.C_SVC),

	/**
	 * nu-SVMクラス分類器
	 */
	NU_SVC(svm_parameter.NU_SVC),

	/**
	 * 1クラスSVM
	 */
	ONE_CLASS(svm_parameter.ONE_CLASS),

	/**
	 * epsilon-SVM回帰
	 */
	EPSILON_SVR(svm_parameter.EPSILON_SVR),

	/**
	 * nu-SVM回帰
	 */
	NU_SVR(svm_parameter.NU_SVR);

	private int index;

	/**
	 * コンストラクタ
	 *
	 * @param index
	 */
	private SvmType(int index) {
		this.index = index;
	}

	/**
	 * int型に変換します．
	 *
	 * @return
	 */
	public int toInt() {
		return index;
	}

	/**
	 * <pre>
	 * intからEnumに変換します．
	 *
	 * 該当するものがない場合，nullを返します．
	 * </pre>
	 *
	 * @param num
	 * @return Enum
	 */
	public static SvmType toEnum(int num) {

		SvmType res = null;

		for(SvmType type : SvmType.values()) {
			if(num == type.toInt()) {
				res = type;
				break;
			}
		}
		return res;
	}

	/**
	 * <pre>
	 * StringからEnumに変換します．
	 *
	 * ただし，Stringがintに変換可能な場合に限ります．
	 * 該当するものがない場合，nullを返します．
	 * </pre>
	 *
	 * @param numStr
	 * @return Enum
	 */
	public static SvmType toEnum(String numStr) {
		return toEnum(Integer.valueOf(numStr));
	}
}
