package libsvm.wrapper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import libsvm.svm_node;
import libsvm.svm_problem;

/**
 * <pre>
 * 訓練
 * (svm_problem)
 * </pre>
 *
 * @author hirai
 */
public class SvmProblem {

	/**
	 * 学習用ベクトル
	 * key:特徴ベクトル value:クラスID
	 */
	private Map<SvmFeatureVector, Integer> learningVectors;

	/**
	 * クラスID集
	 */
	private Set<Integer> classIds;

	/**
	 * コンストラクタ
	 */
	public SvmProblem() {
		learningVectors = new HashMap<SvmFeatureVector, Integer>();
		classIds = new HashSet<Integer>();
	}

	/**
	 * @param vector 学習用ベクトル
	 * @param classId クラスID
	 */
	public void addSvmFeatureVector(SvmFeatureVector vector, int classId) {
		learningVectors.put(vector, classId);
		classIds.add(classId);
	}

	/**
	 * 利用可能な状態に変換します．
	 *
	 * @return
	 */
	public svm_problem toUsable() {

		svm_problem res = new svm_problem();

		res.l = learningVectors.size();

		res.y = new double[res.l];
		res.x = new svm_node[res.l][];

		int i = 0;
		for(SvmFeatureVector vector : learningVectors.keySet()) {
			int classId = learningVectors.get(vector);
			res.y[i] = classId;
			res.x[i] = vector.toUsable();
			i++;
		}
		return res;
	}

	/**
	 * @return 学習用ベクトルの数
	 */
	public int getNumOfLearningVector() {
		return learningVectors.size();
	}

	/**
	 * @return クラス数
	 */
	public int getNumOfClass() {
		return classIds.size();
	}
}
