package libsvm.wrapper;

import java.io.Serializable;

import libsvm.svm_model;

/**
 * <pre>
 * 学習によって生成されるモデル
 * このモデルを使うことで，クラスを予測する．
 * (svm_model)
 * </pre>
 *
 * @author hirainaoki
 */
public class SvmModel implements Serializable {

	private static final long serialVersionUID = -5170329022473899258L;

	private svm_model model;

	/**
	 * コンストラクタ
	 *
	 * @param model モデル
	 */
	public SvmModel(svm_model model) {
		this.model = model;
	}

	/**
	 * 利用可能な状態に変換します．
	 *
	 * @return
	 */
	public svm_model toUsable() {
		return model;
	}
}
