package libsvm.wrapper;

import libsvm.svm_parameter;

/**
 * カーネルの種類
 *
 * @author hirai
 */
public enum KernelType {

	/**
	 * u^t・v
	 */
	LINEAR(svm_parameter.LINEAR),

	/**
	 * (gamma * u^t・v + coef0)^degree
	 */
	POLY(svm_parameter.POLY),

	/**
	 * exp(-gamma * |u - v|^2)
	 */
	RBF(svm_parameter.RBF),

	/**
	 * tanh(gamma * u^t・v + coef0)
	 */
	SIGMOID(svm_parameter.SIGMOID),

	/**
	 * training set fileに記述したカーネル
	 */
	PRECOMPUTED(svm_parameter.PRECOMPUTED);

	private int index;

	/**
	 * コンストラクタ
	 *
	 * @param index
	 */
	private KernelType(int index) {
		this.index = index;
	}

	/**
	 * int型に変換します．
	 *
	 * @return
	 */
	public int toInt() {
		return index;
	}

	/**
	 * <pre>
	 * intからEnumに変換します．
	 *
	 * 該当するものがない場合，nullを返します．
	 * </pre>
	 *
	 * @param num
	 * @return Enum
	 */
	public static KernelType toEnum(int num) {

		KernelType res = null;

		for(KernelType type : KernelType.values()) {
			if(num == type.toInt()) {
				res = type;
				break;
			}
		}
		return res;
	}

	/**
	 * <pre>
	 * StringからEnumに変換します．
	 *
	 * ただし，Stringがintに変換可能な場合に限ります．
	 * 該当するものがない場合，nullを返します．
	 * </pre>
	 *
	 * @param numStr
	 * @return Enum
	 */
	public static KernelType toEnum(String numStr) {
		return toEnum(Integer.valueOf(numStr));
	}
}
