/*
 * Decompiled with CFR 0.152.
 */
package ignition;

import ignition.IgnitionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.uncommons.maths.random.PoissonGenerator;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardWorldModel;

public class RandomIgnitionModel
implements IgnitionModel {
    private static final String MEAN_KEY = "ignition.random.lambda";
    private PoissonGenerator generator;
    private Iterator<Building> it;

    public RandomIgnitionModel(StandardWorldModel world, Config config) {
        ArrayList<Building> unburnt = new ArrayList<Building>();
        for (StandardEntity next : world) {
            if (!(next instanceof Building)) continue;
            unburnt.add((Building)next);
        }
        Collections.shuffle(unburnt, config.getRandom());
        double mean = config.getFloatValue(MEAN_KEY);
        this.generator = new PoissonGenerator(mean, config.getRandom());
        this.it = unburnt.iterator();
    }

    @Override
    public Set<Building> findIgnitionPoints(StandardWorldModel world, int time) {
        HashSet<Building> result = new HashSet<Building>();
        if (this.it.hasNext()) {
            int number = this.generator.nextValue();
            Logger.debug((String)("Igniting " + number + " buildings"));
            for (int i = 0; i < number && this.it.hasNext(); ++i) {
                result.add(this.it.next());
            }
        }
        return result;
    }
}

