/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLCoordinates;
import maps.gml.GMLEdge;
import maps.gml.GMLNode;
import maps.gml.GMLObject;
import maps.gml.editor.AbstractTool;
import maps.gml.editor.GMLEditor;
import maps.gml.view.EdgeDecorator;
import maps.gml.view.LineEdgeDecorator;
import maps.gml.view.NodeDecorator;
import maps.gml.view.SquareNodeDecorator;

public class MergeLinesTool
extends AbstractTool {
    private static final Color HIGHLIGHT_COLOUR = Color.BLUE;
    private static final int HIGHLIGHT_SIZE = 6;
    private Listener listener = new Listener();
    private NodeDecorator nodeHighlight = new SquareNodeDecorator(HIGHLIGHT_COLOUR, 6);
    private EdgeDecorator edgeHighlight = new LineEdgeDecorator(HIGHLIGHT_COLOUR);
    private GMLNode selected = null;
    private Collection<GMLEdge> attachedEdges = new HashSet<GMLEdge>();

    public MergeLinesTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Merge lines";
    }

    @Override
    public void activate() {
        this.editor.getViewer().addMouseListener(this.listener);
        this.editor.getViewer().addMouseMotionListener(this.listener);
        this.selected = null;
        this.attachedEdges.clear();
    }

    @Override
    public void deactivate() {
        this.editor.getViewer().removeMouseListener(this.listener);
        this.editor.getViewer().removeMouseMotionListener(this.listener);
        this.editor.getViewer().clearAllNodeDecorators();
        this.editor.getViewer().clearAllEdgeDecorators();
        this.editor.getViewer().repaint();
    }

    private void highlightNode(GMLNode node, Collection<GMLEdge> attached) {
        if (this.selected == node) {
            return;
        }
        if (this.selected != null) {
            this.editor.getViewer().clearNodeDecorator(this.selected);
            this.editor.getViewer().clearEdgeDecorator(this.attachedEdges);
        }
        this.selected = node;
        this.attachedEdges.clear();
        if (this.selected != null) {
            this.attachedEdges.addAll(attached);
            this.editor.getViewer().setNodeDecorator(this.nodeHighlight, this.selected);
            this.editor.getViewer().setEdgeDecorator(this.edgeHighlight, this.attachedEdges);
        }
        this.editor.getViewer().repaint();
    }

    private class MergeEdit
    extends AbstractUndoableEdit {
        private GMLNode deletedNode;
        private Collection<GMLObject> deletedObjects;
        private GMLEdge newEdge;

        public MergeEdit(GMLNode node, Collection<GMLObject> deletedObjects, GMLEdge newEdge) {
            this.deletedNode = node;
            this.deletedObjects = deletedObjects;
            this.newEdge = newEdge;
        }

        @Override
        public void undo() {
            super.undo();
            MergeLinesTool.this.editor.getMap().addNode(this.deletedNode);
            MergeLinesTool.this.editor.getMap().add(this.deletedObjects);
            MergeLinesTool.this.editor.getMap().removeEdge(this.newEdge);
            MergeLinesTool.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            MergeLinesTool.this.editor.getMap().removeNode(this.deletedNode);
            MergeLinesTool.this.editor.getMap().remove(this.deletedObjects);
            MergeLinesTool.this.editor.getMap().addEdge(this.newEdge);
            MergeLinesTool.this.editor.getViewer().repaint();
        }
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = this.fixEventPoint(e.getPoint());
            GMLCoordinates c = MergeLinesTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
            GMLNode node = MergeLinesTool.this.editor.getMap().findNearestNode(c.getX(), c.getY());
            Collection<GMLEdge> attached = MergeLinesTool.this.editor.getMap().getAttachedEdges(node);
            if (attached.size() == 2) {
                MergeLinesTool.this.highlightNode(node, attached);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (MergeLinesTool.this.selected == null) {
                return;
            }
            if (e.getButton() == 1) {
                Iterator it = MergeLinesTool.this.attachedEdges.iterator();
                GMLEdge newEdge = MergeLinesTool.this.editor.getMap().mergeEdges((GMLEdge)it.next(), (GMLEdge)it.next());
                Collection<GMLObject> deleted = MergeLinesTool.this.editor.getMap().removeNode(MergeLinesTool.this.selected);
                MergeLinesTool.this.editor.setChanged();
                MergeLinesTool.this.editor.addEdit(new MergeEdit(MergeLinesTool.this.selected, deleted, newEdge));
                MergeLinesTool.this.highlightNode(null, null);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private Point fixEventPoint(Point p) {
            Insets insets = MergeLinesTool.this.editor.getViewer().getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

