/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import maps.convert.ConvertStep;
import maps.convert.osm2gml.ConvertTools;
import maps.convert.osm2gml.DirectedEdge;
import maps.convert.osm2gml.Edge;
import maps.convert.osm2gml.Node;
import maps.convert.osm2gml.TemporaryBuilding;
import maps.convert.osm2gml.TemporaryIntersection;
import maps.convert.osm2gml.TemporaryMap;
import maps.convert.osm2gml.TemporaryObject;
import maps.convert.osm2gml.TemporaryRoad;
import rescuecore2.log.Logger;

public class SplitShapesStep
extends ConvertStep {
    private TemporaryMap map;

    public SplitShapesStep(TemporaryMap map) {
        this.map = map;
    }

    @Override
    public String getDescription() {
        return "Splitting overlapping shapes";
    }

    @Override
    protected void step() {
        Collection<TemporaryObject> all = this.map.getAllObjects();
        this.setProgressLimit(all.size());
        int count = 0;
        this.debug.setBackground(ConvertTools.getAllDebugShapes(this.map));
        for (TemporaryObject shape : all) {
            count += this.splitShapeIfRequired(shape);
            this.bumpProgress();
        }
        this.setStatus("Added " + count + " new shapes");
    }

    private int splitShapeIfRequired(TemporaryObject shape) {
        HashSet<DirectedEdge> edgesRemaining = new HashSet<DirectedEdge>(shape.getEdges());
        boolean firstShape = true;
        int newShapeCount = 0;
        while (!edgesRemaining.isEmpty()) {
            DirectedEdge dEdge = (DirectedEdge)edgesRemaining.iterator().next();
            edgesRemaining.remove(dEdge);
            Node start = dEdge.getStartNode();
            Node end = dEdge.getEndNode();
            ArrayList<DirectedEdge> result = new ArrayList<DirectedEdge>();
            result.add(dEdge);
            Logger.debug((String)("Starting walk from " + dEdge));
            Logger.debug((String)("Start: " + start));
            Logger.debug((String)("End: " + end));
            while (!end.equals(start)) {
                DirectedEdge newDEdge;
                Set<Edge> candidates = this.map.getAttachedEdges(end);
                Edge turn = ConvertTools.findLeftTurn(dEdge, candidates);
                Logger.debug((String)("Best turn: " + turn));
                dEdge = newDEdge = new DirectedEdge(turn, end);
                end = dEdge.getEndNode();
                edgesRemaining.remove(dEdge);
                result.add(dEdge);
                Logger.debug((String)("Added " + dEdge));
                Logger.debug((String)("New end: " + end));
            }
            if (firstShape && edgesRemaining.isEmpty()) continue;
            if (firstShape) {
                this.map.removeTemporaryObject(shape);
                firstShape = false;
            } else {
                ++newShapeCount;
            }
            TemporaryObject newObject = null;
            if (shape instanceof TemporaryRoad) {
                newObject = new TemporaryRoad(result);
            }
            if (shape instanceof TemporaryIntersection) {
                newObject = new TemporaryIntersection(result);
            }
            if (shape instanceof TemporaryBuilding) {
                newObject = new TemporaryBuilding(result, ((TemporaryBuilding)shape).getBuildingID());
            }
            this.map.addTemporaryObject(newObject);
        }
        return newShapeCount;
    }
}

