/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.legacy2gml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import maps.convert.legacy2gml.NodeInfo;
import maps.convert.legacy2gml.RoadInfo;
import maps.convert.legacy2gml.Tools;
import maps.gml.GMLBuilding;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLMap;
import maps.gml.GMLNode;
import maps.gml.GMLRoad;
import maps.legacy.LegacyBuilding;
import rescuecore2.log.Logger;
import rescuecore2.misc.Pair;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.geometry.Vector2D;

public class BuildingInfo {
    private static final int ENTRANCE_SIZE = 2500;
    private LegacyBuilding building;
    private List<GMLNode> apexes;

    public BuildingInfo(LegacyBuilding b) {
        this.building = b;
    }

    public void process(GMLMap gml, Map<Integer, NodeInfo> nodeInfo, Map<Integer, RoadInfo> roadInfo) {
        this.apexes = new ArrayList<GMLNode>();
        int[] coords = this.building.getApexes();
        for (int i = 0; i < coords.length; i += 2) {
            int x = coords[i];
            int y = coords[i + 1];
            GMLNode node = gml.createNode(x, y);
            this.apexes.add(node);
        }
        GMLBuilding b = gml.createBuildingFromNodes(this.apexes);
        b.setFloors(this.building.getFloors());
        b.setCode(this.building.getCode());
        Point2D entrancePoint = nodeInfo.get(this.building.getEntrances()[0]).getLocation();
        Point2D centre = new Point2D((double)this.building.getX(), (double)this.building.getY());
        Line2D centreLine = new Line2D(centre, entrancePoint);
        Vector2D centreVector = centreLine.getDirection();
        Vector2D leftVector = centreVector.getNormal().normalised().scale(1250.0);
        Vector2D rightVector = leftVector.scale(-1.0);
        Line2D left = new Line2D(centre.plus(leftVector), centreVector);
        Line2D right = new Line2D(centre.plus(rightVector), centreVector);
        Pair<Line2D, GMLDirectedEdge> leftEntrance = this.getEntrancePoint(left, centreLine, b.getEdges(), true, true);
        if (leftEntrance == null) {
            Logger.warn((String)(b + ": Left entrance line does not intersect any walls"));
            return;
        }
        GMLNode leftNode = gml.createNode(((Line2D)leftEntrance.first()).getOrigin().getX(), ((Line2D)leftEntrance.first()).getOrigin().getY());
        gml.splitEdge(((GMLDirectedEdge)leftEntrance.second()).getEdge(), leftNode);
        Pair<Line2D, GMLDirectedEdge> rightEntrance = this.getEntrancePoint(right, centreLine, b.getEdges(), false, true);
        if (rightEntrance == null) {
            Logger.warn((String)(b + ": Right entrance line does not intersect any walls"));
            return;
        }
        GMLNode rightNode = gml.createNode(((Line2D)rightEntrance.first()).getOrigin().getX(), ((Line2D)rightEntrance.first()).getOrigin().getY());
        gml.splitEdge(((GMLDirectedEdge)rightEntrance.second()).getEdge(), rightNode);
        Pair<Line2D, GMLDirectedEdge> leftRoad = this.getEntrancePoint(left, centreLine, this.getAllRoadEdges(nodeInfo.values(), roadInfo.values()), true, false);
        if (leftRoad == null) {
            Logger.warn((String)(b + ": Left entrance line does not intersect any roads"));
            return;
        }
        GMLNode roadLeftNode = gml.createNode(((Line2D)leftRoad.first()).getEndPoint().getX(), ((Line2D)leftRoad.first()).getEndPoint().getY());
        gml.splitEdge(((GMLDirectedEdge)leftRoad.second()).getEdge(), roadLeftNode);
        Pair<Line2D, GMLDirectedEdge> rightRoad = this.getEntrancePoint(right, centreLine, this.getAllRoadEdges(nodeInfo.values(), roadInfo.values()), false, false);
        if (rightRoad == null) {
            Logger.warn((String)(b + ": Right entrance line does not intersect any roads"));
            return;
        }
        GMLNode roadRightNode = gml.createNode(((Line2D)rightRoad.first()).getEndPoint().getX(), ((Line2D)rightRoad.first()).getEndPoint().getY());
        gml.splitEdge(((GMLDirectedEdge)rightRoad.second()).getEdge(), roadRightNode);
        gml.createRoad(gml.apexesToEdges(roadLeftNode, roadRightNode, rightNode, leftNode));
    }

    private Pair<Line2D, GMLDirectedEdge> trim(Line2D line, Collection<GMLDirectedEdge> walls, boolean trimStart) {
        GMLDirectedEdge wall = null;
        for (GMLDirectedEdge next : walls) {
            Point2D p = GeometryTools2D.getSegmentIntersectionPoint((Line2D)line, (Line2D)Tools.gmlDirectedEdgeToLine(next));
            if (p == null) continue;
            line = trimStart ? new Line2D(p, line.getEndPoint()) : new Line2D(line.getOrigin(), p);
            wall = next;
        }
        if (wall == null) {
            return null;
        }
        return new Pair((Object)line, wall);
    }

    private Pair<Line2D, GMLDirectedEdge> getEntrancePoint(Line2D line, Line2D centre, Collection<GMLDirectedEdge> walls, boolean left, boolean trimStart) {
        Pair<Line2D, GMLDirectedEdge> trimmed = this.trim(line, walls, trimStart);
        if (trimmed == null) {
            Vector2D wallDirection;
            trimmed = this.trim(centre, walls, trimStart);
            if (trimmed == null) {
                return null;
            }
            GMLDirectedEdge wall = (GMLDirectedEdge)trimmed.second();
            Line2D wallLine = Tools.gmlDirectedEdgeToLine(wall);
            Vector2D centreNormal = centre.getDirection().getNormal().normalised();
            if (!left) {
                centreNormal = centreNormal.scale(-1.0);
            }
            Point2D end = (wallDirection = wallLine.getDirection().normalised()).dot(centreNormal) > 0.0 ? wallLine.getEndPoint() : wallLine.getOrigin();
            return new Pair((Object)new Line2D(end, line.getEndPoint()), (Object)wall);
        }
        return trimmed;
    }

    private Collection<GMLDirectedEdge> getAllRoadEdges(Collection<NodeInfo> nodes, Collection<RoadInfo> roads) {
        HashSet<GMLDirectedEdge> all = new HashSet<GMLDirectedEdge>();
        for (NodeInfo nodeInfo : nodes) {
            GMLRoad r = nodeInfo.getRoad();
            if (r == null) continue;
            all.addAll(r.getEdges());
        }
        for (RoadInfo roadInfo : roads) {
            all.addAll(roadInfo.getRoad().getEdges());
        }
        return all;
    }
}

