/*
 * Decompiled with CFR 0.152.
 */
package maps.legacy;

import java.io.File;
import java.io.IOException;
import maps.Map;
import maps.MapException;
import maps.MapFormat;
import maps.legacy.LegacyMap;

public final class LegacyMapFormat
implements MapFormat {
    public static final LegacyMapFormat INSTANCE = new LegacyMapFormat();

    private LegacyMapFormat() {
    }

    @Override
    public LegacyMap read(File file) throws MapException {
        try {
            return new LegacyMap(file);
        }
        catch (IOException e) {
            throw new MapException(e);
        }
    }

    @Override
    public void write(Map map, File file) throws MapException {
        throw new RuntimeException("LegacyMapFormat.write not implemented");
    }

    @Override
    public boolean canRead(File file) throws MapException {
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        File road = new File(file, "road.bin");
        File node = new File(file, "node.bin");
        File building = new File(file, "building.bin");
        return road.exists() && node.exists() && building.exists();
    }
}

