/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.util.Collection;
import java.util.HashSet;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLEdge;
import maps.gml.editor.AbstractFunction;
import maps.gml.editor.GMLEditor;
import rescuecore2.log.Logger;

public class PruneOrphanEdgesFunction
extends AbstractFunction {
    public PruneOrphanEdgesFunction(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Prune orphaned edges";
    }

    @Override
    public void execute() {
        HashSet<GMLEdge> remaining = new HashSet<GMLEdge>(this.editor.getMap().getEdges());
        HashSet<GMLEdge> deleted = new HashSet<GMLEdge>();
        for (GMLEdge next : remaining) {
            if (!this.editor.getMap().getAttachedShapes(next).isEmpty()) continue;
            this.editor.getMap().removeEdge(next);
            deleted.add(next);
        }
        if (!deleted.isEmpty()) {
            this.editor.setChanged();
            this.editor.getViewer().repaint();
        }
        Logger.debug((String)("Removed " + deleted.size() + " edges"));
        this.editor.addEdit(new DeleteEdgesEdit(deleted));
    }

    private class DeleteEdgesEdit
    extends AbstractUndoableEdit {
        private Collection<GMLEdge> edges;

        public DeleteEdgesEdit(Collection<GMLEdge> edges) {
            this.edges = edges;
        }

        @Override
        public void undo() {
            super.undo();
            PruneOrphanEdgesFunction.this.editor.getMap().add(this.edges);
            PruneOrphanEdgesFunction.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            PruneOrphanEdgesFunction.this.editor.getMap().remove(this.edges);
            PruneOrphanEdgesFunction.this.editor.getViewer().repaint();
        }
    }
}

